<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 	   		 */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     | 
// +----------------------------------------------------------------------+
// | Authors: Aswin<aswin.j@armiasystems.com>             		          |
// +----------------------------------------------------------------------+
App::uses('AppModel', 'Model');
class Vendor extends AppModel
{

  	var $name 		= 'Vendor';
	var $validate  = array('email' => array('rule' => 'email', 'message' => 'Invalid email Id')); 
	
	function delete_vendor($vid)
	{
		$tbl = $this->getTableName('vendors');
		$this->query("DELETE FROM $tbl WHERE id = $vid");
		return true;
	}
	
	function getDetails($id)
	{
		$order_tbl = $this->getTableName('order_details');
		$proddet_tbl = $this->getTableName('productdetails');
		$cust_tbl = $this->getTableName('customfieldvalues');
		$prod_tbl = $this->getTableName('products');
		
		$qry = $this->query("SELECT P.pname, PD.customvalue_id FROM $order_tbl O, $proddet_tbl PD, $prod_tbl P 
							 WHERE O.product_id = P.id AND O.combination_id = PD.id AND O.id = $id");
		$comb = explode(",",$qry[0]['PD']['customvalue_id']);
		if(!is_array($comb)) $comb[0] = $comb;

		foreach($comb as $val){
                    if($val){
                        $cmbqry = $this->query("SELECT CS.custom_value FROM $cust_tbl CS WHERE CS.id = {$val}");
			$combinations[] = $cmbqry[0]['CS']['custom_value'];
                }
		}
		$combName = implode(",",$combinations);
		$prodName = $qry[0]['P']['pname'];
		return "$prodName [$combName]";
	}
	
	function findorder($id)
	{
		$vend_tbl = $this->getTableName('vendors');
		$ord_tbl = $this->getTableName('vendororders');
		$res = $this->query("SELECT V.name, O.* FROM $vend_tbl V, $ord_tbl O WHERE O.vendor_id = V.id AND O.order_detail_id = $id");
		return $res;
	}
	
	function deletevorder($id)
	{
		$ord_tbl = $this->getTableName('vendororders');
		$this->query("DELETE FROM $ord_tbl WHERE id = $id");
		return true;
	}
	
	function findvendors($id)
	{
		$ord_tbl = $this->getTableName('vendororders');
		$res = $this->query("SELECT O.vendor_id FROM $ord_tbl O WHERE O.order_detail_id = $id");
		if($res){
			foreach($res as $val){
				$op[] = $val['O']['vendor_id'];
			}
			$venList = implode(",",$op);
			return $venList;
		}
		else return 0;
	}
	
	function vendordetails($id)
	{
		$vend_tbl = $this->getTableName('vendors');
		$ord_tbl = $this->getTableName('vendororders');
		
		$qry = $this->query("SELECT V.name, V.email, O.quantity, O.ordered_date FROM $vend_tbl V, $ord_tbl O WHERE O.vendor_id = V.id AND O.id = $id");
		return $qry;
	}
	
	function vendorder($vid, $from, $to, $page, $offset ,$nopage = false)
	{
		$vend_tbl = $this->getTableName('vendors');
		$ord_tbl = $this->getTableName('vendororders');
		$tmp = explode("-",$from);
		$from = date("Y-m-d",strtotime($tmp[1]."-".$tmp[0]."-".$tmp[2]));
		$tmp = explode("-",$to);
		$to = date("Y-m-d",strtotime($tmp[1]."-".$tmp[0]."-".$tmp[2]));
		
		if($nopage) $pager = '';
		else $pager = "LIMIT $page, $offset";
		if($vid){
		$qry = $this->query("SELECT V.name, V.email, O.quantity, O.order_detail_id, O.ordered_date FROM $vend_tbl V, $ord_tbl O WHERE O.vendor_id = V.id AND V.id = $vid AND O.ordered_date BETWEEN '$from' AND '$to' ORDER BY O.ordered_date DESC $pager");
		foreach($qry as $key=>$val)
		{
			$qry[$key]['O']['prd_detail'] = $this->getDetails($val['O']['order_detail_id']);
		}
		return $qry;
                }else{
                    return NULL;
                }
	}
	
	function vendordercount($vid, $from, $to)
	{
		$vend_tbl = $this->getTableName('vendors');
		$ord_tbl = $this->getTableName('vendororders');
		$tmp = explode("-",$from);
		$from = date("Y-m-d",strtotime($tmp[1]."-".$tmp[0]."-".$tmp[2]));
		$tmp = explode("-",$to);
		$to = date("Y-m-d",strtotime($tmp[1]."-".$tmp[0]."-".$tmp[2]));
                if($vid){
		$qry = $this->query("SELECT COUNT(O.id) AS cnt FROM $vend_tbl V, $ord_tbl O WHERE O.vendor_id = V.id AND V.id = $vid AND O.ordered_date BETWEEN '$from' AND '$to'");
		return $qry[0][0]['cnt'];
                }else{
                    return 0;
                }
	}
	
	function getTableName($tablename)
	{
		$Db = ConnectionManager::getDataSource($this->useDbConfig);
		$tblnme = $Db->fullTableName($tablename);			
		$tblnme=trim(str_replace('`','',$tblnme));		
		return $tblnme;
	}
}
