<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('Component', 'Controller');
	class UpsshippingComponent extends Component
	{
		var $components = array('Httpclient');

		 function upsProduct($prod)
	{
     $ups_types=array('1DM' => 'Next Day Air Early AM',
				 '1DA' => 'Next Day Air',
				 '1DP' => 'Next Day Air Saver',
				 '2DM' => '2nd Day Air Early AM',
				 '2DA' => '2nd Day Air',
				 '3DS' => '3 Day Select',
				 'GND' => 'UPS Ground',
				 'STD' => 'Canada Standard',
				 'XPR' => 'Worldwide Express',
				 'XDM' => 'Worldwide Express Plus',
				 'XPD' => 'Worldwide Expedited');
      $this->upsProductCode = $prod;
    }

    function credentials($upsUserId, $upsAccessLicenseNumber,$upsPassword, $upsShipperNumber){
        $this->upsUserId = $upsUserId;
        $this->upsAccessLicenseNumber = $upsAccessLicenseNumber;
        $this->upsPassword = $upsPassword;
        $this->upsShipperNumber = $upsShipperNumber;
    }
    
    function conversionrate($conversionrate){
        $this->conversionRate = $conversionrate;
        
    }
    function origin($postal, $country){
      $this->originPostalCode = $postal;
      $this->originCountryCode = $country;
    }

    function dest($postal, $country){
      $this->destPostalCode = $postal;
          $this->destCountryCode = $country;
    }

    function rate($foo){
      switch($foo){
        case "RDP":
          $this->rateCode = "Regular+Daily+Pickup";
          break;
        case "OCA":
          $this->rateCode = "On+Call+Air";
          break;
        case "OTP":
          $this->rateCode = "One+Time+Pickup";
          break;
        case "LC":
          $this->rateCode = "Letter+Center";
          break;
        case "CC":
          $this->rateCode = "Customer+Counter";
          break;
      }
    }

    function container($foo){
          switch($foo){
        case "CP":            // Customer Packaging
          $this->containerCode = "00";
          break;
        case "ULE":        // UPS Letter Envelope
          $this->containerCode = "01";
          break;
        case "UT":            // UPS Tube
          $this->containerCode = "03";
          break;
        case "UEB":            // UPS Express Box
          $this->containerCode = "21";
          break;
        case "UW25":        // UPS Worldwide 25 kilo
          $this->containerCode = "24";
          break;
        case "UW10":        // UPS Worldwide 10 kilo
          $this->containerCode = "25";
          break;
      }
    }

    function weight($foo){
      $this->packageWeight = $foo;
    }

    function rescom($foo){
          switch($foo){
        case "RES":            // Residential Address
          $this->resComCode = "1";
          break;
        case "COM":            // Commercial Address
          $this->resComCode = "2";
          break;
          }
    }

   /* function getQuote(){
          $upsAction = "3"; // You want 3.  Don't change unless you aresure.
      $url = join("&",

array("http://www.ups.com/using/services/rave/qcostcgi.cgi?accept_UPS_license_agreement=yes",
                     "10_action=$upsAction",
                     "13_product=$this->upsProductCode",
                     "14_origCountry=$this->originCountryCode",
                     "15_origPostal=$this->originPostalCode",
                     "19_destPostal=$this->destPostalCode",
                     "22_destCountry=$this->destCountryCode",
                     "23_weight=$this->packageWeight",
                     "47_rateChart=$this->rateCode",
                     "48_container=$this->containerCode",
                     "49_residential=$this->resComCode"
           )
                );
	
	

			
      $fp = fopen($url, "r");
	  
      while(!feof($fp)){
        $result = fgets($fp, 500);
        $result = explode("%", $result);
		
        $errcode = substr($result[0], -1);
        switch($errcode){
          case 3:
            $returnval = $result[8];
                break;
        /*  case 4:
            $returnval = $result[8];
            break;
          case 5:
            $returnval = $result[1];
            break;
          case 6:
            $returnval = $result[1];
            break;*/
      //  }
     // }
     /* fclose($fp);
          if(! $returnval)
		   { $returnval = "error"; }
      		  return $returnval;
    } */
      
      function getQuote(){
          $data ="<?xml version=\"1.0\"?>
    	<AccessRequest xml:lang=\"en-US\">
    		<AccessLicenseNumber>$this->upsAccessLicenseNumber</AccessLicenseNumber>
    		<UserId>$this->upsUserId</UserId>
    		<Password>$this->upsPassword</Password>
    	</AccessRequest>
    	<?xml version=\"1.0\"?>
    	<RatingServiceSelectionRequest xml:lang=\"en-US\">
    		<Request>
    			<TransactionReference>
    				<CustomerContext>Bare Bones Rate Request</CustomerContext>
    				<XpciVersion>1.0001</XpciVersion>
    			</TransactionReference>
    			<RequestAction>Rate</RequestAction>
    			<RequestOption>Rate</RequestOption>
    		</Request>
    	<PickupType>
    		<Code>01</Code>
    	</PickupType>
    	<Shipment>
    		<Shipper>
    			<Address>
    				<PostalCode>$this->originPostalCode</PostalCode>
    				<CountryCode>$this->originCountryCode</CountryCode>
    			</Address>
			<ShipperNumber>$this->upsShipperNumber</ShipperNumber>
    		</Shipper>
    		<ShipTo>
    			<Address>
    				<PostalCode>$this->destPostalCode</PostalCode>
    				<CountryCode>$this->destCountryCode</CountryCode>
				<ResidentialAddressIndicator/>
    			</Address>
    		</ShipTo>
    		<ShipFrom>
    			<Address>
    				<PostalCode>$this->originPostalCode</PostalCode>
    				<CountryCode>$this->originCountryCode</CountryCode>
    			</Address>
    		</ShipFrom>
    		<Service>
    			<Code>$this->upsProductCode</Code>
    		</Service>
    		<Package>
    			<PackagingType>
    				<Code>02</Code>
    			</PackagingType>
    			
    			<PackageWeight>
    				<UnitOfMeasurement>
    					<Code>LBS</Code>
    				</UnitOfMeasurement>
    				<Weight>$this->packageWeight</Weight>
    			</PackageWeight>
    		</Package>
    	</Shipment>
    	</RatingServiceSelectionRequest>";
       
    	$ch = curl_init("https://www.ups.com/ups.app/xml/Rate");
    	curl_setopt($ch, CURLOPT_HEADER, 1);
    	curl_setopt($ch,CURLOPT_POST,1);
    	curl_setopt($ch,CURLOPT_TIMEOUT, 60);
    	curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
    	curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, 0);
    	curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);
    	curl_setopt($ch,CURLOPT_POSTFIELDS,$data);
    	$result=curl_exec ($ch);
   
    	$data = strstr($result, '<?');
    	$xml_parser = xml_parser_create();
    	xml_parse_into_struct($xml_parser, $data, $vals, $index);
    	xml_parser_free($xml_parser);
    	$params = array();
    	$level = array();
    	foreach ($vals as $xml_elem) {
    	 if ($xml_elem['type'] == 'open') {
    	if (array_key_exists('attributes',$xml_elem)) {
    		 list($level[$xml_elem['level']],$extra) = array_values($xml_elem['attributes']);
    	} else {
    		 $level[$xml_elem['level']] = $xml_elem['tag'];
    	}
    	 }
    	 if ($xml_elem['type'] == 'complete') {
    	$start_level = 1;
    	$php_stmt = '$params';
    	while($start_level < $xml_elem['level']) {
    		 $php_stmt .= '[$level['.$start_level.']]';
    		 $start_level++;
    	}
    	$php_stmt .= '[$xml_elem[\'tag\']] = $xml_elem[\'value\'];';
    	eval($php_stmt);
    	 }
    	}
      
    	curl_close($ch);
        $returnval = $params['RATINGSERVICESELECTIONRESPONSE']['RATEDSHIPMENT']['TOTALCHARGES']['MONETARYVALUE'];
        if(empty($returnval)){ 
            $returnval = "error"; 
            
        }else if($this->originCountryCode == 'CA' && isset($this->conversionRate)){
            $returnval = $params['RATINGSERVICESELECTIONRESPONSE']['RATEDSHIPMENT']['TOTALCHARGES']['MONETARYVALUE'] * $this->conversionRate;
        }
      		  return $returnval;
      }
      
     
}
?>