<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2010 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts VistaCart                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('Component', 'Controller');
class FedexComponent extends Component{
	var $components = array('Xmlparser', 'Fedexprice','Fedexerror');
	var $server = "https://gatewaybeta.fedex.com/GatewayDC";
    var $accountNumber;
    var $meterNumber;
    var $carrierCode = "FDXG";
    var $dropoffType = "REGULARPICKUP";
    var $service;
    var $serviceName;
    var $packaging = "YOURPACKAGING";
    var $weightUnits = "LBS";
    var $weight;
    // Origin Address
    var $originStateOrProvinceCode;
    var $originPostalCode;
    var $originCountryCode;
    // Destination Address
    var $destStateOrProvinceCode;
    var $destPostalCode;
    var $destCountryCode;
    var $payorType = "SENDER";
    
    
    // Functions    
    function setServer($server) {
        $this->server = $server;
    }

    function setAccountNumber($accountNumber) {
        $this->accountNumber = $accountNumber;
    }

    function setMeterNumber($meterNumber) {
        $this->meterNumber = $meterNumber;
    }

    function setCarrierCode($carrierCode) {
        $this->carrierCode = $carrierCode;
    }
    
    function setDropoffType($dropoffType) {
        $this->dropoffType = $dropoffType;
    }

    function setService($service, $name) {
        $this->service = $service;
        $this->serviceName = $name;
    }

    function setPackaging($packaging) {
        $this->packaging = $packaging;
    }
    
    function setWeightUnits($units) {
        $this->weightUnits = $units;
    }
    
    function setWeight($weight) {
        $this->weight = $weight;
    }
    
    function setOriginStateOrProvinceCode($code) {
        $this->originStateOrProvinceCode = $code;
    }
    
    function setOriginPostalCode($code) {
        $this->originPostalCode = $code;
    }
    
    function setOriginCountryCode($code) {
        $this->originCountryCode = $code;
    }
    
    function setDestStateOrProvinceCode($code) {
        $this->destStateOrProvinceCode = $code;
    }
    
    function setDestPostalCode($code) {
        $this->destPostalCode = $code;
    }
    
    function setDestCountryCode($code) {
        $this->destCountryCode = $code;
    }
    
    function setPayorType($type) {
        $this->payorType = $type;
    }
    
    function getPrice() {  
        
         /***************
        $this->setServer("https://gatewaybeta.fedex.com/GatewayDC");
        $this->setAccountNumber(510087380); // You need your own
        $this->setMeterNumber(118562832);    // You need your own
        $this->setCarrierCode("FDXG");
        $this->setDropoffType("REGULARPICKUP");
        $this->setService('FEDEXGROUND', 'FedEx Ground');
        $this->setPackaging("YOURPACKAGING");
        $this->setWeightUnits("LBS");
        $this->setWeight("3.33");
        $this->setOriginStateOrProvinceCode("MO");
        $this->setOriginPostalCode(63110);
        $this->setOriginCountryCode("US");
        $this->setDestStateOrProvinceCode("MA");
        $this->setDestPostalCode("02116");
        $this->setDestCountryCode("US");
        $this->setPayorType("SENDER");
        /*****************/       
   
        $str = '<?xml version="1.0" encoding="UTF-8" ?>';
        $str .= '    <FDXRateRequest xmlns:api="http://www.fedex.com/fsmapi" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="FDXRateRequest.xsd">';
        $str .= '        <RequestHeader>';
        $str .= '            <CustomerTransactionIdentifier>Express Rate</CustomerTransactionIdentifier>';
        $str .= '            <AccountNumber>'.$this->accountNumber.'</AccountNumber>';
        $str .= '            <MeterNumber>'.$this->meterNumber.'</MeterNumber>';
        $str .= '            <CarrierCode>'.$this->carrierCode.'</CarrierCode>';
        $str .= '        </RequestHeader>';
        $str .= '        <DropoffType>'.$this->dropoffType.'</DropoffType>';
        $str .= '        <Service>'.$this->service.'</Service>';
        $str .= '        <Packaging>'.$this->packaging.'</Packaging>';
        $str .= '        <WeightUnits>'.$this->weightUnits.'</WeightUnits>';
        $str .= '        <Weight>'.number_format($this->weight, 1, '.', '').'</Weight>';
        $str .= '        <OriginAddress>';
        $str .= '            <StateOrProvinceCode>'.$this->originStateOrProvinceCode.'</StateOrProvinceCode>';
        $str .= '            <PostalCode>'.$this->originPostalCode.'</PostalCode>';
        $str .= '            <CountryCode>'.$this->originCountryCode.'</CountryCode>';
        $str .= '        </OriginAddress>';
        $str .= '        <DestinationAddress>';
        $str .= '            <StateOrProvinceCode>'.$this->destStateOrProvinceCode.'</StateOrProvinceCode>';
        $str .= '            <PostalCode>'.$this->destPostalCode.'</PostalCode>';
        $str .= '            <CountryCode>'.$this->destCountryCode.'</CountryCode>';
        $str .= '        </DestinationAddress>';
        $str .= '        <Payment>';
        $str .= '            <PayorType>'.$this->payorType.'</PayorType>';
        $str .= '        </Payment>';
        $str .= '        <PackageCount>'.ceil(bcdiv(number_format($this->weight, 1, '.', ''), '150', 3)).'</PackageCount>';
        $str .= '    </FDXRateRequest>';

$header[] = "Host: iscripts.com";
$header[] = "MIME-Version: 1.0";
$header[] = "Content-type: multipart/mixed; boundary=â€”-doc";
$header[] = "Accept: text/xml";
$header[] = "Content-length: ".strlen($str);
$header[] = "Cache-Control: no-cache";
$header[] = "Connection: close \r\n";
$header[] = $str;

$ch = curl_init();
//Disable certificate check.
// uncomment the next line if you get curl error 60: error setting certificate verify locations
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
// uncommenting the next line is most likely not necessary in case of error 60
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
//â€”â€”â€”â€”â€”â€”â€”â€”-
//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
//curl_setopt($ch, CURLOPT_CAINFO, "c:/ca-bundle.crt");
//â€”â€”â€”â€”â€”â€”â€”â€”-
curl_setopt($ch, CURLOPT_URL,$this->server);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 4);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST,'POST');
curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

//echo '<br> server :'. $this->server;
//echo '<br> header :'. print_r($header);
$data = curl_exec($ch);

//print_r($data);

if (curl_errno($ch)) {
$this->getPrice();
} else {
// close curl resource, and free up system resources
curl_close($ch);
//$xmlParser = new xmlparser();
$array = $this->Xmlparser->GetXMLTree($data);
//$xmlParser->printa($array);
if (!empty($array['FDXRATEREPLY'])) {
if(!empty($array['FDXRATEREPLY'][0]['ERROR'])) { // If it is error
//$error = new fedexError();
$this->Fedexerror->number = $array['FDXRATEREPLY'][0]['ERROR'][0]['CODE'][0]['VALUE'];
$this->Fedexerror->description = $array['FDXRATEREPLY'][0]['ERROR'][0]['MESSAGE'][0]['VALUE'];
$this->Fedexerror->response = $array;
$this->error = $this->Fedexerror;
} else if (count($array['FDXRATEREPLY'][0]['ESTIMATEDCHARGES'][0]['DISCOUNTEDCHARGES'][0]['NETCHARGE'])) {
//$price = new fedexPrice();
$this->Fedexprice->rate = $array['FDXRATEREPLY'][0]['ESTIMATEDCHARGES'][0]['DISCOUNTEDCHARGES'][0]['NETCHARGE'][0]['VALUE'];
$this->Fedexprice->service = $this->serviceName;
$this->Fedexprice->response = $array;
$this->price = $this->Fedexprice; 
}
}
//print_r($this); echo " Test1: "; exit();
return $this;
}
    }
}
?>