<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 0.2.9
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 */
 
/**
 * Here, we are connecting '/' (base path) to controller called 'Pages',
 * its action called 'display', and we pass a param to select the view file
 * to use (in this case, /app/View/Pages/home.ctp)...
 */
 	Router::connect('/', array('controller' => 'pages', 'action' => 'display', 'home'));
/* For Cloud */
	Router::connect('/admin/index.php',array('controller' => 'admins', 'action' => 'index'));
	Router::connect('/admin/validate_admin.php',array('controller' => 'admins', 'action' => 'validate_admin'));
	
	/* End */
	Router::connect('/admin/*',array('controller' => 'admins', 'action' => 'index'));
/**
 * ...and connect the rest of 'Pages' controller's urls.
 */
	Router::connect('/pages/*', array('controller' => 'pages', 'action' => 'display'));
        
        
        //Router::connect('/products/*/*', array('controller' => 'products', 'action' => 'show'));
 //Router::connect('/products/showcustomfields/:id1/:id2/:id3/:id4', array('controller' => 'products', 'action' => 'showcustomfields'), array('pass' => array('id1','id2','id3','id4')));
Router::connect('/products/availablecombinations/:id', array('controller' => 'products', 'action' => 'availablecombinations'), array('pass' => array('id')));
Router::connect('/products/add', array('controller' => 'products', 'action' => 'add'), array());
 Router::connect('/products/getproducts/:id', array('controller' => 'products', 'action' => 'getproducts'), array('pass' => array('id')));
 Router::connect('/products/showajaxthumb/:id', array('controller' => 'products', 'action' => 'showajaxthumb'), array('pass' => array('id')));
 Router::connect('/products/showajaxthumb/:id', array('controller' => 'products', 'action' => 'showajaxthumb'), array('pass' => array('id')));
 Router::connect('/products/add_dimensions/:id', array('controller' => 'products', 'action' => 'add_dimensions'), array('pass' => array('id')));
// Router::connect('/products/allproducts/:page', array('controller' => 'products', 'action' => 'allproducts'), array('pass' => array('page')));
 
 Router::connect('/products/addpricerates/:id', array('controller' => 'products', 'action' => 'addpricerates'), array('pass' => array('id')));
 // Router::connect('/products/showcombnimage/:id1/:id2/:id3/:id4/:id5', array('controller' => 'products', 'action' => 'showcombnimage'), array('pass' => array('id1','id2','id3','id4','id5')));
    
//Router::connect('/products/externalupload/:page', array('controller' => 'products', 'action' => 'externalupload'), array('pass' => array('page')));
Router::connect('/products/productExternaldelete/:id', array('controller' => 'products', 'action' => 'productExternaldelete'), array('pass' => array('id')));
Router::connect('/products/checksubcat/:id', array('controller' => 'products', 'action' => 'checksubcat'), array('pass' => array('id')));

Router::connect('/products/getcombinations/:id', array('controller' => 'products', 'action' => 'getcombinations'), array('pass' => array('id')));
Router::connect('/products/delete/:id', array('controller' => 'products', 'action' => 'delete'), array('pass' => array('id')));

        Router::connect('/products/:name/:id', array('controller' => 'products', 'action' => 'show'), array('pass' => array('name','id')));
        
/**
 * Then we connect url '/test' to our test controller. This is helpful in
 * developement.
 */
	Router::connect('/tests', array('controller' => 'tests', 'action' => 'index'));

 	CakePlugin::routes();

/**
 * Load the CakePHP default routes. Only remove this if you do not want to use
 * the built-in default routes.
 */
	require CAKE . 'Config' . DS . 'routes.php';
?>