<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    | 
// +----------------------------------------------------------------------+
// | Authors: Aswin<aswin.j@armiasystems.com>             		          |
// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');
class MessagesController extends AppController
{
	var $name = "Message";
	var $uses = array('Message', 'User', 'Cart', 'Category', 'Cmspage','Dynamicpage');
	var $belongsTo = array('User','Admin');
	var $helpers = array('Html', 'Form', 'Pagination','Js');
	
	function index(){ 
		$this->__validateLoginStatus();		
		$admsess	=	$this->Session->read('Admin');
		if($admsess["products"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		$posts = $this->Message->find("threaded", array('order' => 'Message.posted_date DESC'));		

		$users = $this->User->find("list", array('order' => 'User.uname', 'conditions' => array('User.reg_status =' => 'R'),'fields' => array('User.id', 'User.uname')));
		$this->set('posts', $posts);
		$this->set('users', $users);
		$this->layout = 'adm';
	}
	
	function userboard(){
		$this->__validateLoginStatus('U');		
		
		$sess_arr = $this->Session->read('Userlog');
		if(isset($sess_arr) && empty($sess_arr)===false){     
          $this->set('sus', $sess_arr);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sess_arr['id'])));  
        }  
        else {
          $this->set('sus', ''); 
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid))); 
        }
        $this->set('cartcount', count($citem));
		$uid = $sess_arr['id'];		

                $this->set('sus', $sess_arr);
                
                
		$posts = $this->Message->find("threaded", array('order' => 'Message.posted_date DESC', 'conditions' => array('Message.user_id' => array(0, $uid))));
		$this->set('posts', $posts);
		$this->set('uid', $uid);
	}
	
	function postmessage(){
		$msg['Message']['user_id'] = $_POST['usersList'];
		$msg['Message']['admin_id'] = 1;
		$msg['Message']['by_admin'] = $_POST['by_admin'];
		$msg['Message']['content'] = strip_tags(trim($_POST['postMessage']));
		$msg['Message']['posted_date'] = date("Y-m-d H:i:s");
		$msg['Message']['parent_id'] = 0;
		
		if($_POST['replyTo']){
			$msg['Message']['parent_id'] = $_POST['replyTo'];
			$msg['Message']['content'] = strip_tags(trim($_POST['replyText']));
		}
		
		$this->Message->save($msg);
		$this->Session->setFlash('Message has been posted.', 'default',array('class'=> 'success'));
		if($msg['Message']['by_admin'] == 1) $this->redirect(array('controller' => 'Messages', 'action' => "index"));
		else $this->redirect(array('controller' => 'Messages', 'action' => "userboard"));
		exit;
		
	}
	
	function delmessage($msgID, $isadmin = 1){
		$this->Message->selmessage($msgID);
		$this->Session->setFlash('Selected message has been deleted.', 'default',array('class'=> 'success'));
		if($isadmin) $this->redirect(array('controller' => 'Messages', 'action' => "index"));
		else $this->redirect(array('controller' => 'Messages', 'action' => "userboard"));
		exit;
	}
	
	function __validateLoginStatus($typ='A')
    {
	   if($typ == 'A'){
			if($this->Session->check('Admin') == false)
			{
				$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
				$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
			}
		}else{
			if($this->Session->check('Userlog') == false)
			{
				$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
				$this->redirect(array('controller' => 'users', 'action' => 'login')); 
			}
		}
    } 
	
	function beforeFilter()
    {
		/*if (isset($this->Setting) && !empty($this->Setting->table)){  
			 $this->Setting->load();  
		}*/
		$this->loadModel('Setting');
        $this->Setting->load(); 
		global $sitefolder; 
		global $meta_description;
		global $meta_keywords;
		global $page_title;
		$cnfg 				=	Configure::read('Neutrino');
		$sitefolder			=	$cnfg["sitebasefolder"];
		$meta_description	=	$cnfg["meta_description"];
		$meta_keywords		=	$cnfg["meta_keywords"];
		$page_title			=	$cnfg["page_title"];
		global $style; 
		$style				=	$cnfg["style"];
		$this->set('style', $style);
		$this->set('meta_description', $meta_description);
		$this->set('meta_keywords', $meta_keywords);
		$this->pageTitle = $page_title	; 
		$this->set('cnfg',$cnfg);
		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.		
		$this->set('sitefolder', $sitefolder);
		$httpHost	=	$_SERVER['HTTP_HOST'];
		$this->set('sitebase',FULL_BASE_URL);
    }
	
	function beforeRender(){
		 $lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));			
		 if(empty($lst)===false)
		 {
		   foreach($lst as $det)
		   $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
		   $this->set('menu_array', $menu_array);			   
		 }  		
		 $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));	
		$this->set('footerlinks', $footer_links);
		$pages =    $this->Dynamicpage->getpages();
		//echo "hello<pre>";print_r($pages);
		$this->set('pagesdynamic', $pages);
	}
} 