<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Santhosh Thomas Alexander<santhosh.thomas@armiasystems.com> |
// | & Manu R S <manu.r@armiasystems.com>                                 |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
//include('../includes/image.class.php');
include('../includes/class.upload.php');
include_once('../includes/S3.php');
/****** Including resize library *******/
include_once('../api/pemfile/iphonepush.php');
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');

$maximagesizestringinPHP = ini_get("upload_max_filesize");
$maximagesizeinPHP = $maximagesizestringinPHP * (1024 * 1024);
//$img = new Zubrag_image;

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}
if (isset($_SESSION["sess_artistid"]) and $_SESSION["sess_artistid"] != "") {
    $artistid = $_SESSION["sess_artistid"];
} else {
    header("Location:login.php");
    exit;
}
if(checkArtistExpired($artistid)){
    header("Location:seller_plan_upgrade.php?sellerid=".$artistid);
    exit;
}

if (isset($_GET["catid"]) and $_GET["catid"] != "") {
    $catid = $_GET["catid"];
} else if (isset($_POST["catid"]) and $_POST["catid"] != "") {
    $catid = $_POST["catid"];
}

$action = isset($_GET['action']) ? trim($_GET['action']) : '';
switch ($action) {
    case "checkDelvariantsOption":
    $id = isset($_POST['id']) ? trim($_POST['id']) : '';
    $id = explode("_", $id);
    $id = $id[1];
    if($id) {
        $optionNameSql = "SELECT option_name FROM " . $tableprefix . "options WHERE option_id=".$id;
        $optionNameSqlRes = $pdo->pdoQuery($optionNameSql,'')->result();
    }
        //echo json_encode(array($optionNameSqlRes['option_name'])); exit;
        //check whether option is assigned to a category
    $query_assigned_checkR1 = $pdo->select($tableprefix.'category_options',array('category_option_id,category_id'),array("option_id"=>$id))->results();

    $optionCat = array();
    if (!empty($query_assigned_checkR1)) {
        foreach($query_assigned_checkR1 as $row)
        {
            $optionCat[] = $row['category_id'];
        }
    }
    $optionsCatList = implode(',', $optionCat);
    if($optionsCatList!='')  {
        $checkSql = "SELECT product_option_value_id FROM " . $tableprefix . "product_option_values WHERE option_id=".$id;
        $checkRes= $pdo->pdoQuery($checkSql,'')->result();
    }
        //echo json_encode(array($checkRes)); exit;

        if (!empty($checkRes)) { //if yes,restrict delete option
            echo json_encode(array('failed'=>'The option <span>'.$optionNameSqlRes['option_name'].'</span> is already assigned to some category which has products. So unable to remove this option!!'));
        } else {
            echo json_encode(array('success'=>$id,'optionName'=>$optionNameSqlRes['option_name']));
        }
        exit;
        break;
        case "delvariantsOption":
        $id = isset($_POST['id']) ? trim($_POST['id']) : '';
        $id = explode("_", $id);
        $id = $id[1];
        if($id){
            $optionNameSql = "SELECT option_name FROM " . $tableprefix . "options WHERE option_id=".$id;
            $optionNameSqlRes = $pdo->pdoQuery($optionNameSql,'')->result();
            $optionNameSqlRes = $optionNameSqlRes['option_name'];
            $pdo->delete($tableprefix."category_options",array("option_id"=>$id))->affectedRows();
            $pdo->delete($tableprefix."options",array("option_id"=>$id))->affectedRows();
            echo json_encode(array('success'=>'y','optionName'=>$optionNameSqlRes));
        } else {
            echo json_encode(array('failed'=>'Failed, Something went wrong !!'));
        }
        exit;
        break;
    }

    $cdn_enabled = "N";
    if(ENABLE_AMAZON_S3_IMAGES=="Y"){
        $cdn_enabled  = "Y";
    }
//getting options for the category


    if ($_GET["begin"] == "") {
        $begin = 0;
        $num = 1;
        $numBegin = 1;
    } else {
        $begin = $_GET["begin"];
        $num = $_GET["num"];
        $numBegin = $_GET["numBegin"];
        ;
    }

    if (isset($_GET["txtSearch"]) and $_GET["txtSearch"] != "") {
        $txtSearch = $_GET["txtSearch"];
        $cmbSearchType = $_GET["cmbSearchType"];
    } else if (isset($_POST["txtSearch"]) and $_POST["txtSearch"] != "") {
        $txtSearch = $_POST["txtSearch"];
        $cmbSearchType = $_POST["cmbSearchType"];
    }
    $txtSearch = trim($txtSearch);
    $sql = "SELECT * FROM " . $tableprefix . "settings ";
    $result = $pdo->pdoQuery($sql)->results();
    if (!empty($result)) {
        $row = $result;
        $chkcanship = $row["enable_canadapost"];
        $max_images = $row['nproduct_images'];
    }

//echo $txtSearch. "<br>";
//echopre($_POST); exit;


    $txtCategoryName = trim($_POST["txtCategoryName"]);
    $productlist = $_POST["chkproducts"];

    $txtProductName = $_POST["txtProductName"];
    $txtProductCode = $_POST["txtProductCode"];
    $txtDescription = $_POST["txtDescription"];
    $txtPrice = $_POST["txtPrice"];
//$ddlArtist = $_POST["ddlArtist"];
    $ddlArtist = $artistid;
    $sectionCat = $_POST["sectionCat"];
    $sectionCat = implode(",",$sectionCat);
    (isset($_POST['chkAllowFreeShipping'])) ? $chkAllowFreeShipping = $_POST['chkAllowFreeShipping'] : $chkAllowFreeShipping = 'N';
    (isset($_POST['chkAllowSubscription'])) ? $chkAllowSubscription = $_POST['chkAllowSubscription'] : $chkAllowSubscription = 'N';

    $txtSearchTags = $_POST["txtProductTags"];
    $rdSubscriptionMode   = $_POST["rdSubscriptionMode"];
    $rdPublishStatus      = $_POST["rdPublishStatus"];
//print '<pre />';print_r($_POST);EXIT;

    if($rdPublishStatus=="N") {
//published time in 24_hour_format
        $selected_time = ($_POST['publishtime']!='')?$_POST['publishtime']:'12:00am';

        $formatteDate = dateFormat($_POST['publishdate'], "m-d-Y", "Y-m-d");
        $publishDate  = date("Y-m-d H:i:s", strtotime($formatteDate.$selected_time));

    //Get seller time zone
        $arrSellerTimezone = generalMethods::getSellerTimeZone($ddlArtist);
        $sellertimezone = $arrSellerTimezone['seller_time_zone'];

    } else {
        $publishDate   = "0000-00-00 00:00:00";
        $sellertimezone = "";
    }

//default published if settings disabled

    if(getSettingsValue('enable_product_scheduled_publishing')=='N')
    {
        $rdPublishStatus    = 'Y';
    }

    $txtStock = $_POST["txtStock"];

    $shipping_display_block = "";

    (isset($_POST['txtDigitalProduct'])) ? $txtDigitalProduct = $_POST['txtDigitalProduct'] : $txtDigitalProduct = 'N';

    if ($txtDigitalProduct == "Y") {
        $digitalBlock = "";
        $chkDigitalProduct = "checked";
        $canshipblock = "none";
        $shipping_display_block = "none";
        $chkAllowFreeShipping = "Y";
    } else {
        $digitalBlock = "none";
        $chkDigitalProduct = "";
        $canshipblock = "";
        $shipping_display_block = "";
    }

//$chkDigitalProduct = "checked";

    if (isset($_GET['message'])) {
// $message = $_GET['message'];
    }
    if (isset($_GET['mesgg'])) {
        $message = $_GET['mesgg'];
    }



    $qryopt = "";
    $qryoptArr = array();
    if ($txtSearch != "" && $txtSearch != "all") {
        if ($cmbSearchType == "artistname") {
            $qryopt .= "  AND  p.seller_name like :txtSearch";
            $qryoptArr['txtSearch'] = "$txtSearch%";
        } else if ($cmbSearchType == "dateadded") {
            $dt = $txtSearch;
            $arrdt = explode("/", $dt);
            $day = $arrdt[1];
            $month = $arrdt[0];
            $year = $arrdt[2];
            $dt = $year . "-" . $month . "-" . $day;
            $qryopt .= "  AND  p.date_added like :dt";
            $qryoptArr['dt'] = "$dt%";
        } else if ($cmbSearchType == "productname") {
            $qryopt .= "  AND  p.product_name like :txtSearch";
            $qryoptArr['txtSearch'] = "$txtSearch%";
        }
        $txtSearchcat = $txtSearch;
        if ($txtCategoryName)
            $txtSearchcat = "";
    }



if (isset($_POST["btnAddNewCategory"]) && !isNotNull($txtSearchcat)) { //echopre($_POST); exit;
    $message = "";
    if (!isset($catid) || $catid == "") {//at the top level
        $parentcatid = "0";
    } else {
        $parentcatid = $catid;
    }
    if (!isNotNull($txtCategoryName)) {
        $message .= CATNAME_REQD."<br>";
    } else if (categoryExists($txtCategoryName, $catid)) {
        $message .= CAT_EXIST;
    }
    if ($message != "") { // error
        $message = "<br>".MSG_CORRECT_THE_ERRORS."<br>" . $message;
    } else { // no error so insert category details
    if ($parentcatid == "0") {//top level category
        $sqlinsertcat = "INSERT INTO " . $tableprefix . "categories(category_name,parent_id,route,cdn_images_moved)
        VALUES ('" . addslashes($txtCategoryName) . "', '" . addslashes($parentcatid) . "','0','".  addslashes($cdn_enabled)."') ";
        $data = array(
            "category_name" => addslashes($txtCategoryName),
            "parent_id" => addslashes($parentcatid),
            "route" => '0',
            "cdn_images_moved" => addslashes($cdn_enabled)

            );
        $route_pr = $pdo->insert($tableprefix."categories",$data)->lastInsertId();
        $category_id = $route_pr;
        $catOptArr = $_POST['category_options'];

        if (count($catOptArr)) {
            foreach ($catOptArr as $opt) {
                $sqlinsertcat = "INSERT INTO " . $tableprefix . "category_options(category_id,option_id)
                VALUES ('" . addslashes($category_id) . "', '" . addslashes($opt) . "') ";
                $pdo->pdoQuery($sqlinsertcat);
            }
        }
        $sqlupdaterouteparent = "UPDATE " . $tableprefix . "categories SET route= '" . $route_pr . "' WHERE category_id = '" . $route_pr . "'";
        $resultupdatecat_parent = $pdo->pdoQuery($sqlupdaterouteparent);
        $message.="Category added successfully!";

    } else {
        $sqlcatdetails = "SELECT  route,count,parent_id  FROM " . $tableprefix . "categories
        WHERE category_id = '$parentcatid' ";

            //echo "<br>".$sqlcatdetails;
        $resultcatdetails = $pdo->pdoQuery($sqlcatdetails)->result();
        $rowcatdetails = $resultcatdetails;
        $route = $rowcatdetails["route"];

        $exp = explode(",", $route);

        if ($route == "0") {
            $route = $parentcatid;
        }
        $qry = "SELECT product_category FROM " . $tableprefix . "products WHERE product_category in($route)";

        $qryexc = $pdo->pdoQuery($qry)->results();
        if (empty($qryexc)) {

            $data = array(
                "category_name" => addslashes($txtCategoryName),
                "parent_id" => addslashes($parentcatid),
                "route" => $route,
                "cdn_images_moved" => addslashes($cdn_enabled)

                );

            $sqlcatid = $pdo->insert($tableprefix."categories",$data)->lastInsertId();

            $category_id = $sqlcatid;
            $catOptArr = $_POST['category_options'];

            if (count($catOptArr)) {
                foreach ($catOptArr as $opt) {
                    $sqlinsertcat = "INSERT INTO " . $tableprefix . "category_options(category_id,option_id)
                    VALUES ('" . addslashes($category_id) . "', '" . addslashes($opt) . "') ";
                    $pdo->pdoQuery($sqlinsertcat);
                }
            }

            if ($route != "") {
                $route .= "," . $sqlcatid;
                $sqlupdatecat = "UPDATE " . $tableprefix . "categories SET route= '" . $route . "' WHERE category_id = '" . $sqlcatid . "'";
                $resultupdatecat = $pdo->pdoQuery($sqlupdatecat);
            }
            $success_message =CAT_ADDED_SUCC;
        } else {
            $message = "<br>".MSG_CORRECT_THE_ERRORS."<br>" . SUBCAT_DISABLED;
        }
    }
}
} else if (isset($_POST["btnAddProduct"])) {
    //echo "hi"; exit;

    $message = "";
    $checkleafcategory = " select *  FROM  " . $tableprefix . "categories where parent_id= :catid";

    if (($pdo->pdoQuery($checkleafcategory, array("catid" => $catid))->iAffectedRows) > 0) {
        $message .= TXT_THERE_IS_A_SUBCAT."<br>";
    }
    if (!isNotNull($txtProductName)) {
        $message .= PRO_NAME_EMPTY."<br>";
    } else {
        $qry = "SELECT  product_name FROM  " . $tableprefix . "products WHERE product_name='" . addslashes($txtProductName) . "'
        and product_artist_id='" . $ddlArtist . "' and product_category = '" . addslashes($catid) . "' ";
        if (($pdo->pdoQuery($qry)->iAffectedRows) > 0) {
            $message .= PRO_WITH_SAME_NAME."<br>";
        }
    }
    if (!isNotNull($txtProductCode)) {
    //$message .= "* Product Code cannot be empty! <br>";
    } else {
        $qry = "SELECT  product_code FROM  " . $tableprefix . "products WHERE product_code='" . addslashes($txtProductCode) . "'
        and product_artist_id='" . $ddlArtist . "' and product_category = '" . addslashes($catid) . "' ";
        if (($pdo->pdoQuery($qry)->iAffectedRows) > 0) {
            $message .= PRO_WITH_SAME_CODE."<br>";
        }
    }
    if ($ddlArtist == "") {
        $message .= SELLER_EMPTY."<br>";
    }
    /*if ($sectionCat == "") {
    $message .= SECTION_EMPTY."<br>";
}*/
    //Generate Alias name for product
$aliasname = Utils::generateAlias($tableprefix . "products", $txtProductName);

if ($txtDescription == "") {
    $message .= PRO_DESC_EMPTY."<br>";
}
$priceposted = $txtPrice;
$txtPrice = doubleval($txtPrice);
if (!isNotNull($txtPrice) && !isNotNull($priceposted)) {
    $message .= PRO_PRICE_EMPTY."<br>";
} else if ($txtPrice <= 0 || !is_numeric($txtPrice)) {
    $message .= PRO_PRICE_POSITIVE."<br>";
}

if ($txtDigitalProduct == "Y") {
    if (!isNotNull($_FILES['txtProductZip']['name'])) {
        $message .= DIG_PRO_EMPTY."<br>";
    }
    $uploadfile = ReplaceArrayImage($_FILES['txtProductZip']['name']);
        //$types = array('gif','jpg','png','zip', 'pdf', 'rar', 'psd', 'opf', 'azw', 'lit', 'pdb', 'pkg', 'mp3', 'mpeg', 'mp4', 'avi', 'mpg', 'wma');

        //preg_match('/\.([a-zA-Z]+?)$/', $uploadfile, $matches);
    $matches = explode(".", $uploadfile);

    $matches_cnt = count($matches);

        if (!in_array(strtolower($matches[$matches_cnt - 1]), $digital_product_types)) { // check file format is valid or not
            $message .= INVALID_FILE_FORMAT."<br>";
        } // end format check
    }


    if (!in_array('1', $_POST['default_option'])) {
        $message .= SEL_DEFAULT_OPTION."<br>";
    }

    $options_count = count($_POST['additional_price']);
    for ($i = 0; $i < $options_count; $i++) {
        $default_option = $_POST['default_option'][$i];
        $additional_price = $_POST['additional_price'][$i];
        $product_stock = $_POST['product_stock'][$i];
        $reorder_level = $_POST['reorder_level'][$i];
        $product_shipping_weight = $_POST['product_shipping_weight'][$i];

        $discount = $_POST['discount'][$i];
        $discount_description = $_POST['discount_description'][$i];
        $product_length = $_POST['product_length'][$i];
        $product_width = $_POST['product_width'][$i];
        $product_height = $_POST['product_height'][$i];

        $prodimagedir = "../products/";

        $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
        $picsmallorgname = $_FILES['image_small']['name'][$i];
        $picsmalltempname = $_FILES['image_small']['tmp_name'][$i];
        $picsmalltype = $_FILES['image_small']['type'][$i];

        $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
        $picbigtype = $_FILES['image_big']['type'][$i];
        $picbigorgname = $_FILES['image_big']['name'][$i];
        $picbigtempname = $_FILES['image_big']['tmp_name'][$i];

        if ($picbigname != "") {
            $final_image_big = "productlarge_" . $i . time() . $picbigname;
        } else {
            $final_image_big = "";
        }

        if ($picsmallname != "") {
            $final_image_small = "productsmall_" . $i . time() . $picsmallname;
        } else {
            $final_image_small = "";
        }

        $picsmalldest = $prodimagedir . $final_image_small;
        $picbigdest = $prodimagedir . $final_image_big;

        $picsmallname = $final_image_small;
        $picbigname = $final_image_big;

        if (!is_readable($prodimagedir) || !is_writable($prodimagedir)) {
            $error = true;
            $message .= CHANGE_PERMISSION."<br>";
        }

        if($picbigname=='')
        {
           $message .= VAL_MSG_PIC_BIG_NULL." " . $i . "<br>";
           $error = true;
       }

       if ($picsmalltype != "") {
        if (!isValidWebImageType($picsmalltype, $picsmallorgname, $picsmalltempname)) {
            $message .= SMALL_PICTURE." " . $i . "<br>";
            $error = true;
        } else {
            if (file_exists($picsmalldest)) {
                $message .= SMALL_PIC_EXISTS." " . $i . "<br>";
                $error = true;
            }
        }
    }
    if ($picbigtype != "") {
        if (!isValidWebImageType($picbigtype, $picbigorgname, $picbigtempname)) {
            $message .= BIG_PICTURE." " . $i . "<br>";
            $error = true;
        } else {
            if (file_exists($picbigdest)) {
                $message .= BIG_PIC_EXISTS." " . $i . "<br>";
                $error = true;
            }
        }
    }


    $product_stock = doubleval($product_stock);
    if ($product_stock == "") {
        $message .= PRO_STOCK_EMPTY." " . ($i + 1) . " ! <br>";
    }
    if ($product_stock < 0 || !is_numeric($product_stock)) {
        if ($product_stock < 0) {
            $message .= PRO_STOCK_POSITIVE." " . ($i + 1) . " ! <br>";
        }
    }

    if($discount != ""){
        if($discount >= 100){
            $message .= DISCOUNT_VALIDATION." ".($i+1)."! <br>";
        }
    }

    if ($additional_price != "") {
        if ($additional_price < 0 || !is_numeric($additional_price)) {
            $message .= ADDITIONAL_PRICE_POSITIVE." " . ($i + 1) . "! <br>";
        }
    }


    if ($chkcanship == "Y" && $txtDigitalProduct != "Y") {
        if ($product_length == "") {
            $message .= PRO_LEN_EMPTY." " . ($i + 1) . " !<br>";
        }
        if ($product_width == "") {
            $message .= PRO_WIDTH_EMPTY." " . ($i + 1) . " !<br>";
        }
        if ($product_height == "") {
            $message .= PRO_HEIGHT_EMPTY." " . ($i + 1) . " !<br>";
        }
        if ($txtDigitalProduct != "Y") {
            if ($product_shipping_weight == "") {
                $message .= PRO_SHIPPING_EMPTY." " . ($i + 1) . "!<br>";
            }
        }
    }

    if ($product_length != '') {
        if (!is_numeric($product_length)) {
            $message .= ENTER_VALID_PRO_LEN." " . ($i + 1) . "! <br>";
        }
    }

    if ($product_width != '') {
        if (!is_numeric($product_width)) {
            $message .= ENTER_VALID_WID." " . ($i + 1) . "! <br>";
        }
    }

    if ($product_height != '') {
        if (!is_numeric($product_height)) {
            $message .= ENTER_VALID_HT." " . ($i + 1) . "! <br>";
        }
    }

    if ($txtDigitalProduct != "Y") {
        if (!is_numeric($product_shipping_weight) || $product_shipping_weight == 0) {
            $message .= ENTER_VWT." " . ($i + 1) . "! <br>";
        }
    }

    $product_shipping_weight = doubleval($product_shipping_weight);

    if ($product_shipping_weight < 0) {
        $message .= ENTER_PWT." " . ($i + 1) . "! <br>";
    }
    $reorder_level = doubleval($reorder_level);
    if ($reorder_level != "") {
        if ($reorder_level < 0 || !is_numeric($reorder_level)) {
            $message .= POSITIVE_LEVEL." " . ($i + 1) . "! <br>";
        } else if ($reorder_level > $product_stock) {
            $message .= LEVEL_LESS." " . ($i + 1) . "! <br>";
        }
    }
}

//echo "$_POST"; exit;


/*
* More Images Validation
*/

if (isset($_FILES['productMoreImage']['name']) && !empty($_FILES['productMoreImage']['name'])) {
    foreach ($_FILES['productMoreImage']['name'] as $key => $moreImage) {
        if ($moreImage != '') {
            $type = $_FILES['productMoreImage']['type'][$key];
            if (!isValidWebImageType($type)) {
                $message .= " * Invalid more image " . ($key + 1) . "<br>";
            }
        }
    }
}

$moreFiles = array();
foreach ($_FILES['productMoreImage'] as $k => $l) {
    foreach ($l as $j => $v) {
        if (!array_key_exists($j, $moreFiles)) {
            $moreFiles[$j] = array();
        }
        $moreFiles[$j][$k] = $v;
    }
}






/*
* More Images Validation - End
*/

if ($message != "") { // error
    $message = "<br>".MSG_CORRECT_THE_ERRORS."<br>" . $message;
} else { // no error so insert user details
// Upload Digital Products
    $digital_product_upload = 0;

    $digitalproductname = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $_FILES['txtProductZip']['name']);
    $digitalproductname = trim(str_replace(' ', '_', $digitalproductname));

    $assignedname = randomDigitalProduct() . "_" . $digitalproductname;

    if (@file_exists("../digital_product/" . $assignedname)) {
        $message .= PLEASE_RENAME." " . "<br>";
    }

    if ($txtDigitalProduct == "Y" && $_FILES['txtProductZip']['size'] > $maximagesizeinPHP) {
        $message.= FILE_SIZE_EXCEEDS." $maximagesizestringinPHP. <br>";
    }


    if ($txtDigitalProduct == "Y" && $message == '') {

        if (move_uploaded_file($_FILES['txtProductZip']['tmp_name'], "../digital_product/" . $assignedname)) {
            $digital_product_upload = 1;
            chmod("../digital_product/$assignedname", 0777);
        } else {
            $message .= COULDNT_UPLOAD." " . "<br>";
        }
    }

//default published if settings disabled
//  echo getSettingsValue('enable_product_scheduled_publishing');die("here");
    if(getSettingsValue('enable_product_scheduled_publishing')=='N')
    {
        $rdPublishStatus    = 'Y';
    }

// get the seller information and set vacation mode status in product
    $sellerCartObj      =    Store::get_seller_account_info($ddlArtist);
//echopre($sellerCartObj);
    if($sellerCartObj->status==SUCCESS)
    {
       $sellerCartObjVal      =   $sellerCartObj->data;
       $seller_vacation_mode  =   $sellerCartObjVal->is_vacation_mode;
   }

/////////////////////////////////////
   $productListingFee = getSettingsValue('product_listing_fee');
   $payment_status = 'COMPLETED';
   if ($productListingFee > 0) {
    $payment_status = 'PENDING';
}
$txtProductapproval = getSettingsValue('approve_products');

if ($txtProductapproval == 1) {

    $vapproved = 'Y';
} else {
    $vapproved = 'N';
}
/////////////////////////////////////

if ($message == '') {

    $data = array(
        "product_name" => addslashes($txtProductName),
        "product_code" => addslashes($txtProductCode),
        "product_description" => addslashes($txtDescription),
        "product_price" => addslashes($txtPrice),
        "vdigital_product" => $txtDigitalProduct,
        "product_category" => addslashes($catid),
        "product_artist_id" => addslashes($ddlArtist),
        "product_section" => addslashes($sectionCat),
        "date_added" => date('Y-m-d'),
        "vapproved" => $vapproved,
        "payment_status" => addslashes($payment_status),
        'seller_viewed_status'=>1,
        "alias" => addslashes($aliasname),
        "publish_status" => $rdPublishStatus,
        "publish_scheduled_date" => $publishDate,
        "product_tags" => addslashes($txtSearchTags),
        "allow_subscription" => $chkAllowSubscription,
        "subscription_mode" => $rdSubscriptionMode,
        "publish_timezone" => $sellertimezone,
        "allow_free_shipping" => $chkAllowFreeShipping,
        "seller_vacation_mode" => $seller_vacation_mode
        );

    $product_insert_id = $pdo->insert($tableprefix."products",$data)->lastInsertId();
    //Product Options Insertion here Santhosh thomas Alexander
    for ($i = 0; $i < $options_count; $i++) {

        $default_option = $_POST['default_option'][$i];
        $additional_price = $_POST['additional_price'][$i];
        $product_stock = $_POST['product_stock'][$i];
        $reorder_level = $_POST['reorder_level'][$i];
        $product_shipping_weight = $_POST['product_shipping_weight'][$i];
        $discount = $_POST['discount'][$i];
        $discount_description = $_POST['discount_description'][$i];
        $product_length = $_POST['product_length'][$i];
        $product_width = $_POST['product_width'][$i];
        $product_height = $_POST['product_height'][$i];
        $default_option_actual = "NO";
        if ($default_option == 1) {
            $default_option_actual = "YES";
        }
        $small_image_name_after_upload = "";
        $big_image_name_after_upload = "";

        $dir_dest = "../products";

//*********************************************Multicart3.0 Image Upload Modifications*************************//

        $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);

        $final_image_big = "";
        if ($picbigname != "") {
            $picBigArr = explode('.', $picbigname);
            $cntCountParamsBig = count($picBigArr);
            $name_big_with_out_extension = str_replace('.' . $picBigArr[$cntCountParamsBig - 1], '', $picbigname);
            $final_image_big = "productbig_" . $productid . "_" . $i . "_" . time() . $name_big_with_out_extension;
        }
        $picbigname = $final_image_big;

        $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);

        $final_image_small = "";

        if ($picsmallname != "") {
            $picSmallArr = explode('.', $picsmallname);
            $cntCountParamsSmall = count($picSmallArr);
            $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
            $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
        }else{
                // Save and resize Big Image to small size if small image not uploaded
            if($_FILES['image_big']['name'][$i]!='')
            {
                $picsmallname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
                $picSmallArr = explode('.', $picsmallname);
                $cntCountParamsSmall = count($picSmallArr);
                $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
            }
        }
        $picsmallname = $final_image_small;

        /**************Saving the original image*****************/
        /*if($_FILES['image_small']['name'][$i] !=''){

            $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
            $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);

            $file_extn              = end(explode(".",$picsmallname));
            //Save Small image
            $original_image_name_after_upload      = "productoriginal_".$product_insert_id."_".time().$picsmallname;
            $imageOriginal                        = "../products/".$original_image_name_after_upload;
            $imageOriginalSave                     = fopen($imageOriginal,'x');
            fwrite($imageOriginalSave, $imagecontent);
            fclose($imageOriginalSave);

        }*/

        /**************Saving the original image*****************/
        // Save small Images


        if ($_FILES['image_small']['name'][$i] != "") {
            //Commenting the previous code
            $files = array();
            foreach ($_FILES['image_small'] as $k => $l) {
                foreach ($l as $j => $v) {
                    if (!array_key_exists($j, $files))
                        $files[$j] = array();
                    $files[$j][$k] = $v;
                }
            }

            for ($x = 0; $x < count($files); $x++) {
                if ($x == $i) {
                    $handle = new Upload($files[$x]);
                    if ($handle->uploaded) {
                        // Modification resize
                        //   $info = getimagesize($inputFileName);
                        $handle->image_resize = true;
                        $handle->image_ratio = true;
                        $handle->image_x = 387;
                        $handle->image_y = 260;
                        $handle->file_new_name_body = $picsmallname;
                        $handle->Process($dir_dest);
                        $small_image_name_after_upload = $handle->file_dst_name;
                        // $imagepath             = "../products/".$small_image_name_after_upload;
                        // moveImageToCDN($imagepath,'products/'.$small_image_name_after_upload);
                        if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                          $imagepath =  realpath(__DIR__ . '/..')."/products/".$small_image_name_after_upload;
                      }
                      else{
                          $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$small_image_name_after_upload;

                      }
                      moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$small_image_name_after_upload);
                  }
              }
          }
      }
      /********** Image resizing maintaining aspect ratio begin***********/
            /*$imagecontent           = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
            $file_extn              = end(explode(".",$picsmallname));

            // $small_image_name_after_upload      = "productsmall_".$product_insert_id."_".time().$picsmallname;

            $small_image_name_after_upload = str_replace('productoriginal_','productsmall_',$original_image_name_after_upload);
            $imageSmall             = "../products/".$small_image_name_after_upload;
            $imageSmallSave         = fopen($imageSmall,'x');
            fwrite($imageSmallSave, $imagecontent);
            fclose($imageSmallSave);
            reSizeImageFromFolder($imageSmall,191,183);*/
            /********** Image resizing maintaining aspect ratio end***********/

        //small image upload end


        //*****************big Image Upload**************************

            if ($picbigname != "") {
            //Commenting the previous code
                $files = array();
                foreach ($_FILES['image_big'] as $k => $l) {
                    foreach ($l as $j => $v) {
                        if (!array_key_exists($j, $files))
                            $files[$j] = array();
                        $files[$j][$k] = $v;
                    }
                }
                for ($x = 0; $x < count($files); $x++) {
                    if ($x == $i) {
                        $handle = new Upload($files[$x]);
                        if ($handle->uploaded) {

                            $handle->image_resize = true;
                            $handle->image_ratio = true;
                            $handle->image_x = 489;
                            $handle->image_y = 328;
                            $handle->file_new_name_body = $picbigname;
                            $handle->Process($dir_dest);
                            $big_image_name_after_upload = $handle->file_dst_name;
                        // $imagepath             = "../products/".$big_image_name_after_upload;
                        // moveImageToCDN($imagepath,'products/'.$big_image_name_after_upload);
                            if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                              $imagepath =  realpath(__DIR__ . '/..')."/products/".$big_image_name_after_upload;
                          }
                          else{
                              $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$big_image_name_after_upload;

                          }
                          moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$big_image_name_after_upload);


                          $main_thumb_file_name           =    "thumb_".$picbigname;
                          $handle->file_new_name_body     =    $main_thumb_file_name;
                          $handle->image_resize           = true;
                          $handle->image_x                = 82;
                          $handle->image_y                = 79;
                          $handle->image_ratio            = true;
                          $handle->Process($dir_dest);
                          $main_thumb_file_name_after_upload = $handle->file_dst_name;
                        // $imagethubpath             = "../products/".$main_thumb_file_name_after_upload;
                        // moveImageToCDN($imagethubpath,'products/'.$main_thumb_file_name_after_upload);
                          if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                              $imagepath =  realpath(__DIR__ . '/..')."/products/".$main_thumb_file_name_after_upload;
                          }
                          else{
                              $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$main_thumb_file_name_after_upload;

                          }
                          moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$main_thumb_file_name_after_upload);

                      }

                     /*// Create thumbnail Image and save to thumb folder
                    $big_file_name                  =    "thumb_".$big_image_name_after_upload;
                    $handle->file_new_name_body     =    $big_file_name;
                    $handle->image_resize           = true;
                    $handle->image_x                = 82;
                    $handle->image_y                = 79;
                    $handle->image_ratio            = true;
                    $handle->Process($dir_dest);
                    $imagethumbpath  = "../products/".$big_file_name;
                    moveImageToCDN($imagethumbpath,'products/'.$big_file_name);*/


                    // Resize  Small images in listing if small image  not uploaded
                    if($_FILES['image_small']['name'][$i]=='') {
                        $small_file_name                =    $picsmallname;
                        $handle->file_new_name_body     =    $small_file_name;
                        $handle->image_resize           =    true;
                        $handle->image_x                =    387;
                        $handle->image_y                =    260;
                        $handle->image_ratio            =    true;
                        $handle->Process($dir_dest);
                        $small_image_name_after_upload  = $handle->file_dst_name;
                                    // $imagepath             = "../products/".$small_image_name_after_upload;
                                    // moveImageToCDN($imagepath,'products/'.$small_image_name_after_upload);
                        if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                          $imagepath =  realpath(__DIR__ . '/..')."/products/".$small_image_name_after_upload;
                      }
                      else{
                          $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$small_image_name_after_upload;

                      }
                      moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$small_image_name_after_upload);

                  }


              }
          }


      }


      /********** Image resizing maintaining aspect ratio begin***********/
             /*$imagecontent = file_get_contents($_FILES['image_big']['tmp_name'][$i]);
             $file_extn              = end(explode(".",$picbigname));

              //$big_image_name_after_upload      = "productbig_".$product_insert_id."_".time().$picbigname;
              $big_image_name_after_upload = str_replace('productoriginal_','productbig_',$original_image_name_after_upload);
              $imageSmall             = "../products/".$big_image_name_after_upload;
              $imageSmallSave         = fopen($imageSmall,'x');
              fwrite($imageSmallSave, $imagecontent);
              fclose($imageSmallSave);
              reSizeImageFromFolder($imageSmall,283,269);*/
              /********** Image resizing maintaining aspect ratio begin***********/
                        //big image upload end
        //Product option Images upload end
        //small Image Upload
        /*
          $picsmallname         = ReplaceArrayImage($_FILES['image_small']['name'][$i]);

          $final_image_small = "";

          if($picsmallname != "") {
          $picSmallArr            = explode('.', $picsmallname);
          $cntCountParamsSmall    = count($picSmallArr);
          $name_small_with_out_extension      = str_replace('.'.$picSmallArr[$cntCountParamsSmall-1], '', $picsmallname);
          $final_image_small      = "productsmall_".$product_insert_id."_".$i."_".time().$name_small_with_out_extension;

          }
          $picsmallname = $final_image_small;

          // then we check if the file has been uploaded properly
          // in its *temporary* location in the server (often, it is /tmp)

          if($picsmallname !="") {
          $files = array();
          foreach ($_FILES['image_small'] as $k => $l) {
          foreach ($l as $j => $v) {
          if (!array_key_exists($j, $files))
          $files[$j] = array();
          $files[$j][$k] = $v;
          }
          }

          for($x=0;$x < count($files);$x++) {
          if($x ==$i) {
          $handle = new Upload($files[$x]);
          if ($handle->uploaded) {

          $handle->image_resize            = true;
          //$handle->image_ratio_y           = true;
          $handle->image_x                 = 191;
          $handle->image_y                 = 183;
          $handle->file_new_name_body      = $picsmallname;
          $handle->Process($dir_dest);

          $small_image_name_after_upload  = $handle->file_dst_name;

          }
          }
          }
          }
          //small image upload end
          //big Image Upload

          $picbigname       = ReplaceArrayImage($_FILES['image_big']['name'][$i]);

          $final_image_big = "";
          if($picbigname != "") {
          $picBigArr            = explode('.', $picbigname);
          $cntCountParamsBig    = count($picBigArr);
          $name_big_with_out_extension      = str_replace('.'.$picBigArr[$cntCountParamsBig-1], '', $picbigname);
          $final_image_big      = "productbig_".$product_insert_id."_".$i."_".time().$name_big_with_out_extension;

          }
          $picbigname = $final_image_big;

          // then we check if the file has been uploaded properly
          // in its *temporary* location in the server (often, it is /tmp)

          if($picbigname !="") {
          $files = array();
          foreach ($_FILES['image_big'] as $k => $l) {
          foreach ($l as $j => $v) {
          if (!array_key_exists($j, $files))
          $files[$j] = array();
          $files[$j][$k] = $v;
          }
          }
          for($x=0;$x < count($files);$x++) {
          if($x ==$i) {
          $handle = new Upload($files[$x]);
          if ($handle->uploaded) {

          $handle->image_resize            = true;
          $handle->image_x                 = 283;
          $handle->image_y                 = 269;
          $handle->file_new_name_body      = $picbigname;
          $handle->Process($dir_dest);
          $big_image_name_after_upload  = $handle->file_dst_name;

          }
          }
          }
          }
          //big image upload end
          //Product option Images upload end
        */

          $data = array(
            "product_id" => $product_insert_id,
            "additional_price" => $additional_price,
            "product_stock" => $product_stock,
            "reorder_level" => $reorder_level,
            "product_shipping_weight" => $product_shipping_weight,
            "image_small" => $small_image_name_after_upload,
            "image_big" => $big_image_name_after_upload,
            "discount" => $discount,
            "discount_description" => $discount_description,
            "product_length" => $product_length,
            "product_width" => $product_width,
            "product_height" => $product_height,
            "default_option" => $default_option_actual,
            "cdn_images_moved" => $cdn_enabled

            );

          $product_option_id = $pdo->insert($tableprefix."product_options",$data)->lastInsertId();
          $options_arr = getOptionsFromCategory($catid);
          $num_of_options = count($options_arr);
          if ($num_of_options != "") {
            foreach ($options_arr AS $eachoption) {

                $option_Id = $eachoption['option_id'];
                $option_value = $_POST["option_" . $option_Id][$i];
                if ($option_value != "") {

                    $query_option_insert = "INSERT INTO " . $tableprefix . "product_option_values
                    (
                    product_option_id,
                    option_id,
                    value
                    )
                    VALUES
                    (
                    '" . $product_option_id . "',
                    '" . $option_Id . "',
                    '" . $option_value . "'
                    )";
                    $pdo->pdoQuery($query_option_insert);
                }
            }
        }

    }

//*************************************Multicart3.0 Scalability Modifications*******************************************

// Save product default option values to product  table
    if(getSettingsValue('enable_scalability_settings')=='Y')
    {
        $objDefaultOptionVo                                     =    new stdClass();
        $objOptionVo                                            =    Products::getProduct_Default_Option_Values($product_insert_id);

        $objDefaultOptionVo->default_image_small                =   $objOptionVo->image_small;
        $objDefaultOptionVo->default_stock                      =   $objOptionVo->product_stock;
        $objDefaultOptionVo->default_additional_price           =   $objOptionVo->additional_price;
        $objDefaultOptionVo->default_shipping_weight            =   $objOptionVo->product_shipping_weight;
        $objDefaultOptionVo->default_discount                   =   $objOptionVo->discount;
        $objDefaultOptionVo->default_discount_description       =   $objOptionVo->discount_description;
        $objDefaultOptionVo->default_option_id                  =   $objOptionVo->product_option_id;
        $objDefaultOptionVo->product_id                         =   $product_insert_id;

    // Save default option values to product table
        $productinfoUpdate                                      =   Products::updateProduct_Default_Option_Value($objDefaultOptionVo);

    }
// echopre($objDefaultOptionVo);
    //exit;

//*************************************Multicart3.0 Scalability Modifications End *******************************************

    if ($txtDigitalProduct == "Y" && $digital_product_upload == '1') {

        $expiry_days = $_POST['txtDownloadExpiry'];
        //$valid_date_upto = date("Y-m-d H:s:m",mktime(date("H"),date("i"),date("s"),date("m"),date("d")+$expiry_days,date("Y")));

        $insert_digital_product = "INSERT INTO " . $tableprefix . "digital_product(ndigital_productid,vdigital_product_name,ndownload_try
        ,ndownload_expiry_days)VALUES(" . $product_insert_id . ","
        . GetSQLValueString($assignedname, "text") . ",
        " . $_POST['txtDownloadTry'] . ",
        '" . $expiry_days . "')";

        $pdo->pdoQuery($insert_digital_product);
    }

    /*
     * Product more images By Binu Chandran.E
    */
    $moreFiles = array();
    foreach ($_FILES['productMoreImage'] as $k => $l) {
        foreach ($l as $j => $v) {
            if (!array_key_exists($j, $moreFiles)) {
                $moreFiles[$j] = array();
            }
            $moreFiles[$j][$k] = $v;
        }
    }
    $dir_dest = "../products";
    for ($x = 0; $x < count($moreFiles); $x++) {
        $moreImageName = ReplaceArrayImage($moreFiles[$x]['name']);
        if ($moreImageName != "") {
            /********** Image resizing maintaining aspect ratio begin***********/
             /*$imagecontent = file_get_contents($_FILES['productMoreImage']['tmp_name'][$x]);
             $file_extn              = end(explode(".",$moreImageName));

              $moreImageNameAfterupload = "productmore_" . $x . time() . $moreImageName;
              $imageMore             = "../products/".$moreImageNameAfterupload;
              $imageMoreSave         = fopen($imageMore,'x');
              fwrite($imageMoreSave, $imagecontent);
              fclose($imageMoreSave);
              reSizeImageFromFolder($imageMore,283,269);
              $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                              SET nimage_productid = '" . mysql_real_escape_string($product_insert_id) . "',
                                                  vimage_name= '" . mysql_real_escape_string($moreImageNameAfterupload) . "',
                                                  vproduct_image_delete_status  ='N'";
                                                  mysql_query($insertMImageQuery) or die(mysql_error());*/

                                                  $handle = new Upload($moreFiles[$x]);
                                                  if ($handle->uploaded) {

                                                    $moreImageName = "productmore_" . $x . time() . $moreImageName;
                                                    $moreImageName_Upload       =   substr($moreImageName, 0, strrpos($moreImageName, '.'));
                                                    $handle->image_resize = true;
                                                    $handle->image_x = 489;
                                                    $handle->image_y = 328;
                                                    $handle->image_ratio= true;
                                                    $handle->file_new_name_body = $moreImageName_Upload;
                                                    $handle->Process($dir_dest);
                                                    $moreImageName = $handle->file_dst_name;

                // $imagepath             = "../products/".$moreImageName;
                // moveImageToCDN($imagepath,'products/'.$moreImageName);
                                                    if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                                                      $imagepath =  realpath(__DIR__ . '/..')."/products/".$moreImageName;
                                                  }
                                                  else{
                                                      $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$moreImageName;

                                                  }
                                                  moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$moreImageName);

                // Save More Image Thubnail to thumb folder

                                                  $more_thumb_file_name           =    "thumb_".$moreImageName_Upload;
                                                  $handle->file_new_name_body     =    $more_thumb_file_name;
                                                  $handle->image_resize           = true;
                                                  $handle->image_x                = 82;
                                                  $handle->image_y                = 79;
                                                  $handle->image_ratio            = true;
                                                  $handle->process($dir_dest);
                                                  $more_thumb_file_name_after_upload = $handle->file_dst_name;
                // $imagethubpath             = "../products/".$more_thumb_file_name_after_upload;
                // moveImageToCDN($imagethubpath,'products/'.$more_thumb_file_name_after_upload);
                                                  if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                                                      $imagepath =  realpath(__DIR__ . '/..')."/products/".$more_thumb_file_name_after_upload;
                                                  }
                                                  else{
                                                      $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$more_thumb_file_name_after_upload;

                                                  }
                                                  moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$more_thumb_file_name_after_upload);

                                                  $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                                  SET nimage_productid = :product_insert_id,
                                                  vimage_name= :moreImageName,
                                                  vproduct_image_delete_status  ='N',
                                                  cdn_images_moved = :cdn_enabled";
                                                  $pdo->pdoQuery($insertMImageQuery, array("product_insert_id" => $product_insert_id, "moreImageName" => $moreImageName, "cdn_enabled" => $cdn_enabled));
                                              }
                                          }
                                      }

    // Send push notification
    $devicesql = "Select device_id from " . $tableprefix . "artists where artist_id ='$ddlArtist'"; //Get seller device ID
    $result = $pdo->pdoQuery($devicesql)->result();
    $device_row = $result;
    $msg = "New Product - '".$txtProductName."' added at ".SITE_NAME. ", please check.";
    send_push_nofication($msg,SITE_NAME,"armia",$device_row['device_id'],"Product");//Message,From,passphrase,device token,type-->product,order...
    //-------------------------//

    $txtSearch = "";
    $txtProductName = "";
    $txtProductCode = "";
    $txtDescription = "";
    $txtPrice = "";
    $ddlArtist = "";
    $sectionCat = "";

    //update count
    $routesql = "Select route from " . $tableprefix . "categories where category_id ='$catid'";
    //echo $routesql;
    $result = $pdo->pdoQuery($routesql)->result();
    $row = $result;
    $route = $row["route"];
    $qryupdatecatcount = "update " . $tableprefix . "categories set count=count+1 where category_id in($route)";
    $pdo->pdoQuery($qryupdatecatcount);
    $success_message = PRO_ADD_SCC;

    if ($productListingFee > 0) {
        header("Location:product-listing-payment.php?&pid=" . $product_insert_id);
        exit;
    }

    header("Location:mycatalog.php?message=$message&catid=$catid");
    exit;
}
}
} else if (isset($_POST["btnDeleteSelected"])) {
    if (!isNotNull($productlist)) {
        $message .= DELETE_PRO." <br>";
    } else {
        $cnt = count($productlist);
        $plist = implode(",", $productlist);
        list($qarr,$qstr) = getInQueryString($plist);
        $sql = "DELETE FROM " . $tableprefix . "products WHERE product_id IN ($qstr) ";
        $res = $pdo->pdoQuery($sql,$qarr)->results();

        $select_product_images = "SELECT image_small,image_big
        FROM " . $tableprefix . "product_options WHERE product_id IN(" . $qstr . ")";


        $result_product_images = $pdo->pdoQuery($select_product_images, $qarr)->results();

        if (!empty($result_product_images)) {
            foreach($result_product_images as $product_images_row) {
                $imagesmall_thumb = $product_images_row['image_small'];

                $imagelarge_thumb = $product_images_row['image_big'];

                @unlink("../products/" . $imagesmall_thumb);
                @unlink("../products/" . $imagelarge_thumb);
                deleteCDNImage('products/'.$imagesmall_thumb);
                deleteCDNImage('products/'.$imagelarge_thumb);
            }
        }
        $sql_options = "DELETE FROM " . $tableprefix . "product_options WHERE product_id IN ($qstr) ";
        $del_options = $pdo->pdoQuery($sql_options, $qarr);

        $select_product_images_more = "SELECT im.vimage_name
        FROM " . $tableprefix . "product_view_images im
        WHERE im.nimage_productid IN(" . $qstr . ")";
        $rs_product_image_more = $pdo->pdoQuery($select_product_images_more,$qarr)->results();

        if (count($rs_product_image_more) > 0) {

            foreach ($rs_product_image_more as $prows) {
                $moreimage = $prows['vimage_name'];
                $moreimage_thumb = "thumb_" . $prows['vimage_name'];
                @unlink("../products/" . $moreimage);
                @unlink("../products/" . $moreimage_thumb);
                deleteCDNImage('products/'.$moreimage);
                deleteCDNImage('products/'.$moreimage_thumb);
            }
        }

        $sql_product_images_more = "DELETE FROM " . $tableprefix . "product_view_images WHERE nimage_productid IN ($qstr) ";
        $del_product_images_more = $pdo->pdoQuery($sql_product_images_more,$qarr)->results();

        $delete_cart_products = "DELETE FROM " . $tableprefix . "cart WHERE product_id IN(" . $qstr . ")";

        $pdo->pdoQuery($delete_cart_products,$qarr)->results();
    }
}

$artistlist = makeArtistList();

$sectionlist = makeSectionList($catid);

/*$sql = " SELECT p.product_id,p.product_name,p.product_code,(p.product_price+po.additional_price) as product_price,p.date_added,s.artist_name
    FROM " . $tableprefix . "products p
    INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id AND po.default_option = 'YES'
    INNER JOIN " . $tableprefix . "artists s ON p.product_artist_id = s.artist_id
    WHERE product_category = '" . addslashes($catid) . "' " . $qryopt . "   ORDER BY p.product_name  ";*/


//*************************************Multicart Scalability Modifications for Product Listing

    $sql = " SELECT p.product_id,p.product_name,p.product_code,(p.product_price+p.default_additional_price) as product_price,p.date_added,p.seller_name as artist_name,p.product_artist_id as artist_id
    FROM " . $tableprefix . "products p
    WHERE product_category = :catid " . $qryopt . " AND product_artist_id = ".$artistid." ORDER BY p.product_name  ";
    $qryoptArr['catid'] = $catid;
//*****************************************Multicart Scalability Modifications for Product Listing


    $sess_back = $_SERVER["PHP_SELF"] . "?begin=" . $begin . "&num=" . $num . "&numBegin=" . $numBegin . "&cmbSearchType=" . $cmbSearchType . "&txtSearch=" . $txtSearch . "&catid=" . $catid;
    $_SESSION["gbackurl"] = $sess_back;
    $Count = $pdo->pdoQuery($sql, $qryoptArr)->results();
    $totalrows = count(($Count));
    $txtSearch1 = urlencode($txtSearch);
    $navigate = pageBrowser($totalrows, 10, 10, "&cmbSearchType=$cmbSearchType&txtSearch=$txtSearch1&catid=$catid", $_GET[numBegin], $_GET[start], $_GET[begin], $_GET[num]);
    $sql = $sql . $navigate[0];
    $rs = $pdo->pdoQuery($sql, $qryoptArr)->results();
    $shipping_Dimension_Required    =   checkShippingDimensionEnable();
    include "../includes/htmltop1.php";
    $variantNameSql = "SELECT option_name FROM " . $tableprefix . "options";
    $variantNameSqlRes = $pdo->pdoQuery($variantNameSql,'')->results();
    foreach ($variantNameSqlRes as $key => $value) {
        $variantsArray[] = strtolower($value['option_name']);
    }
    ?>
    <link rel="stylesheet" href="<?php echo $site_url; ?>/style/jquery-ui.css">
    <!-- <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css"> -->
    <script src="<?php echo $site_url; ?>/js/jquery-1.11.2.js"></script>
    <script src="<?php echo $site_url; ?>/js/jquery-ui.js"></script>
    <!--   <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script> -->
    <link href="<?php echo $site_url; ?>/style/jquerysctipttop.css" rel="stylesheet" type="text/css">
    <!-- CSS Stylesheet -->
    <link rel="stylesheet" href="<?php echo $site_url; ?>/style/dateselector.css" type="text/css" />
    <!-- Scripts -->

<!--<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/jquery.js"></script>
    <script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/jquery.tools.min.js"></script>-->
    <script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL?>/js/dateselector.min.js"></script>
    <!-- <link rel="stylesheet" href="/resources/demos/style.css"> -->
    <!-- <script src="https://code.jquery.com/jquery-1.12.4.js"></script> -->

    <script type="text/javascript">

        var SiteUrlName = '<?php echo SITE_URL;?>';
        var variants =  <?php echo json_encode($variantsArray); ?>;

        $(document).on('click', '.jqVariantsOptionDeleteCheck', function() {
            var optionid = $(this).parents().attr('id');
        //$('.class'+optionid).remove();
        ///////////////////////Ajax variants delete check/////////////
        $.blockUI({ message: null });
        $.ajax({url: 'mycatalog.php?action=checkDelvariantsOption',
            data: {id: optionid},
            type: 'post',
            dataType: 'json',
            success: function (reply) {
                if (reply)
                {
                    if (reply.success){
                        var optid = 'option_'+reply.success;
                        $('.jqVariantsOptionDelete').attr('id',optid);
                        $('.jqVariantsOptionName').text(reply.optionName);
                        $('#messager').show();
                        $('#failedMessager').hide();
                        $('#deletedMessager').hide();
                    } else if(reply.failed){
                        $('#failedMessager').show().html(reply.failed);
                        $('#messager').hide();
                        $('#deletedMessager').hide();
                    }
                }
            }
        });
        ///////////////////////Ajax variants delete check/////////////
    });

        $(document).on('click', '.jqVariantsOptionDelete', function() {
            var optionid = $(this).attr('id');
            $('.class'+optionid).remove();
        ///////////////////////Ajax variants delete/////////////
        $.blockUI({ message: null });
        $.ajax({url: 'mycatalog.php?action=delvariantsOption',
            data: {id: optionid},
            type: 'post',
            dataType: 'json',
            success: function (reply) {
                if (reply)
                {
                    if (reply.success){
                        $('#deletedMessager').show();
                        $('#messager').hide();
                        $('#failedMessager').hide();
                        var index = variants.indexOf(reply.optionName);
                        variants.splice(index, 1);
                    } else if(reply.failed){
                        $('#failedMessager').show().html(reply.failed);
                        $('#messager').hide();
                        $('#deletedMessager').hide();
                    }
                }
            }
        });
        ///////////////////////Ajax variants delete/////////////
    });

        $(document).on('click', '.jqVariantsOptionDeleteCancel', function() {
            $('#failedMessager').hide();
            $('#deletedMessager').hide();
            $('#messager').fadeOut('slow');
        });

        function duplicateProduct(){
            return confirm("<?php echo CONFIRM_DEL_DUPLICATE;?>");
        }
    </script>

    <style>
/*.tooltip {
display:none;
background:transparent url(../images/tooltip/black_arrow.png);
font-size:12px;
height:70px;
width:160px;
padding:25px;
color:#fff;
}*/

.tooltip {
    background-color: black;;
    filter: alpha(opacity=75)-moz-opacity:0.75;
    opacity: 0.75;
    border: 2px solid #FFFFFF;

    border-radius:5px 5px 5px 5px;
    color: white;
    font-size: 1.2em;
    left: -12px;
    padding: 10px;
    position: relative;
    top: 21px;
    width: 200px;
}
.tooltip:after, .tooltip:before
{
    top: 100%;
    border: solid transparent;
    content: " ";
    height: 0;
    width: 0;
    position: absolute;
    pointer-events: none;
}
.tooltip:after
{
    border-color: rgba(10, 13, 15, 0);
    border-top-color: #0a0d0f;
    border-width: 10px;
    left: 50%;
    margin-left: -10px;
} .tooltip:before

{
    border-color: rgba(245, 245, 245, 0);
    border-top-color: #f5f5f5;
    border-width: 16px;
    left: 50%;
    margin-left: -16px;
}

</style>

<script language="JavaScript" type="text/JavaScript">
    $(document).ready(function(){

        $(document).ajaxStop($.unblockUI);

        $('#primery_btt_tab_1').click(function(e){
            e.preventDefault();
            if(!validateProductForm(1,'a'))
                return false;
            $("#ui-id-2").trigger('click');
        });

        $('#primery_btt_tab_2').click(function(e){
            e.preventDefault();
            $("#ui-id-3").trigger('click');
        });

        var myFuncCalls = 0;

        $("#add_more_options").click(function() {
            myFuncCalls++;
            var addVal = $("#add_value").val();
            var catid_val = '<?php echo $catid; ?>';
            $("#add_value").val(parseInt(addVal)+1);
            var block = '<div class="variant_detail_outer option_block"><div class="variant_detail_top_outer"><div class="col-xs-12 col-sm-5 col-md-4 col-lg-6"><h1>Variants</h1></div><div class="col-xs-12 col-sm-5 col-md-4 col-lg-6"><div class="variants_top_btt_outer"><span class="variants_default_show_btt inactive"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"><input type="hidden" class="default_option form-control" name="default_option[]" id="default_option[]" value="">&nbsp<?php echo DEFAULT_OPT; ?></span><button type="button" class="delete_btt pull-left" title="Delete Option" onClick="javascript:delete_option(this);"><i class="fa fa-trash-o" aria-hidden="true"></i></button></div></div><span class="default_setting_box" id="default_setting_box_ID_'+myFuncCalls+'"><div class="clearfix">&nbsp;</div><?php //echo getStrOptions($catid); ?></span><div class="clearfix"></div></div><div class="variant_detail_bottom_outer"><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo ADD_PRICE; ?> &nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</label><input type="text" name="additional_price[]" onpaste="return false;" id="additional_price[]" value="" class="jqPrice jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></label><input type="text" name="product_stock[]" id="product_stock[]" value="" class="clsProductStock jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo REORDER_LEVEL; ?></label><input type="text" name="reorder_level[]" id="reorder_level[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo DISCOUNT_PERC; ?></label><input type="text" name="discount[]" id="discount[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo DISCOUNT_DESC; ?></label><input type="text" name="discount_description[]" id="discount_description[]" value="" class="form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock"><label><?php echo SW_LBS; ?> <span class="required">*</span></label><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock"><label><?php echo LENGTH; ?><?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?></label><input type="text" name="product_length[]" id="product_length[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock"><label><?php echo WIDTH; ?><?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?></label><input type="text" name="product_width[]" id="product_width[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock"><label><?php echo HEIGHT; ?><?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?></label><input type="text" name="product_height[]" id="product_height[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span></label><label class="btn-bs-file btn btn-lg btn-info upload_image"><input type="file" name="image_big[]" id="image_big[]" onchange="showBigImages(this.files,'+addVal+',this);" value=""></label><img src="" style="display:none" width="183" height="auto" id="big_img_preview_'+addVal+'"></div></div><div class="clearfix"></div></div>';

            /*<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo SMALL_IMG; ?></label><label class="btn-bs-file btn btn-lg btn-info upload_image"><input type="file" name="image_small[]" id="image_small[]" onchange="showSmallImages(this.files,'+addVal+',this);" value=""></label><img src="" style="display:none" width="183" height="auto" id="small_img_preview_'+addVal+'"></div><div class="clearfix"></div>*/
            $("#options_window").append(block);
        // Manu R S 12/08/17 S
        var dataString = {categoryid:catid_val};
        $.ajax({
            url     : "<?php echo SITE_URL?>/getStrOptionsAjax.php",
            type        : "POST",
            data        : dataString,
            dataType        : "json",
            success: function(data) {
        //$("#options_window").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
        //$("#navcontainer ul").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
        ///////////////////MANU////////////////////////
        //$("#options_window").append("<tr><td>"+ "ddd" +"</td></tr>");
        //alert(data.length);
        var divid = "#default_setting_box_ID_"+myFuncCalls;
        for (var i = 0; i < data.length; i++) {
            $(divid).append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data[i]['option_id']+'"><label>'+ data[i]['option_name'] +'</label><span class="category_option_field"><input name="option_'+data[i]['option_id']+'[]" value="" type="text" class="form-control"></span></div>');
        }      }});
        //  $("#options_window").append(  $( "#default_setting_box_ID" )   );
        // Manu R S 12/08/17 E
        $('.jqPrice').keyup(function(e){
            var price = parseFloat($(this).val());
            var newVal = $(this).val().replace(/[^\d.]/, '');
            var number = (newVal.split('.'));
            $(this).val(newVal);
            if (typeof(number[1]) != "undefined"){
                if (number[1].length > 2)
                {
                    $(this).val( price.toFixed(2));
                }
            }
        });
        checkDigitalProduct();
    });
/*/////////////////////////////////////////*/







$(".help a[title]").tooltip();

$('#txtSearch').keypress(function(e){

    if(e.keyCode==13){

        clickSearch();
    }
});

$('#txtPrice').keyup(function(e){
    var price = parseFloat($('#txtPrice').val());
    var newVal = $('#txtPrice').val().replace(/[^\d.]/, '');
    var number = (newVal.split('.'));
    $('#txtPrice').val(newVal);
    if (typeof(number[1]) != "undefined"){
        if (number[1].length > 2)
        {
            $("#txtPrice").val( price.toFixed(2));
        }
    }
});

$('.jqPrice').keyup(function(e){
    var price = parseFloat($(this).val());
    var newVal = $(this).val().replace(/[^\d.]/, '');
    var number = (newVal.split('.'));
    $(this).val(newVal);
    if (typeof(number[1]) != "undefined"){
        if (number[1].length > 2)
        {
            $(this).val( price.toFixed(2));
        }
    }
});

$('#chkAllowSubscription').click(function(e){
 if ($('input[name=chkAllowSubscription]:checked').val() ) {
     $('#subscription_mode').show();
 }else{$('#subscription_mode').hide();}

});

$('#cmbSeller').change(function(){

    var sellerid    =   $(this).val();
    changePublishSettings(sellerid);
});

$('.rdPublishStatus').click(function(){
    if($('input[name=rdPublishStatus]:checked').val()=="N"){
        $("#publish_time").show();
    }else if($('input[name=rdPublishStatus]:checked').val()=="Y"){
        $("#publish_time").hide();
    }
});

    //Datepicker
    var dateToday = new Date(Date.now());
    $("#publishdate").datepicker({
        dateFormat: 'mm-dd-yy',
        minDate: dateToday
    }).datepicker('setDate', dateToday);


    $('#jQAddOpt').click(function(){

        $('#jQOptDiv').toggle();

    });

    /*var variants =  <?php echo json_encode($variantsArray); ?>;*/

    $('#btnAddVariant').click(function(){

        var catid = '<?php echo $_REQUEST['catid']?>';

        var variantname = $('#txtNewOption').val();
        var variantname = variantname.toLowerCase();

    //console.log(JSON.stringify(variants));

    if(variantname=="")
    {
        alert("Enter variant name");
        $('#txtNewOption').focus();
    }
    else{

       if ($.inArray(variantname, variants) != -1)
       {
        alert("Variant name already exists");
        return false;
    }

    else{

        variants.push(variantname);

        var dataString = {variantname:variantname,categoryid:catid};

        $.ajax({
            url     : "<?php echo SITE_URL?>/addProductVariantsAjax.php",
            type        : "POST",
            data        : dataString,
            dataType        : "json",
            success: function(data) {

            //$("#navcontainer ul").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
            $("#navcontainer ul").append('<li class="classoption_'+data['optionid']+'" id="option_'+data['optionid']+'">'+variantname+'<a href="javascript:;" class="jqVariantsOptionDeleteCheck"><i class="fa fa-times" aria-hidden="true" title="delete this variant"></i></a></li>&nbsp;');

    //alert(myFuncCalls);
///////////////////MANU////////////////////////
      //$("#default_setting_box_ID").append("<tr><td>"+ "ddd" +"</td></tr>");
      $("#default_setting_box_ID").append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data['optionid']+'"><label>'+ variantname +'</label><input name="option_'+data['optionid']+'[]" value="" type="text" class="form-control"></div>');

      for (var i = 1; i <= myFuncCalls; i++) {
        $("#default_setting_box_ID_"+i).append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data['optionid']+'"><label>'+ variantname +'</label><input name="option_'+data['optionid']+'[]" value="" type="text" class="form-control"></div>');
    }
////////////////////MANU END///////////////////////




                // $("#jqVariants > tbody").append("<tr><td>"+ variantname+"</td></tr>");

                // if(data.flag=='1')
                // {
                //     alert(data.message);
                //     return false;
                // }else{

                // }

                       // var flag =data.flag;
                         /*  if(flag=='Y')
                          {
                                $("#publish_time").show();
                                $("#jQPublishY").hide();
                                $('#jQPublish_N').prop('checked', true);

                         }else{

                                  $("#jQPublishY").show();
                                  $("#publish_time").hide();
                                  $('#jQPublish_Y').prop('checked', true);
                              }*/
                          }

                      });

    }
}
});


})


function changePublishSettings(sellerid)
{
   var action='vacationmodesetting';
   var sellerid   =   sellerid;
   var dataString = {"action":action,"sellerId":sellerid};

   $.ajax({
    url     : "<?php echo SITE_URL?>/utils.php",
    type        : "POST",
    data        : dataString,
    dataType        : "json",
    success: function(data) {
        var flag =data.flag;
        if(flag=='Y')
        {
            $("#publish_time").show();
            $("#jQPublishY").hide();
            $('#jQPublish_N').prop('checked', true);

        }else{

          $("#jQPublishY").show();
          $("#publish_time").hide();
          $('#jQPublish_Y').prop('checked', true);
      }
  }


});
}
function clickSearch()
{

    document.frmCatalog.submit();

}
function confirmDelete(){
  if( $('input[name="chkproducts[]"]:checked').length == 0){
      alert("Please select any product");
      return false;
  }
  if(confirm("<?php echo ARE_YOU_SURE_DELETE; ?>") ){
    return true;
}
return false;
}
function checkDigitalProduct()
{

    if(document.frmCatalog.txtDigitalProduct.checked == true)
    {

        document.getElementById("digitalProductBlock").style.display = "";
        $(".canshipBlock").hide();
        $("#allow_free_shipping").hide();

    }
    else
    {

        document.getElementById("digitalProductBlock").style.display = "none";
        $(".canshipBlock").show();
        $("#allow_free_shipping").show();

    }

}

function add_more_upload()
{
    var new_total = Math.round(document.frmCatalog.TOTAL_FILE.value) + 1;

    if(new_total<=document.frmCatalog.MAX_NO_IMAGES.value)
    {
        document.getElementById('pic'+document.frmCatalog.TOTAL_FILE.value).style.display='';
        document.frmCatalog.TOTAL_FILE.value++;
}//end if
}//end funciton

function checkEnter(e){
    e = e || event;
    return (e.keyCode || event.which || event.charCode || 0) !== 13;
}

var _URL = window.URL || window.webkitURL;

function showMyImage(files, imageId, dbImagePreview, fileInput) {
    var file = files[0];
    var img = new Image();
    var sizeKB = file.size / 1024;
    img.onload = function () {

        if(imageId == 'small_img_preview'){
            img_width = 200;
            img_height = 150;
        }
        else{

            img_width = 350;
            img_height = 245;
        }


        if (img.width < img_width) {

            warning_msg = "The image width should be " + img_width;
            alert(warning_msg);
            fileInput.value = '';
            return false;

        }
        else if (img.height < img_height) {

            warning_msg = "The image height should be " + img_height;
            alert(warning_msg);
            fileInput.value = '';
            return false;

        }
        else {
            var imageType = /image.*/;
            $(".jqMoreImagefromDb_" + dbImagePreview).remove();
            $("#" + imageId).show();
            var newimg = document.getElementById(imageId);
            newimg.file = file;
            var reader = new FileReader();
            reader.onload = (function (aImg) {
                return function (e) {
                    aImg.src = e.target.result;
                };
            })(newimg);
            reader.readAsDataURL(file);
        }


    }
    img.src = _URL.createObjectURL(file);
}


function showBigImages(files, value, fileInput ) {
    var file = files[0];
    var img = new Image();
    var sizeKB = file.size / 1024;

    img.onload = function () {

        img_width = 350;
        img_height = 245;

        if (img.width < img_width) {

            warning_msg = "The image width should be " + img_width;
            alert(warning_msg);
            fileInput.value = '';
            return false;

        }
        else if (img.height < img_height) {

            warning_msg = "The image height should be " + img_height;
            alert(warning_msg);
            fileInput.value = '';
            return false;

        }
        else {


            var imageType = /image.*/;

            var imageId = 'big_img_preview_' + value;
            $("#" + imageId).show();
            var newimg = document.getElementById(imageId);
            newimg.file = file;
            var reader = new FileReader();
            reader.onload = (function (aImg) {
                return function (e) {
                    aImg.src = e.target.result;
                };
            })(newimg);
            reader.readAsDataURL(file);
        }
    }
    img.src = _URL.createObjectURL(file);
}

function showSmallImages(files, value, fileInput) {
    var file = files[0];
    var img = new Image();
    var sizeKB = file.size / 1024;

    img.onload = function () {

        img_width = 200;
        img_height = 150;

        if (img.width < img_width) {

            warning_msg = "The image width should be " + img_width;
            alert(warning_msg);
            fileInput.value = '';
            return false;

        }
        else if (img.height < img_height) {

            warning_msg = "The image height should be " + img_height;
            alert(warning_msg);
            fileInput.value = '';
            return false;

        }
        else {
            var imageType = /image.*/;
            var imageId = 'small_img_preview_' + value;
            $("#" + imageId).show();
            var newimg = document.getElementById(imageId);
            newimg.file = file;
            var reader = new FileReader();
            reader.onload = (function (aImg) {
                return function (e) {
                    aImg.src = e.target.result;
                };
            })(newimg);
            reader.readAsDataURL(file);
        }
    }
    img.src = _URL.createObjectURL(file);
}
</script>
<script language="JavaScript" type="text/JavaScript">
    $(function() {
        $( "#tabDiv" ).tabs();
    });
</script>
<body>
<!-- <center>
    <div align="left" id="layout"> -->
        <div class="main_outer">
            <!--header area start -->
            <?php include_once("../includes/topheader_sellerNew.php"); ?>
            <!--header area end -->
            <!--     <div align="left" class="main_body"> -->
            <div class="clearfix"></div>

            <?php /*/////////////////////////Contant Area Starts //Manu R S - 21/09/17 */?>
            <div class="contant_area">

                <!--main body start -->
                <?php
                include_once("../includes/artisttopmenuNew.php")
                ?>
                <!-- ***************************************************************** -->
                <div class="right_main_cont_outer">
                 <div class="right_main_cont_inner">
                    <!--content area start -->
                    <h1><?php echo CATALOG; ?></h1>
           <?php /* <div align="center" class="text_information grey_tr"><?php
                if ($_GET['message'] != '') {
                    $message = $_GET['message'];
                }
                ?><?php echo $message ?></div>*/?>
                <!--div align="center" class="text_information_success grey_tr"-->
                <div align="center" class="text_information grey_tr"><?php
                    if ($_GET['message'] != '') {
                        $success_message = $_GET['message'];
                    }
                    ?><?php echo $success_message; ?></div>

                    <div class="full_width">
                        <form name="frmCatalog" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data" >
                            <input type="hidden" name="catid" id="txtCategoryID" value="<?php echo htmlentities($catid); ?>" />

                            <div class="clearfix"></div>
                            <h2><?php echo EXISTING_CAT; ?></h2>
                            <div class="bread_crumb_outer">
                                <ul>
                                    <?php echo getCategoryLinkNew("mycatalog.php", $catid) ?>
                                </ul>
                            </div>
                            <?php
                            if (!isset($catid) || $catid == "") {
                                $catid = 0;
                            }
                            $sql = "SELECT * FROM " . $tableprefix . "categories WHERE parent_id = :catid ORDER BY category_name ";
                            $res = $pdo->pdoQuery($sql, array("catid" => $catid))->results();
                            $odd = true;
                            if (count($res) != 0) {
                                ?>
                                <div class="table-responsive">
                                    <table width="100%" cellspacing="0" cellpadding="0" class="table admin_table">

                                        <tr>
                                            <th align="left" valign="top"><?php echo NAME; ?></th>
                                <!-- <th align="left" valign="top"><?php echo ADD_SUBCAT; ?></th>
                                <th align="left" valign="top"><?php echo DETAILS; ?></th>
                                <th align="left" valign="top"><?php echo EDIT; ?></th>
                                <th align="left" valign="top"><?php echo DELETE; ?></th> -->
                            </tr>
                            <?php
                            foreach ($res as $row) {
                                if ($row["gift_certificate_flag"] == 'Y') {
                                    $link_go = 'gift_coupon_artist.php?rghtMenu=rghtMenu5&displayDiv=Product Management';
                                } else {
                                    $link_go = 'mycatalog.php?catid=' . $row["category_id"] . '&parent=' . $catid . '';
                                }
                                ?>
                                <tr>
                                    <td align="left" valign="top"><?php echo "<a href='" . $link_go . "'>" . stripslashes($row["category_name"]) . "</a>"; ?></td>
                                    <!-- <td align="left" valign="top"><?php if ($row["gift_certificate_flag"] != 'Y') { ?> <?php echo "<a href='addcategory.php?catid=" . $row["category_id"] . "&parent=" . $catid . "' >+ ".ADD_SUBCAT."</a>"; ?><?php } ?></td> -->
                                    <!-- <td align="left" valign="top"><?php echo "<a href='" . $link_go . "'>".'<i class="fa fa-eye" aria-hidden="true"></i>'."</a>"; ?></td> -->
                                <!-- <td align="left" valign="top"><?php if ($row["gift_certificate_flag"] != 'Y') { ?>    <?php echo "<a href='editcategory.php?catid=" . $row["category_id"] . "&parent=" . $catid . "'  >".'<i class="fa fa-pencil" aria-hidden="true"></i>'."</a> " ?> <?php } ?></td>
                                <td align="left" valign="top"><?php if ($row["gift_certificate_flag"] != 'Y') { ?> <?php echo "<a href='catalog-delete.php?catid=" . $row["category_id"] . "&parent=" . $catid . "' onClick='return confirm(\"".ARE_U_SURE."\");'>".'<i class="fa fa-trash-o" aria-hidden="true"></i>'."</a>"; ?> <?php } ?></td> -->
                            </tr>
                            <?php
                        }

                        ?>
                    </table>
                </div>

                <?php } ?>

                <div class="clearfix"></div>

                <?php
                $checkleafcategory = " select *  FROM  " . $tableprefix . "categories where parent_id= :catid";
                $showproductadd = true;
                $Count = $pdo->pdoQuery($checkleafcategory, array("catid" => $catid))->results();
                if (count(($Count)) > 0) {
                    $showproductadd = false;
                }
                if (isset($catid) and $catid != "" and $showproductadd) {
                    ?>
                    <div class="clearfix"></div>
                    <h2><?php echo PRO_UNDER; ?></h2>
                    <div class="clearfix"></div>

                    <!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-5 col-lg-4"></div>
                        <div class="col-xs-12 col-sm-12 col-md-7 col-lg-8">
                            <div class="row">
                                <div class="col-xs-12 col-sm-4 col-md-2 search_txt"><?php echo SEARCH; ?></div>
                                <div class="col-xs-12 col-sm-4 col-md-4">
                                    <select name="cmbSearchType" class="form-control">
                                        <option value="all"><?php echo ALL_PRODUCTS; ?></option>
                                        <option value="productname"  <?php
                                        if ($cmbSearchType == "productname" || $cmbSearchType == "") {
                                            echo("selected");
                                        }
                                        ?>><?php echo PRODUCT_NAME; ?></option>
                                        <option value="artistname"  <?php
                                        if ($cmbSearchType == "artistname") {
                                            echo("selected");
                                        }
                                        ?>><?php echo TEXT_SELLER_NAME; ?></option>
                                        <option value="dateadded"  <?php
                                        if ($cmbSearchType == "dateadded") {
                                            echo("selected");
                                        }
                                        ?>><?php echo DATE_ADDED.TEXT_DATE_FORMAT; ?></option>
                                    </select>
                                </div>
                                <div class="col-xs-12 col-sm-4 col-md-4 search_txt_feild_outer">
                                    <input type="text" name="txtSearch" id="txtSearch" size="20" maxlength="50" value="<?php echo(htmlentities($txtSearch)); ?>"  class="form-control">
                                </div>
                                <div class="col-xs-12 col-sm-4 col-md-2">
                                    <a href="javascript:clickSearch();" class="pull-left normal_btt"><?php echo BTN_SEARCH; ?></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix">&nbsp;</div>

                    <div class="table-responsive">
                        <table border="0" width="100%" class="table admin_table" cellpadding="0" cellspacing="0">
                            <tr class="form_header">
                                <th>#</th>
                                <th>&nbsp;</th>
                                <th align='left'><?php echo PRODUCT_NAME; ?></th>
                                <th align='left'><?php echo TEXT_PRODUCT_CODE; ?></th>
                                <th align="left"><?php echo TEXT_PRICE; ?></th>
                                <th align='left'><?php echo REGISTERED.TEXT_DATE_FORMAT; ?></th>
                                <th align='left'><?php echo SELLER; ?></th>
                                <th align='left'></th>
                            </tr>
                            <?php
                            $i = $begin + 1;
                            foreach ($rs as $row) {
                                $link = "<a href='editmyproduct.php?productid=" . $row["product_id"] . "' class='links'>";
                                $check = "<input class='checkbox' type='checkbox' name='chkproducts[]' value='" . $row["product_id"] . "' class='smalllink'> ";
                                ?>
                                <tr class="whitebg" valign=top>
                                    <td><?php echo (($page * $limit) + $i - $limit) ?></td>
                                    <td valign=top align='left'><?php echo $check; ?></td>
                                    <td valign=top align='left' style='word-break:break-all;' class=boxalternatecolor2><?php echo $link . stripslashes($row["product_name"]) . "</a>"; ?></td>
                                    <td valign=top align='left'><?php echo $link . $row["product_code"] . "</a>"; ?></td>
                                    <td valign=top align='left'> <?php echo $adminCurrency['currency_symbol']; ?> <?php echo $link . htmlentities(number_format($row["product_price"], 2, '.', '')) . "</a>"; ?></td>
                                    <td valign=top align='left'><?php echo $link . dateFormat($row["date_added"], "Y-m-d", "m/d/Y") . "</a>"; ?></td>
                                    <td valign=top align='left' class="boxalternatecolor"><?php echo $link . $row["artist_name"] . "</a>"; ?>&nbsp;</td>
                                    <td valign=top align='left' class="boxalternatecolor">
                                        <?php $dbtnlink = "duplicatemyproduct.php?productid=" . $row["product_id"]; ?>
                                        <a onClick="return duplicateProduct();" href="<?php echo $dbtnlink; ?>" class="duplicate_btt">
                                            <i class="fa fa-files-o" aria-hidden="true"></i> Duplicate
                                        </a>
                                    </td>
                                </tr>
                                <?php
                                $i++;
                            }
                            ?>
                            <tr>
                                <td align="left" colspan="7">
                                    <span class="pull-left"><?php echo("Listing $navigate[1] of $totalrows results."); ?></span>
                                    <span class="pull-right"><?php echo($navigate[2]); ?></span>
                                </td>
                            </tr>
                        </table>
                    </div>



                    <div class="clear"></div>
                    <?php if (isNotNull($check)) { ?>
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-4"></div>
                        <div class="col-xs-12 col-sm-12 col-md-4"></div>
                        <div class="col-xs-12 col-sm-12 col-md-4 padding_B_30 padding_T_15">
                            <button type="submit" class="tertiary_btt" name="btnDeleteSelected" onClick="return confirmDelete();"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo TEXT_DELETE_SELECTED; ?></button>
                        </div>
                    </div>
                    <?php
                }
                ?>
                <div class="clear"></div>
                <!-- products adding area -->



                <div class="clearfix"></div>


                <!-- Add New Product Section Starts //Manu R S - 27/09/17 -->

                <input type="hidden" name="sellerid" id="clsSeller" value="<?php echo $artistid;?>">
                <input type="hidden" name="txtShippingDimension" id="clsShippingdimension" value="<?php echo $shipping_Dimension_Required;?>">

                <div class="clearfix"></div>
                <div class="right_cont_inner" id="tabDiv">
                    <div class="right_cont_inner_L">
                        <ul>
                            <li><a href="#tabs-1">Basic Info</a></li>
                            <li><a href="#tabs-2">Variants</a></li>
                            <li><a href="#tabs-3">Variant Details</a></li>
                        </ul>
                    </div> <!-- right_cont_inner_L ends -->

                    <div class="right_cont_inner_R">

                        <!-- /// INPUT Fields Starts //Manu R S - 27/09/17 -->
                        <div class="form_outer">
                            <h1>
                                <?php echo ADD_NEW_PRO; ?>
                                <div class="txt_R"><span class="required">*</span><?php echo MANDATORY_FIELDS; ?></div>
                            </h1>
                            <div class="clearfix"></div>
                            <div id="tabs-1">
                                <div class="clearfix"></div>
                                <div class="row">
                                    <div class="col-xs-12 col-sm-6 padding_B_30">
                                        <label>
                                            <?php echo PRODUCT_NAME; ?> &nbsp; <span class="required">*</span>
                                            <span class="help pull-right"><a href="#" title="<?php echo PRODNAME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                        </label>
                                        <input name="txtProductName" type="text" class="form-control" id="txtProductName" value="<?php echo $txtProductName; ?>" size="30" maxlength="100">
                                    </div>

                                    <div class="col-xs-12 col-sm-6 padding_B_30">
                                        <label>
                                            <?php echo TEXT_PRODUCT_CODE; ?>
                                            <span class="help pull-right"><a href="#" title="<?php echo PRODID_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                        </label>
                                        <input name="txtProductCode" type="text" class="form-control" id="txtProductCode" value="<?php echo $txtProductCode; ?>" size="20" maxlength="20">
                                    </div>

                                    <div class="col-xs-12 col-sm-6 padding_B_30">
                                        <label>
                                            <?php echo TEXT_SECTION; ?><!-- &nbsp;<span class="required">*</span> -->
                                            <span class="help pull-right"><a href="#" title="<?php echo SECTION_ADMIN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                        </label>
                                        <?php
                                        $behaviors = 'multiple';
                                        ?>
                                        <div>
                                            <?php
                                            if(sizeof($sectionlist)>0){
                                                echo makeDropDownList("sectionCat[]", $sectionlist, $sectionCat, false, 'form-control', $properties, $behaviors, 'IDsectionCat'); ?>

                                                <?php
                                            } else{
                                                echo "<font color='#0192c3'> Section not linked to Category </font>";
                                            }
                                            ?>
                                        </div>
                                        <?php
                                        $behaviors = '';
                                        ?>
                                    </div>

                    <!-- <div class="col-xs-12 col-sm-6 padding_B_30">
                        <label>
                            <?php echo SELLER; ?>&nbsp;<span class="required">*</span>
                            <span class="help pull-right">
                                <a href="#" title="<?php echo PRODSELLER_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                            </span>
                        </label>
                        <?php echo makeDropDownList("ddlArtist", $artistlist, $ddlArtist, false, 'form-control', $properties, $behaviors) ?>
                    </div> -->

                    <div class="col-xs-12 col-sm-12 padding_B_30">
                        <label>
                            <?php echo PRODUCT_DESCRIPTION_TEXT; ?> <span class="required">*</span>
                        </label>
                        <textarea id="editor1" name="txtDescription" class="form-control"><?php echo stripslashes($_POST['txtDescription']); ?></textarea>
                    </div>

                    <div class="col-xs-12 col-sm-6 padding_B_30 add_editproduct_price">
                        <label>
                            <?php echo TEXT_PRICE; ?>&nbsp;<span class="required">*</span>
                            <span class="help pull-right">
                                <a href="#" title="<?php echo PROD_PRICE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                            </span>
                        </label>
                        <input name="txtPrice"  type="text"  onpaste="return false;" class="jQNumeric form-control" id="txtPrice" value="<?php echo htmlentities($txtPrice); ?>" size="30" maxlength="100">
                        <span class="add_editproduct_price_inner"><?php echo $adminCurrency['currency_code']; ?></span>
                    </div>


                    <div class="col-xs-12 col-sm-6 padding_B_30" id="allow_free_shipping">
                        <label>
                            <?php echo TEXT_ALLOW_FREE_SHIPPING; ?>
                            <span class="help pull-right">
                                <a href="#" title="<?php echo FREE_SHIPPING_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                            </span>
                        </label>
                        <input type="checkbox" id="chkAllowFreeShipping"  name="chkAllowFreeShipping" value="Y" <?php echo $chkAllowFreeShipping; ?>>
                    </div>

                    <div class="col-xs-12 col-sm-12 padding_B_30">
                        <label>
                            <?php echo TEXT_SEARCH_TAGS; ?>
                            <span class="help pull-right">
                                <a href="#" title="<?php echo PROD_TAGS_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                            </span>
                        </label>
                        <textarea name="txtProductTags" cols="50" class="form-control height_70" rows="10" id="txtProductTags"><?php echo htmlentities($txtSearchTags);?></textarea>
                    </div>

                    <div class="full_width">
                        <!--<?php if(getSettingsValue('enable_subscription_products')=='Y') { ?>
                        <tr>
                        <td align="right"><?php echo TEXT_ALLOW_SUBSCRIPTION; ?>&nbsp;</td>
                        <td>:</td>
                        <td align='left'><input type="checkbox" id="chkAllowSubscription"  name="chkAllowSubscription" value="Y" <?php echo $chkAllowSubscription; ?>>
                        <span class="help"><a href="#" title="<?php echo ALLOW_SUBSCRIPTION_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                        </td>
                        </tr>
                        <tr id="subscription_mode" style="display: none;">
                        <td align="right"><?php echo TEXT_SUBSCRIPTION_MODE; ?>&nbsp;</td>
                        <td>:</td>
                        <td align='left'>
                        <input type="radio" name="rdSubscriptionMode" value="Daily" <?php if ($rdSubscriptionMode    == "Daily")   {   echo "checked"; }?>><?php echo TEXT_DAILY;?>
                        <input type="radio" name="rdSubscriptionMode" value="Monthly" <?php if ($rdSubscriptionMode  == "Monthly") {   echo "checked"; }?>><?php echo TEXT_MONTHLY;?>
                        <input type="radio" name="rdSubscriptionMode" value="Yearly" <?php if ($rdSubscriptionMode   == "Yearly")  {   echo "checked"; }?>><?php echo TEXT_YEARLY;?>
                        <span class="help"><a href="#" title="<?php echo SUBSCRIPTION_MODE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                        </td>
                        </tr>
                        <?php } ?>-->

                        <?php if(getSettingsValue('enable_product_scheduled_publishing')=='Y') {?>

                        <div class="col-xs-12 col-sm-6 padding_B_30">
                            <label>
                                <?php echo TEXT_PUBLISH_STATUS; ?>
                                <span class="help pull-right">
                                    <a href="#" title="<?php echo PUBLISH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                </span>
                            </label>
                            <span id="jQPublishY" >
                                <input  id="jQPublish_Y" type="radio" name="rdPublishStatus" class="rdPublishStatus" value="Y" <?php if ($rdPublishStatus  == "Y") {   echo "checked"; } elseif($rdPublishStatus==NULL){echo "checked";}?>><?php echo TEXT_PUBLISH_NOW;?>
                            </span>
                            &nbsp; &nbsp;
                            <span>
                                <input  id="jQPublish_N" type="radio" name="rdPublishStatus" class="rdPublishStatus" value="N" <?php if ($rdPublishStatus  == "N") {   echo "checked"; }?>>
                                <?php echo TEXT_PUBLISH_LATER;?>
                            </span>
                            <div class="publish_product_outer" id="publish_time" style="display: none;">
                                <div class="row">
                                    <div class="col-xs-12 col-sm-6">
                                        <label><?php echo TEXT_PUBLISH_DATE; ?></label>
                                        <input type="text" id="publishdate" name="publishdate" class="form-control">
                                    </div>
                                    <div class="col-xs-12 col-sm-6">
                                        <label>
                                            <?php echo TEXT_PUBLISH_TIME; ?>
                                            <span class="help pull-right">
                                                <a href="#" title="<?php echo TEXT_PUBLISH_TIME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                            </span>
                                        </label>
                                        <!--<td><input type="text" id="publishtime" class="tme" name="publishtime" style="width: 54px;"></td>-->
                                        <?php echo timepicker();?>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>

                        <?php }?>

                        <div class="col-xs-12 col-sm-6 padding_B_30">
                            <label>
                                <?php echo DIGITAL_PRODUCT; ?>
                                <span class="help pull-right">
                                    <a href="#" title="<?php echo DWNLD_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                </span>
                            </label>
                            <input type="checkbox" id="txtDigitalProduct"  name="txtDigitalProduct" value="Y" onClick="checkDigitalProduct();" <?php echo $chkDigitalProduct; ?>>
                        </div>

                        <div class="clearfix"></div>
                        <div  id="digitalProductBlock" style="display:<?php echo $digitalBlock; ?>">
                            <div class="col-xs-12 col-sm-12 padding_B_30">
                                <div class="full_width">
                                    <div class="image_upload_txt no_padding">
                                        <div class="digital_product_details_msg">
                                            <h2><?php echo MAX_ALLOWED_SIZE; ?> <?php echo $maximagesizestringinPHP; ?></h2>
                                            <h3 class="txt_clean">
                                                <?php echo ALLOWED_DIGITAL_FORMATS;?> :  <?php echo implode(",",$digital_product_types);?> &nbsp; <span class="help"><a href="#" title="<?php echo FILE_EXTN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                            </h3>
                                        </div>

                                        <div class="clearfix"></div>

                                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                                            <label>
                                                <?php echo UPLOAD_DIGPRO; ?> <span class="required">*</span>
                                                <span class="help pull-right">
                                                    <a href="#" title="<?php echo NO_DWNLD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                                </span>
                                            </label>
                                            <label class="btn-bs-file btn btn-lg btn-info upload_image">
                                                Choose File
                                                <input type="file" class="textarea" name="txtProductZip" id="txtProductZip">
                                            </label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                                            <label>
                                                <?php echo DWNLD_TRY;?>
                                            </label>
                                            <select name="txtDownloadTry" class="textarea" id="txtDownloadTry">
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    ?>
                                                    <option value="<?php echo $i ?>"><?php echo $i ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                            <div class="clearfix"></div>
                                            <span>Time(s)</span>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                                            <label>
                                                <?php echo D_EXPIRY; ?>
                                                <span class="help pull-right">
                                                    <a href="#" title="<?php echo LINK_EXPIRE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                                </span>
                                            </label>
                                            <select name="txtDownloadExpiry" class="textarea" id="txtDownloadExpiry">
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    ?>
                                                    <option value="<?php echo $i ?>"><?php echo $i ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                            <span>Day(s)</span>
                                        </div>

                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="clear"></div>
                        </div>

                    </div>


                    <div class="clearfix"></div>
                    <div class="col-xs-12">
                        <h1>Image Upload</h1>

                        <div id="canshipBlock" class="image_upload_txt" style="display:<?php echo $canshipblock; ?>">
                            <ul>
                                <li><span class="required">*</span> <?php echo TXT_SMALL_IMG; ?> - 400  X 300</li>
                                <li><span class="required">*</span> <?php echo TXT_BIG_IMG; ?> - 500 X 350</li>
                                <li><span class="required">*</span> <?php echo TXT_CP; ?></li>
                            </ul>
                        </div>

                        <div><?php echo MORE_IMG; ?> (jpg/gif/png)</div>

                        <div class="row">
                            <?php
                            $moreImagesql = "SELECT nproduct_image_id, nimage_productid,
                            vimage_name, vimage_description, vproduct_image_delete_status
                            FROM " . $tableprefix . "product_view_images
                            WHERE nimage_productid= :productid";
                            $result = $pdo->pdoQuery($moreImagesql, array("productid" => $productid))->results();
                            if (count($result) != 0) {
                            }
                            $moreImageMaxLImit = getSettingsValue('more_image_limit');
                            if ($moreImageMaxLImit > 0) {
                                for ($iCount = 0; $iCount < $moreImageMaxLImit; $iCount++) {
                                    ?>
                                    <div class="jqMoreImageContainer">

                                        <div class="col-xs-12 col-sm-6 image_upload_box_outer">
                                            <div class="image_upload_box_inner">
                                                <div class="row">
                                                    <div class="col-xs-12 col-sm-8">
                                                        <h2><?php echo MORE_IMAGE; ?> <?php echo $newCount = $iCount + 1; ?></h2>
                                                        <div class="clearfix"></div>
                                                        <label class="btn-bs-file btn btn-lg btn-info upload_file">
                                                            Choose File
                                                            <input type="file" name="productMoreImage[]"  onchange="showMyImage(this.files,'more_img_preview_<?php echo $newCount?>','<?php echo $newCount;?>',this)"/>
                                                        </label>
                                                    </div>
                                                    <div class="col-xs-12 col-sm-4">
                                                        <img style="display:none" src="" id="more_img_preview_<?php echo $newCount?>" border="0" width="183" height=" ">
                                                    </div>
                                                </div>
                                                <div class="clearfix"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                }
                            }
                            ?>
                        </div>

                        <div class="row">
                            <div class="button_outer">
                                <div class="col-xs-12 col-sm-12 col-md-4"></div>
                                <div class="col-xs-12 col-sm-12 col-md-4"></div>
                                <div class="col-xs-12 col-sm-12 col-md-4">
                                    <button class="primery_btt" id="primery_btt_tab_1"><i class="fa fa-chevron-right" aria-hidden="true"></i> Proceed</button>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- /// tabs-1 Ends //Manu R S - 27/09/17 -->
            <div id="tabs-2">

                <?php
                $options_arr = getOptionsFromCategory($catid);
                $num_of_options = count($options_arr);

                ?>

                <div id="messager" class="variant_options_msg_sucss" style="display: none;" >
                    <label>
                        Are you sure to delete the variant <span class="jqVariantsOptionName"></span> permanently ? This option is not used in any other products. Its safe to unlink from this category as well. Continue ?
                    </label>
                    <div class="clearfix"></div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-6 col-lg-8"></div>
                        <div class="col-xs-12 col-sm-6 col-md-3 col-lg-2">
                            <input type="button" name="jqVariantsOptionDeleteCancel" class="jqVariantsOptionDeleteCancel small_light_btt" value="No">
                        </div>
                        <div class="col-xs-12 col-sm-3 col-md-3 col-lg-2">
                            <input id="" type="button" name="jqVariantsOptionDelete" class="jqVariantsOptionDelete small_light_btt" value="Yes">
                        </div>
                    </div>
                </div>
                <div id="failedMessager" class="variant_options_msg_sucss" style="display: none;"></div>
                <div id="deletedMessager" class="variant_options_msg_sucss" style="display: none;">
                    <i class="fa fa-check" aria-hidden="true"></i> Option deleted successfully !!!
                </div>
                <div class="clearfix"></div>

                <div id="navcontainer" class="pull-left padding_B_30">
                    <ul >
                        <?php if($num_of_options>0)  {
                            foreach($options_arr as $opt) {
                                ?>
                                <!-- <li><a href="#"><?php echo $opt['option_name'];?></a></li> -->
                                <li class="classoption_<?php echo $opt['option_id']; ?>" id="option_<?php echo $opt['option_id']; ?>">
                                    <?php echo $opt['option_name'];?>
                                    <a href="javascript:;" class="jqVariantsOptionDeleteCheck" >
                                        <i class="fa fa-times" aria-hidden="true" title="delete this variant" ></i>
                                    </a>
                                </li>
                                <?php }
                            }
                            ?>

                        </ul>
                    </div>
                    <div id="jQOptDiv" class="row">
                        <div class="col-xs-12 col-sm-12">
                            <div class="addvariant_outer">
                                <input type="text" name="txtNewOption" id="txtNewOption" class="form-control" placeholder="<?php echo ADD_VARIANTS; ?>" >
                                <button type="button" name="btnAddVariant" class="addvariant_btt" id="btnAddVariant"><i class="fa fa-plus" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="button_outer">
                            <div class="col-xs-12 col-sm-12 col-md-4"></div>
                            <div class="col-xs-12 col-sm-12 col-md-4"></div>
                            <div class="col-xs-12 col-sm-12 col-md-4">
                                <button class="primery_btt" id="primery_btt_tab_2"><i class="fa fa-chevron-right" aria-hidden="true"></i> Proceed</button>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>

                </div><!-- /// tabs-2 Ends //Manu R S - 27/09/17 -->
                <div id="tabs-3">
                    <div class="variant_detail_outer">
                        <div class="variant_detail_top_outer">
                            <div class="col-xs-12 col-sm-5 col-md-4 col-lg-6"><h1>Variants</h1></div>
                            <div class="col-xs-12 col-sm-7 col-md-8 col-lg-6">

                                <?php
                                $dchecked = "";
                                $default = 1;
                                if (count($_POST['default_option']) == 0) {
                                    $dchecked = "checked";
                                }
                                if ($_POST['default_option'][0] == "1") {
                                    $dchecked = "checked";
                                    $default = $_POST['default_option'][0];
                                }
                                ?>
                                <div class="variants_top_btt_outer">
                                    <span class="variants_default_show_btt">
                                        <input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                        <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>"> &nbsp
                                        <?php echo DEFAULT_OPT; ?>
                                    </span>
                                    <span class="help"><a href="#" title="<?php echo MUL_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                    <!--button class="delete_btt pull-left"><i class="fa fa-trash-o" aria-hidden="true"></i></button-->
                                </div>
                            </div>
                            <div class="clearfix"></div>


                                <!-- <div class="col-xs-12 mmm">
                                    <input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                    <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>">
                                    <?php echo DEFAULT_OPT; ?>
                                    <span class="help"><a href="#" title="<?php echo MUL_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                                </div>
                                <div class="clearfix"></div> -->



                                <div class="default_setting_box" id="default_setting_box_ID"> <!-- default -->

                                    <?php
                                    $options_arr = getOptionsFromCategory($catid);
                                    $num_of_options = count($options_arr);

                                    if ($num_of_options != "") {
                                        foreach ($options_arr AS $eachoption) {
                                            echo "<div class='col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_". $eachoption['option_id']. "'><label>" . $eachoption['option_name'] . "</label>";
                                            ?>

                                            <span class="category_option_field"><input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][0]; ?>" class="form-control"></span>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                                <!-- <div class="clearfix"></div> -->
                            </div>


                            <div class="clearfix"></div>
                        </div>
                        <div class="variant_detail_bottom_outer">
                        <!-- <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php //echo DEFAULT_OPT; ?>
                                <span class="help pull-right">
                                    <a href="#" title="<?php //echo MUL_PROD_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                </span>
                            </label>
                            <input name="" class="form-control" type="text">
                        </div> -->
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php echo ADD_PRICE; ?> (<?php echo $adminCurrency['currency_code']; ?>)
                                <span class="help pull-right">
                                    <a href="#" title="<?php echo EXTRA_PRICE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                </span>
                            </label>
                            <input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" value="<?php echo $_POST['additional_price'][0]; ?>" class="jqPrice jQNumeric form-control">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php echo PRODUCT_STOCK; ?> <span class="required">*</span>
                                <span class="help pull-right">
                                    <a href="#" title="<?php echo AVAIL_STK_TOOLTIP; z?>"><img src="../images/question_mark.jpg" border="0" height="15"></a>
                                </span>
                            </label>
                            <input type="text" name="product_stock[]" class="clsProductStock jQNumeric form-control" id="product_stock[]" value="<?php echo $_POST['product_stock'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php echo REORDER_LEVEL; ?>
                                <span class="help"><a href="#" title="<?php echo STK_LEVEL_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" class="jQNumeric form-control" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php echo DISCOUNT; ?> (%)
                                <span class="help pull-right"><a href="#" title="<?php echo DISC_PERC_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" name="discount[]" id="discount[]" class="form-control" value="<?php echo $_POST['discount'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php echo DISCOUNT_DESC; ?>
                                <span class="help pull-right"><a href="#" title="<?php echo EX_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" name="discount_description[]" id="discount_description[]" class="form-control" value="<?php echo $_POST['discount_description'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                            <label>
                                <?php echo SW_LBS; ?>&nbsp;<span class="required">*</span>
                                <span class="help pull-right"><a href="#" title="<?php echo PWEIGHT_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" class="clsShippingWeight jQNumeric form-control" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                            <label>
                                <?php echo LENGTH; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                <span class="help pull-right"><a href="#" title="<?php echo PLEN_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" class="clsProductlength jQNumeric form-control" name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                            <label>
                                <?php echo WIDTH; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                <span class="help pull-right"><a href="#" title="<?php echo PWIDTH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" class="clsProductwidth jQNumeric form-control" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][0]; ?>">
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                            <label>
                                <?php echo HEIGHT; ?> <?php if($shipping_Dimension_Required=='Y') { ?> <span class="required">*</span> <?php } ?>
                                <span class="help pull-right"><a href="#" title="<?php echo PHEIGHT_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <input type="text" class="clsProductheight jQNumeric form-control" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][0]; ?>">
                        </div>





                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                            <label>
                                <?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span>
                                <span class="help pull-right"><a href="#" title="<?php echo IMG_DISP_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
                            </label>
                            <label class="btn-bs-file btn btn-lg btn-info upload_image">
                                Choose File
                                <input type="file" name="image_big[]" id="image_big[]" onChange="showMyImage(this.files,'big_img_preview','bigimagepreview',this)" value="<?php echo $_POST['image_big'][0]; ?>">
                            </label>
                            <img style="display:none" src="" id="big_img_preview" border="0" width="183" height="auto">
                        </div>

    <!-- <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
        <label>
            <?php echo SMALL_IMG; ?>&nbsp;
            <span class="help pull-right"><a href="#" title="<?php echo IMGLIST_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
        </label>
        <label class="btn-bs-file btn btn-lg btn-info upload_image">
            Choose File
            <input type="file" name="image_small[]" id="image_small[]" value="<?php echo $_POST['image_small'][0]; ?>" onChange="showMyImage(this.files,'small_img_preview','smallimagepreview',this)">
        </label>
        <img style="display:none" src="" id="small_img_preview" border="0" width="183" height="auto">
    </div> -->



    <div class="clearfix"></div>
</div>
<div class="clearfix"></div>
</div>

<div class="table-responsive">
    <!-- <table cellpadding="2" cellspacing="2" border="0" class="admin_table table" id="options_window" width="100%" > -->
    <div border="0" id="options_window">

        <?php
        for ($i = 1; $i < $options_count; $i++) {
            ?>
            <div class="variant_detail_outer option_block">
                <div class="variant_detail_top_outer">
                    <div class="col-xs-12 col-sm-5 col-md-4 col-lg-6">
                        <h1>Variants</h1>
                    </div>
                    <div class="col-xs-12 col-sm-7 col-md-8 col-lg-6">
                        <?php
                        $dchecked = "";
                        $default = "";
                        ?>
                        <div class="variants_top_btt_outer">
                            <button class="variants_default_show_btt">
                                <input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                                <input type="hidden" name="product_option_id[]" value="<?php echo $otherOptionObj->product_option_id; ?>">
                                <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>"> &nbsp;
                                <?php echo DEFAULT_OPT; ?>
                            </button>
                            <button class="delete_btt pull-left" title="Delete Option" onClick="javascript:delete_option(this);">
                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                            </button>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="default_setting_box" id="default_setting_box_ID_<?php echo $oc; ?>_<?php echo $oc; ?>">

                        <?php
                        $options_arr = getOptionsFromCategory($ddlCategory);
                        $num_of_options = count($options_arr);
                        if ($num_of_options != "") {
                            $k = 0;
                            foreach ($options_arr AS $eachoption) {
                                echo "<div class='col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_". $eachoption['option_id']. "'><label>" . $eachoption['option_name'] .'</label>';
            //getting the value of the option assigned
                                $query_option_value = "SELECT value FROM " . $tableprefix . "product_option_values WHERE product_option_id = :product_option_id AND option_id = :option_id";
                                $query_option_valueQ = $pdo->pdoQuery($query_option_value, array("product_option_id" => $otherOptionObj->product_option_id, "option_id" => $eachoption['option_id']))->results();
                                $option_value_obj = (object)($query_option_valueQ[0]);
                                ?>
                                <input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $option_value_obj->value; ?>" class="form-control">

                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>

                <div class="clearfix"></div>
            </div>

            <div class="clearfix"></div>

            <div class="variant_detail_bottom_outer">
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                    <label><?php echo ADD_PRICE; ?> (<?php echo $adminCurrency['currency_code']; ?>)</label>
                    <input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $otherOptionObj->additional_price; ?>" class="jqPrice form-control">
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                    <label><?php echo PRODUCT_STOCK; ?> <span class="required">*</span></label>
                    <input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $otherOptionObj->product_stock; ?>" class="form-control">
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                    <label><?php echo REORDER_LEVEL; ?></label>
                    <input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $otherOptionObj->reorder_level; ?>" class="form-control">
                </div>


                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                    <label><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></label>
                    <input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $otherOptionObj->product_shipping_weight; ?>" class="form-control">
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                    <label><?php echo LENGTH; ?> (<?php echo CM; ?>)</label>
                    <input type="text" name="product_length[]" id="product_length[]" value="<?php echo $otherOptionObj->product_length; ?>" class="form-control">
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                    <label><?php echo WIDTH; ?> (<?php echo CM; ?>)</label>
                    <input type="text" name="product_width[]" id="product_width[]" value="<?php echo $otherOptionObj->product_width; ?>" class="form-control">
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
                    <label><?php echo HEIGHT; ?> (<?php echo CM; ?>)</label>
                    <input type="text" name="product_height[]" id="product_height[]" value="<?php echo $otherOptionObj->product_height; ?>" class="form-control">
                    <div class="clearfix"></div>

                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                    <label><?php echo DISCOUNT_PERC; ?></label>
                    <input type="text" name="discount[]" id="discount[]" value="<?php echo $otherOptionObj->discount; ?>" class="form-control">
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                    <label><?php echo DISCOUNT_DESC; ?></label>
                    <input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($otherOptionObj->discount_description); ?>" class="form-control">
                </div>


                <?php
                $image_small = "";
                $image_big = "";
                $product_image_path = "../products/";
                if ($otherOptionObj->image_small != "") {
                    if ((strstr($otherOptionObj->image_small, "http://")) || (strstr($otherOptionObj->image_small, "https://")))  {
                        $image_small = $otherOptionObj->image_small;
                    } else {
                        $image_small = $product_image_path . $otherOptionObj->image_small;
                    }
                }
                if ($otherOptionObj->image_big != "") {
                    if (strstr($otherOptionObj->image_big, "http://") || strstr($otherOptionObj->image_big, "https://")) {
                        $image_big = $otherOptionObj->image_big;
                    } else {
                        $image_big = $product_image_path . $otherOptionObj->image_big;
                    }
                }
                ?>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                    <label><?php echo BIG_IMG; ?></label>
                    <label class="btn-bs-file btn btn-lg btn-info upload_image">
                        Choose File
                        <input type="file" name="image_big[]" id="image_big[]" value="" onChange="showBigImages(this.files, '<?php echo $k ?>',this);">
                    </label>

                    <?php
                    if ($image_big != "") {
                        ?>
                        <img src="<?php echo $image_big ?>" id="big_img_preview_<?php echo $k ?>" border="0" width="183" height="auto">
                        <?php
                    }
                    ?>
                </div>
        <!-- <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
            <label><?php echo SMALL_IMG; ?></label>
            <label class="btn-bs-file btn btn-lg btn-info upload_image">
                Choose File
                <input type="file" name="image_small[]" id="image_small[]" value="" onChange="showSmallImages(this.files, '<?php echo $k ?>',this);">
            </label>

            <?php
            if ($image_small != "") {
            ?>
            <img src="<?php echo $image_small ?>" border="0" width="183" height="auto" id="small_img_preview_<?php echo $k ?>">
            <?php
            }
            ?>
        </div> -->
        <div class="clearfix"></div>
    </div>
    <?php
}
?>
<!-- </table> -->
</div>
</div>

<div class="row">
    <div class="button_outer">

        <?php
        $options_arr = getOptionsFromCategory($catid);
        $num_of_options = count($options_arr);
        //if ($num_of_options >= 1) {   ?>

        <div class="col-xs-12 col-sm-12 col-md-4">
            <button type="button" name="add_more_options"  id="add_more_options" class="secondary"><i class="fa fa-plus" aria-hidden="true"></i> <?php echo ADD_OPTIONS;?></button>
            <input type="hidden" name="add_value" id="add_value" value="0">
        </div>
        <?php
        //}
        ?>
        <div class="col-xs-12 col-sm-12 col-md-4"></div>
        <div class="col-xs-12 col-sm-12 col-md-4">
            <button type="submit" class="primery_btt" name="btnAddProduct" onClick="return validateProductForm(3,'a');"><i class="fa fa-floppy-o" aria-hidden="true"></i> <?php echo BTN_ADD_PROD; ?></button>
        </div>
        <div class="clearfix"></div>
    </div>



</div>

</div><!-- /// tabs-3 Ends //Manu R S - 27/09/17 -->
<!-- /// INPUT Fields Ends //Manu R S - 27/09/17 -->


</div>



</div>

</div> <!-- right_cont_inner_R ends -->
</div> <!-- right_cont_inner ends -->



<!-- Add New Product Section Ends //Manu R S - 27/09/17 -->
<?php } else {
    ?>
    <div class="clearfix">&nbsp;</div>
    <div class="row">
        <div class="col-xs-12"><?php echo TEXT_LEAF_LEVEL; ?></div>
    </div>

    <?php }
    ?>


</form>
</div>
<!--content area end-->
<div class="clearfix"></div>


</div> <!-- right_main_cont_inner ends -->
</div> <!-- right_main_cont_outer ends -->

</div>
<!--main body end -->

<?php
include "../includes/footer_sellers.php";
?>

</div>
</body>
</html>
<script type="text/javascript">
    var msgProductName = "<?php echo MSG_PRODUCT_NAME; ?>";
    var msgProductPrice = "<?php echo MSG_PRODUCT_PRICE; ?>";
</script>
<script src="../js/product-check-seller.js"  type="text/javascript"></script>

<?php

function getStrOptions($catid) {
    $options_arr = getOptionsFromCategory($catid);
    $num_of_options = count($options_arr);
    $StrOptions = "";
    if ($num_of_options != "") {
        foreach ($options_arr AS $eachoption) {
            $StrOptions .='<br><br><span class="category_option_label">' . $eachoption['option_name'] . '</span>';
            $StrOptions .='<span class="category_option_field"><input type="text" name="option_' . $eachoption['option_id'] . '[]" value=""></span>';
        }
    }
    return $StrOptions;
}

?>
<script type="text/javascript" src="<?php echo SITE_URL ?>/js/blockUI.js"></script>
<script type="text/javascript" src="<?php echo SITE_URL ?>/ckeditor/ckeditor.js"></script>
<?php
                    /*$options_arr = getOptionsFromCategory($catid);
                    $num_of_options = count($options_arr);
                    $StrOptions = "";
                    if ($num_of_options != "") {
                    foreach ($options_arr AS $eachoption) {
                    $StrOptions .='<br><br><span class="category_option_label">' . $eachoption['option_name'] . '</span>';
                    $StrOptions .='<span class="category_option_field"><input type="text" name="option_' . $eachoption['option_id'] . '[]" value=""></span>';
                    }
                }*/


                $StrOptions = getStrOptions($catid);

//echopre($StrOptions);

                ?>
                <script type="text/javascript">
                    window.onload = function()
                    {
                        var editor =  CKEDITOR.replace( 'editor1'
                            , {
                                filebrowserBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html',
                                filebrowserImageBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Images',
                                filebrowserFlashBrowseUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Flash',
                                filebrowserUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                                filebrowserImageUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                                filebrowserFlashUploadUrl : '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
                            });
                        CKFinder.setupCKEditor( editor, '<?php echo SITE_URL ?>/ckeditor/ckfinder/' );
                    };
//Santhosh thomas Alexander coded this
//This is to do dynamic options add
$(document).ready(function(){
    /*var myFuncCalls = 0;*/
    /*$("#add_more_options").click(function() {
        myFuncCalls++;
        var addVal = $("#add_value").val();
        var catid_val = '<?php echo $catid; ?>';
        $("#add_value").val(parseInt(addVal)+1);
        var block = '<tr class="option_block"><td><table width="100%" cellpadding="2" cellspacing="2" border="0" bgcolor="#CCCCCC"><tr><th><?php echo DEFAULT_OPT; ?></th><th><?php echo ADD_PRICE; ?> &nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</th><th><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></th><th><?php echo REORDER_LEVEL; ?>&nbsp;</th></tr><tr><td><span class="default_setting_box" id="default_setting_box_ID_'+myFuncCalls+'"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"><input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value=""><?php //echo getStrOptions($catid); ?><br></span></td><td><input type="text" name="additional_price[]"  onpaste="return false;" id="additional_price[]" value="" class="jqPrice jQNumeric"></td><td><input type="text" name="product_stock[]" id="product_stock[]" value="" class="clsProductStock jQNumeric"></td><td><input type="text" name="reorder_level[]" id="reorder_level[]" value="" class="jQNumeric"></td></tr><tr><th><?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span></th><th><?php echo SMALL_IMG; ?>&nbsp;</th><th><?php echo DISCOUNT_PERC; ?></th><th><?php echo DISCOUNT_DESC; ?></th></tr><tr><td><input type="file" name="image_big[]" id="image_big[]" onchange="showBigImages(this.files,'+addVal+',this);" value=""><img src="" style="display:none" width="183" height="191" id="big_img_preview_'+addVal+'"></td> <td><input type="file" name="image_small[]" id="image_small[]" onchange="showSmallImages(this.files,'+addVal+',this);" value=""><img src="" style="display:none" width="183" height="191" id="small_img_preview_'+addVal+'"></td><td><input type="text" name="discount[]" id="discount[]" value="" class="jQNumeric"></td><td><input type="text" name="discount_description[]" id="discount_description[]" value=""></td></tr><tr class="canshipBlock"><th><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></th><th><?php echo LENGTH; ?> &nbsp;<span class="required">*</span></th><th><?php echo WIDTH; ?> &nbsp;<span class="required">*</span></th><th><?php echo HEIGHT; ?> &nbsp;<span class="required">*</span>  </th></tr><tr class="canshipBlock"><td><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="jQNumeric"></td><td><input type="text" name="product_length[]" id="product_length[]" value="" class="jQNumeric"></td><td><input type="text" name="product_width[]" id="product_width[]" value="" class="jQNumeric"></td><td><input type="text" name="product_height[]" id="product_height[]" value="" class="jQNumeric">&nbsp;<img border="0" title="<?php echo TITLE_DELETE_OPTION; ?>" src="../images/btn_del.gif" alt="<?php echo TITLE_DELETE_OPTION; ?>" class="delete_option" onclick="javascript:delete_option(this);"></td></tr></table></td></tr>';
        $("#options_window").append(block);
        // Manu R S 12/08/17 S
        var dataString = {categoryid:catid_val};
        $.ajax({
        url     : "<?php echo SITE_URL?>/getStrOptionsAjax.php",
        type        : "POST",
        data        : dataString,
        dataType        : "json",
        success: function(data) { console.log(data);
        //$("#options_window").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
        //$("#navcontainer ul").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
        ///////////////////MANU////////////////////////
        //$("#options_window").append("<tr><td>"+ "ddd" +"</td></tr>");
        //alert(data.length);
        var divid = "#default_setting_box_ID_"+myFuncCalls;
        for (var i = 0; i < data.length; i++) {
        $(divid).append('<br><br><span class="category_option_label">'+ data[i]['option_name'] +'</span><span class="category_option_field"><input name="option_'+data[i]['option_id']+'[]" value="" type="text"></span>');
        }      }});
        //  $("#options_window").append(  $( "#default_setting_box_ID" )   );
        // Manu R S 12/08/17 E
        $('.jqPrice').keyup(function(e){
        var price = parseFloat($(this).val());
        var newVal = $(this).val().replace(/[^\d.]/, '');
        var number = (newVal.split('.'));
        $(this).val(newVal);
        if (typeof(number[1]) != "undefined"){
        if (number[1].length > 2)
        {
        $(this).val( price.toFixed(2));
        }
        }
        });
        checkDigitalProduct();
    });*/
}); ////documents closing



function setDefaultOption(obj) {
    $(".default_option").val("");
    //$(obj).parents(".default_setting_box").find(".default_option").val("1");
    $(obj).parents(".variants_top_btt_outer").find(".default_option").val("1");
}

function delete_option(obj) {
    $(obj).parents(".option_block").hide("slow");
    $(obj).parents(".option_block").html("");
}
</script>
