<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | Bulk Upload final step, Validation of csv, insert in to database     |
// | File name : mybulkupload_check.php                                     |
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Author: Binu Chandran<binu.chandran@armiasystems.com>	          |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (C) 2011              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
/*
 * Include necessary files
 */
include "../includes/config.php";
include "../includes/session.php";
include('../includes/class.upload.php');
include "../includes/functions.php";
include_once('../classes/cls_utils.php');
include_once('../classes/cls_products.php');
include_once('../classes/cls_store.php');
/*
 * Checking for seller login
 * If not logged in, will redirect to login
 */
if(isset( $_SESSION["sess_artistid"]) and $_SESSION["sess_artistid"]!= ""){
	$artistid = $_SESSION["sess_artistid"];
}else{
	header("Location:login.php");
	exit;
}
if(checkArtistExpired($artistid)){
    header("Location:seller_plan_upgrade.php?sellerid=".$artistid);
    exit;
}

/**
 * Method to add product option
 * @global type $tableprefix
 * @param type $newProduct
 * @param type $productID
 * @param type $default
 */
function addProductOption($newProduct, $productID, $default='NO',$pdo)
{
    global $tableprefix, $pdo;
    //Adding product option
//    $insQuery = "INSERT INTO " . $tableprefix . "product_options
//                    SET product_id = '" . mysql_real_escape_string($productID) . "',
//                        additional_price = '" . mysql_real_escape_string($newProduct['additional_price']) . "',
//                        image_small = '" . mysql_real_escape_string($newProduct['small_image']) . "',
//                        image_big = '" . mysql_real_escape_string($newProduct['big_image']) . "',
//                        product_stock = '" . mysql_real_escape_string($newProduct['product_stock']) . "',
//                        reorder_level = '" . mysql_real_escape_string($newProduct['reorder_level']) . "',
//                        product_shipping_weight = '" . mysql_real_escape_string($newProduct['shipping_weight']) . "',
//                        default_option = '" . $default . "',
//                        discount = '" . mysql_real_escape_string($newProduct['discount']) . "',
//                        discount_description = '" . mysql_real_escape_string($newProduct['discount_description']) . "',
//                        product_width = '" . mysql_real_escape_string($newProduct['product_width']) . "',
//                        product_height = '" . mysql_real_escape_string($newProduct['product_height']) . "',
//                        product_length = '" . mysql_real_escape_string($newProduct['product_length']) . "'";
//
//    $insRes   = mysql_query($insQuery) or die(mysql_error());
    $insertDataArr = array(
        "product_id" => $productID,
        "additional_price" => $newProduct['additional_price'],
        "image_small" => $newProduct['small_image'],
        "image_big" => $newProduct['big_image'],
        "product_stock" => $newProduct['product_stock'],
        "reorder_level" => $newProduct['reorder_level'],
        "product_shipping_weight" => $newProduct['shipping_weight'],
        "default_option" => $default,
        "discount" => $newProduct['discount'],
        "discount_description" => $newProduct['discount_description'],
        "product_width" => $newProduct['product_width'],
        "product_height" => $newProduct['product_height'],
        "product_length" => $newProduct['product_length']
        );
    $insRes = $pdo->insert($tableprefix . "product_options",$insertDataArr )->lastInsertId();
    
    if($newProduct['big_image'])
    {
        $array = explode('/',$newProduct['big_image']);
        $lastimg = $array[count($array)-1];
        $imagpath = realpath(__DIR__ . '/..')."/products/".$lastimg;
        $handle = new Upload($imagpath);
        if ($handle->uploaded) {
            $dir_dest = "../products";
            
                            // Modification resize
                            //   $info = getimagesize($inputFileName);
            $handle->image_resize = true;
            $handle->image_ratio = true;
            $handle->image_x = 387;
            $handle->image_y = 260;
            $handle->file_new_name_body = "small_".$lastimg;
            $handle->Process($dir_dest);
            $small_image_name_after_upload = $handle->file_dst_name;
                            //echopre1($handle);
                            // $imagepath = "../products/" . $small_image_name_after_upload;
                            // moveImageToCDN($imagepath, 'products/' . $small_image_name_after_upload);
            $data1 =array();
            $data1["default_image_small"] = $small_image_name_after_upload;
            $res = $pdo->update($tableprefix.'products', $data1, array("product_id" => $productID))->affectedRows();
                            //echopre($data1);
                            //echopre1($res);
            
        }
    }
    
    
    if(!empty($insRes))
    {
//        $productOptionID = mysql_insert_id();
        $productOptionID = $insRes;
        if($productOptionID > 0)
        {
            /*
            * Adding options
            */
          // echopre1($newProduct['options']);
            if(isset($newProduct['options']))
            {
                if(!empty($newProduct['options']))
                {
                    foreach($newProduct['options'] as $optID => $optValue)
                    {
//                        $insOptQuery = "INSERT INTO " . $tableprefix . "product_option_values
//                            SET product_option_id = '" . mysql_real_escape_string($productOptionID) . "',
//                                option_id = '" . mysql_real_escape_string($optID) . "',
//                                value = '" . mysql_real_escape_string($optValue) . "'";
//                         mysql_query($insOptQuery) or die(mysql_error());
                        $insertDataArr = array(
                            'product_option_id' => $productOptionID,
                            'option_id' => $optID,
                            'value' => $optValue
                            );
                        $pdo->insert($tableprefix . "product_option_values", $insertDataArr);
                    }
                }
            }
        }
    }
}
/**
 * Method to rearrange csv data with schema
 * @global type $csvSchema
 * @global type $inventory
 */
function rearrangeCSVData()
{
    global $csvSchema;
    global $inventory;

    foreach($inventory as $key => $productItem)
    {
        foreach($productItem as $keyPrd => $product)
        {
            if($keyPrd == 'option_product')
            {
                $inventory1 = $product;
                if(is_array($inventory1) && !empty($inventory1))
                {
                    foreach($inventory1 as $key1 => $productItem1)
                    {
                        foreach($productItem1 as $keyPrd1 => $product1)
                        {
                            $inventory[$key][$keyPrd][$key1][$keyPrd1] =  $inventory[$key][$keyPrd][$key1][$csvSchema[$keyPrd1]];
                        }
                    }
                }
            }
            else
            {
                $inventory[$key][$keyPrd] = $inventory[$key][$csvSchema[$keyPrd]];
            }

            /*if($keyPrd = 'allow_free_shipping'){
            }*/
        }
    }
}

/*
 * Read csv file
 */
$csvfilename    =   $_GET['file'];
$filepath       =   "../csv/$csvfilename";
$sampleFilepath =   "../csv/sample.csv";
/*
 * Assign seller id
 */
$sellerid       =   $artistid;
$publishStatus  =   $_GET['publishstatus'];
$publishTime    =   $_GET['publishtime'];
$sellertimezone =   $_GET['sellertimezone'];
/*
* chechk sample csv file exixts or not
*/

if(file_exists($sampleFilepath))
{
    $fcontents = file($sampleFilepath);
    $headers=str_replace('"',"",$fcontents[0]);
    $sampleArray=explode(",",$headers);
}

/*
* check file exists
*/
if(file_exists($filepath))
{
    $fcontents  =   file($filepath);
    $header     =   str_replace('"', "", $fcontents[0]);
    $listArray  =   explode(",", $header);
}



$message    =   "";
$flag       =   "true";
/*
* Post back
*/
if(isset($_POST['btnSave']))
{
	$csvfiles=$_POST['csvfilename'];
	$csvFile="../csv/$csvfiles";
	$sellerid       =   $artistid;
        /*
         * Initialize CSV Schema
         */
        $csvSchema  = array('product_name'          => $_POST['labelsproduct_name'],
            'product_category'      => $_POST['labelsproduct_category'],
            'product_code'          => $_POST['labelsproduct_code'],
            'product_description'   => $_POST['labelsproduct_description'],
            'product_price'         => $_POST['labelsproduct_price'],
            'options'               => $_POST['labelsoptions'],
            'additional_price'      => $_POST['labelsadditional_price'],
            'product_stock'         => $_POST['labelsproduct_stock'],
            'reorder_level'         => $_POST['labelsreorder_level'],
                            //'small_image'           => $_POST['labelssmall_image'],
            'big_image'             => $_POST['labelsbig_image'],
            'more_images'           => $_POST['labelsmore_images'],
            'discount'              => $_POST['labelsdiscount'],
            'discount_description'  => $_POST['labelsdiscount_description'],
            'shipping_weight'       => $_POST['labelsshipping_weight'],
            'product_length'        => $_POST['labelsproduct_length'],
            'product_width'         => $_POST['labelsproduct_width'],
            'product_height'        => $_POST['labelsproduct_height'],
            'product_tags'          => trim($_POST['labelsproduct_tags']),
            'allow_free_shipping'   => trim($_POST['labelsallow_free_shipping']),
                            //'allow_subscription'    => $_POST['labelsallow_subscription'],
                            //'subscription_mode'     => $_POST['labelssubscription_mode'],
            );
        /*
         * Validating mandatory fields
         */
        if( $csvSchema['product_name'] == '' )
        {
            $message .= VAR_MSG_PNAME;
        }
        if( $csvSchema['product_category'] == '' )
        {
            $message .= VAR_MSG_PNAME_EMP;
        }

        if( $csvSchema['product_price'] == '' )
        {
            $message .= VAR_MSG_PPRICE;
        }
        if( $csvSchema['product_description'] == '' )
        {
            $message .= VAR_MSG_PDESC;
        }
	/*
         * Read and processing CSV File
         */
    if(file_exists($csvFile))
    {
        $maxlinelength  = 10000;
        $fh             = fopen($csvFile, 'r');
        $lines          = count(file($csvFile))-1;
        $firstline      = fgetcsv($fh, $maxlinelength,',');
        $cols           = count($firstline);
        $row            = 1;
        $inventory      = array();
        $addedProducts  = array();
            /*
             * Read line by line of CSV
             */
            while ( ($nextline = fgetcsv($fh, $maxlinelength,',')) !== FALSE )
            {
                /*
                 * Initialize variables
                 */
                $product            = array();
                $categorySelected   = 0;
                $productName        = '';
                $options            = array();
                foreach($nextline as $key => $productRow)
                {
                    $val = trim($sampleArray[$key]);
                    $product[$val]    = $productRow;
                    /*
                    * Validations start here
                    */
                    $categoryError = false;

                    switch($sampleArray[$key])
                    {
                        case 'product_tags':
                        if($productRow == '')
                        {
                            $product_tags = '';
                        }
                        else
                        {
                            $product_tags = $productRow;
                        }
                        break;
                        case 'product_name':
                        if($productRow == '')
                        {
                            $message .= VAR_MSG_PNAME_EMP. $row . ".<br>";
                        }
                        else
                        {
                            $productName = $productRow;
                        }
                        break;
                        case 'product_category':
                        if($productRow == '')
                        {
                            $message .= VAR_MSG_PCAT_EMP . $row . ".<br>";
                            $categoryError = true;
                        }
                        else
                        {

//                                    $catQuery    =   "SELECT category_id FROM ".$tableprefix."categories
//                                                   WHERE category_name ='" . mysql_real_escape_string($productRow) . "'";
//
//                                    $rs = mysql_query($catQuery) or die(mysql_error());
//                                    $numrows = mysql_num_rows($rs);
                            

                          $catQuery    =   "SELECT category_id FROM ".$tableprefix."categories
                          WHERE category_name =:categoryname";
                          
                          $numrows = $pdo->pdoQuery($catQuery,array('categoryname'=>$productRow))->result(); 
                          if(empty($numrows))
                          {
                            $message .= VAR_MSG_PCAT_EMP . $row . ".<br>";
                            $categoryError = true;
                        }
                        else
                        {
//                                            $pRow = mysql_fetch_object($rs);
                            $pRow = $numrows;
                            
                            if($pRow['category_id']> 0)
                            {
                             $categorySelected = $pRow['category_id'];
                         }

                         $catQuery =   "SELECT COUNT(category_id) as total FROM ".$tableprefix."categories
                         WHERE category_name =:cname AND category_id IN (SELECT parent_id FROM ".$tableprefix."categories)";

                         $result = $pdo->pdoQuery($catQuery,array('cname'=>$productRow))->result();  
                         
                         
//                                        if(mysql_num_rows($result))
                         if(!empty($result))
                         {
                            $pRow1 = (object) $result;
                            
                            if($pRow1->total > 0)
                            {
                                
                                $message .= FN_PDT_LEAF_CAT." " . $row . ".<br>";
                                $categoryError = true;
                                $categorySelected = 0;
                            }
                            
                        }

                        
                    }
                }
                if($categorySelected>0)
                {
                    
                    $product[$sampleArray[$key]]    = $categorySelected;

                }
                
                break;
                case 'product_price':
                if(($productRow <= 0))
                {
                    $message .= VAR_MSG_PPRICE_GTZ . $row . ".<br>";
                }
                break;
                case 'product_description':
                if($productRow == '')
                {
                    $message .= VAR_MSG_PDESC_EMP . $row . ".<br>";
                }
                break;
                case 'options':

                if($categoryError == false && $categorySelected > 0)
                {
                    
                    $optionNew = array();
                    
                    
                    if($productRow != '')
                    {
                        $optionsCSV = explode(';', $productRow);
                        
                        if(!empty($optionsCSV))
                        {
                            $newOption = array();
                            
                            foreach($optionsCSV as $optionCSV)
                            {
                                if($optionCSV != '')
                                {
                                    $optionsValues = explode('=', $optionCSV);
                                                //echopre($optionsValues);
                                    if(!empty($optionsValues))
                                    {
                                        $optionName  = isset($optionsValues[0]) ? trim($optionsValues[0]) : '';
                                        $optionValue = isset($optionsValues[1]) ? trim($optionsValues[1]) : '';

                                        if($optionName != '' && $optionValue != '')
                                        {
//                                                        $optQuery = "SELECT option_id
//                                                                       FROM ".$tableprefix."options
//                                                                      WHERE option_name = '" . mysql_real_escape_string($optionName) . "'";
//
//                                                        $optResult = mysql_query($optQuery) or die(mysql_error());
                                            $optQuery = "SELECT * 
                                            FROM ".$tableprefix."options
                                            WHERE option_name = :optionName ";
                                            $optRow = $pdo->pdoQuery($optQuery, array("optionName" => $optionName))->result();
//                                                        if(mysql_num_rows($optResult) > 0)
                                            
                                            if(!empty($optRow))
                                            { 
//                                                            $optRow = mysql_fetch_object($optResult);
                                                if($optRow['option_id']> 0)
                                                            { //echo "Here";
//                                                                $optAssQuery = "SELECT category_option_id
//                                                                       FROM ".$tableprefix."category_options
//                                                                      WHERE option_id = '" . mysql_real_escape_string($optRow['option_id']) . "'
//                                                                          AND category_id = '" . mysql_real_escape_string($categorySelected) . "'";
//
//                                                                $optAssResult = mysql_query($optAssQuery) or die(mysql_error());
                                                        $optAssQuery = "SELECT category_option_id 	 
                                                        FROM ".$tableprefix."category_options
                                                        WHERE option_id = :optionId
                                                        AND category_id = :categoryId ";
                                                        $optAssRow = $pdo->pdoQuery($optAssQuery, array(
                                                            "optionId" => $optRow['option_id'],
                                                            "categoryId" => $categorySelected
                                                            ))->result();
                                                      //  echopre($optAssRow);
//                                                                if(mysql_num_rows($optAssResult) > 0)
                                                        if(!empty($optAssRow))
                                                        {
                                                            
                                                            $optionNew[$optRow['option_id']] = $optionsValues[1];
//                                                                    $optAssRow = mysql_fetch_object($optAssResult);
                                                            if(!empty($optAssRow['category_option_id ']))
                                                            { 
                                                                        //$options[] = array($optRow['option_id ']=> $optionValue);
                                                                $options[$optRow['option_id']] = $optionValue;
                                                            }
                                                        }
                                                        else
                                                        {
                                                            $message .= "* Option '" . $optionName . "' is not assigned to the selected category for row " . $row . ".<br>";
                                                        }
                                                    }
                                                }
                                                else
                                                {
                                                    $message .= "* Option '" . $optionName . "' is not exist for row " . $row . ".<br>";
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                           // echopre1($optionNew);
                    if(!empty($options))
                    {
                        $product[$sampleArray[$key]]    = $options;
                    }
                    break;
                    case 'product_code':
                    if($productRow != '' && $categoryError == false && $categorySelected > 0)
                    {
//                                $qry = "SELECT product_code
//                                          FROM " . $tableprefix . "products
//                                         WHERE product_code='" . addslashes($productRow) . "'
//                                           AND product_artist_id='".$sellerid."'
//                                           AND product_category = '".addslashes($categorySelected)."' ";
//                                $res = mysql_query($qry) or die(mysql_error());
                        $qry = "SELECT product_code 
                        FROM " . $tableprefix . "products 
                        WHERE product_code= :productCode 
                        AND product_artist_id= :artistId
                        AND product_category = :productCategory ";
                        $res = $pdo->pdoQuery($qry, array(
                            "productCode" => $productRow,
                            'artistId' => $sellerid,
                            "productCategory" => $categorySelected))->result();
//                                if (mysql_num_rows($res) > 0)
                        if(!empty($res))
                        {
                            $message .= VAR_MSG_PCODE_EXIST . $row . ".<br>";
                        }
                    }

                    break;
                    case 'product_stock':
                    if(!($productRow > 0))
                    {
                        $message .= VAR_MSG_PSTOCK_GTZ . $row . ".<br>";
                    }
                    else
                    {
                        $stock = $productRow;
                    }
                    break;
                    case 'reorder_level':
                    if($stock > 0 && ($productRow > $stock))
                    {
                        $message .= VAR_MSG_RECLEV_STK . $row . ".<br>";
                    }
                    break;
                    case 'more_images':
                    if($productRow != '')
                    {
                        $moreImagesCSV = explode(';', $productRow);
                        if(!empty($moreImagesCSV))
                        {
                            $product[$sampleArray[$key]]    = $moreImagesCSV;
                        }
                    }
                    break;
                    case 'shipping_weight':
                    if(!($productRow > 0))
                    {
                        $message .= VAR_MSG_PSHIP_GTZ . $row . ".<br>";
                    }
                    break;
                    case 'product_length':
                    if(!($productRow > 0))
                    {
                        $message .= VAR_MSG_PLEN_GTZ . $row . ".<br>";
                    }
                    break;
                    case 'product_width':
                    if(!($productRow > 0))
                    {
                        $message .= VAR_MSG_PWID_GTZ . $row . ".<br>";
                    }
                    break;
                    case 'product_height':
                    if(!($productRow > 0))
                    {
                        $message .= VAR_MSG_PHEI_GTZ . $row . ".<br>";
                    }
                    break;
                        /*case 'allow_free_shipping':
                            if($productRow == '')
                            {
                                $message .= EXIST_FN_PDT_SHIPPING_STATUS." " . $row . ".<br>";
                            }
                        break;
                        case 'allow_subscription':
                            if($productRow == '')
                            {
                                $message .= EXIST_FN_PDT_SHIPPING_STATUS." " . $row . ".<br>";
                            }
                        break;
                        case 'subscription_mode':
                            if($productRow == '')
                            {
                                $message .= EXIST_FN_PDT_SUBSCRIPTION_MODE." " . $row . ".<br>";
                            }
                        break;
                        case 'product_tags':
                            if($productRow == '')
                            {
                                $message .= EXIST_FN_PDT_PRODUCT_TAG." " . $row . ".<br>";
                            }
                            break;  */
                        }
                    /*
                    * Validations end here
                    */
                }
                /*
                 * Checking for product option
                 */
                $isOption = false;
                if($productName != '')
                {
                    $productNameKey = strtolower($productName);
                    if(array_key_exists($productNameKey, $addedProducts))
                    {
                        if($addedProducts[$productNameKey] == $categorySelected && !empty($options))
                        {
                            foreach($inventory as $invKey => $invProduct)
                            {
                                if($invProduct['product_name'] == $productName)
                                {
                                    $inventory[$invKey]['option_product'][] = $product;
                                    $isOption = true;
                                }
                            }
                        }
                    }
                    else
                    {
                        $addedProducts[$productNameKey] = $categorySelected;
                    }
                }

                if(!$isOption)
                {
                    $inventory[] = $product;
                }
                $row++;

            }
        }

        $addedCount = 0;
        /*
         * Start to adding values after validation
         */
        if($message == '')
        {
            if(!empty($inventory))
            {
                /*
                * Rearrange csv data
                */
                rearrangeCSVData();
                $approveProducts = getSettingsValue('approve_products') == 1 ? 'Y' : 'N';
                $productListingFee = intval(getSettingsValue('product_listing_fee'));
                

                $payment_status = 'COMPLETED'; 

                if($productListingFee>0)
                {
                    $payment_status = 'PENDING';
                }


                $pids = "";
                $comma = "";
                foreach($inventory as $newProduct)
                {
                    //Generate Alias name for product
                    $aliasname = Utils::generateAlias($tableprefix . "products", $newProduct['product_name']);
                    //Adding product

                    // Pass default values for shiping and subscription if values are empty in csv sheet

                    if($newProduct['allow_free_shipping']=='')
                    {
                        $newProduct['allow_free_shipping']  =   'N';
                    }
                    if($newProduct['allow_subscription']=='')
                    {
                        $newProduct['allow_subscription']  =   'N';
                    }
                    if($newProduct['subscription_mode']=='')
                    {
                        $newProduct['subscription_mode']  =   'Monthly';
                    }

                        // Seller Vacation Mode Settings

                    if(getSettingsValue('enable_product_scheduled_publishing')=='N')
                    {
                        $publishStatus    = 'Y';
                    }


                    $sellerObj  =    Store::get_seller_account_info($sellerid);
                    $seller_vacation_mode     ='N';
                    if($sellerObj->status==SUCCESS)
                    {
                        $sellerObjVal                       =   $sellerObj->data;
                        $seller_vacation_mode		    =	$sellerObjVal->is_vacation_mode;

                    }

                    $catQuery    =   "SELECT category_id FROM ".$tableprefix."categories
                    WHERE category_name = :categoryName ";
                    $catID = $pdo->pdoQuery($catQuery, array("categoryName" => $newProduct['product_category'] ))->result();
                    $insertDataArr = array(
                        "product_name" => $newProduct['product_name'],
                        "product_price" => $newProduct['product_price'],
                        "product_code" => $newProduct['product_code'],
                        "product_description" => $newProduct['product_description'],
                        "product_category" => $newProduct['product_category'],
                        "product_artist_id" => $sellerid,
                        "allow_free_shipping" => $newProduct['allow_free_shipping'],
                        "allow_subscription" => $newProduct['allow_subscription'],
                        "subscription_mode" => $newProduct['subscription_mode'],
                        "product_tags" => $newProduct['product_tags'],
                        "publish_status" => $publishStatus,
                        "publish_scheduled_date" => $publishTime,
                        "publish_timezone" => $sellertimezone,
                        "date_added" => date("Y-m-d"),
                        "deleted" => "N",
                        "featured" => "N",
                        "vdigital_product" => "N",
                        "vapproved" => $approveProducts,
                        "seller_vacation_mode"  => $seller_vacation_mode,
                        "seller_viewed_status" => 1,
                        "alias"  => $aliasname,
                        "payment_status"=>$payment_status
                        );



                    $productID = $pdo->insert($tableprefix . "products", $insertDataArr)->lastInsertId();
                    if($productID)
                    {
//                        $productID = mysql_insert_id();

//                          $sqlOptionExistsCheck   = "SELECT product_option_id  FROM " . $tableprefix . "product_options where product_id = '".mysql_real_escape_string($productID) . "' AND default_option ='YES' ";
//                    $resultOptionSql        =    mysql_query($sqlOptionExistsCheck);
                        $sqlOptionExistsCheck   = "SELECT product_option_id  FROM " . $tableprefix . "product_options where product_id = :productId AND default_option ='YES' ";
                        $resultOptionSql = $pdo->pdoQuery($sqlOptionExistsCheck, array("productId" => $productID))->results();
//                    if(mysql_num_rows($resultOptionSql)>0)
                        if(!empty($resultOptionSql))
                        {
                        //$reultObj               =    mysql_fetch_object($resultOptionSql);
                        //$productExistOptionId   =    $reultObj->product_option_id;

                        // remove options if exists



//                        while($product_options_row = mysql_fetch_array($resultOptionSql)) {
                            foreach ($resultOptionSql as $product_options_row) {
                                $productOptionsArr[]  = $product_options_row['product_option_id'];
                            }

                            $productExistOptionId = implode("','",$productOptionsArr);
                        //echo $productExistOptionId;

//                        $sql_options = "DELETE FROM ".$tableprefix."product_options WHERE product_option_id IN ('".$productExistOptionId."') ";
//                        $del_options = mysql_query($sql_options);
                            $sql_options = "DELETE FROM ".$tableprefix."product_options WHERE product_option_id IN ( :productOptionId ) ";
                            $del_options = $pdo->pdoQuery($sql_options, array('productOptionId' => $productExistOptionId));
                        }
                        if($optionNew){
                         $newProduct['options'] = $optionNew;
                     }
                     if($productID > 0)
                     {
                        $pids .= $comma . $productID;
                        $comma = ",";
                            //Adding product Option
                        addProductOption($newProduct, $productID, 'YES',$pdo);

                    }
                    if(isset($newProduct['option_product']))
                    {
                        if(!empty($newProduct['option_product']))
                        {
                            foreach($newProduct['option_product'] as $newOption)
                            {
                                addProductOption($newOption, $productID,'',$pdo);
                            }
                        }
                    }
                    if(isset($newProduct['more_images']))
                    {
                        if(!empty($newProduct['more_images']))
                        {
                            foreach($newProduct['more_images'] as $moreImage)
                            {

//                                     $insMoreImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
//                                                                SET nimage_productid = '" . mysql_real_escape_string($productID) . "',
//                                                                vimage_name = '" . mysql_real_escape_string($moreImage) . "'";
//                                    mysql_query($insMoreImageQuery) or die(mysql_error());
                                $insMoreImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                                SET nimage_productid = :imageProductId,
                                vimage_name = :imageName ";
                                $pdo->pdoQuery($insMoreImageQuery, array("imageProductId" => $productID, "imageName" => $moreImage));
                            }
                        }
                    }

                          //*****************************************Multicart Scalabilty Changes**********************************
                    if(getSettingsValue('enable_scalability_settings')=='Y')
                    {
                        $objDefaultOptionVo                                     =    new stdClass();
                        $objOptionVo                                            =    Products::getProduct_Default_Option_Values($productID);

                        $objDefaultOptionVo->default_image_small                =   $objOptionVo->image_small;
                        $objDefaultOptionVo->default_additional_price           =   $objOptionVo->additional_price;
                        $objDefaultOptionVo->default_shipping_weight            =   $objOptionVo->product_shipping_weight;
                        $objDefaultOptionVo->default_discount                   =   $objOptionVo->discount;
                        $objDefaultOptionVo->default_discount_description       =   $objOptionVo->discount_description;
                        $objDefaultOptionVo->default_option_id                  =   $objOptionVo->product_option_id;
                        $objDefaultOptionVo->product_id                         =   $productID;

                                // Save default option values to product table
                        $productinfoUpdate                                      =   Products::updateProduct_Default_Option_Value($objDefaultOptionVo);

                    }


       //*****************************************Multicart Scalabilty Changes**********************************


                }
                $addedCount++;
            }
        }
    }
        /*
         * Redirect to product list after adding products
         */
        if($addedCount > 0)
        {
            if($productListingFee > 0)
            {
                header( "Location:product-listing-payment.php?&pid=" . $pids );
                exit;
            }
            header('location:myproducts.php?message='. $addedCount . " " . MSG_PROD_UPLD_SUC);
            exit;
        }
} // end button post check
include "../includes/htmltop1.php";
?>
<body>
    <div class="main_outer">
        <!--header area start -->
        <?php include_once("../includes/topheader_sellerNew.php"); ?>

        <div class="clearfix"></div>

        <div class="contant_area">

            <!--main body start -->
            <?php
            include_once("../includes/artisttopmenuNew.php")
            ?>
            <!-- ***************************************************************** -->
            <div class="right_main_cont_outer">
             <div class="right_main_cont_inner">

               <!--content area start -->
               <div align="left"><?php //include("../includes/bulkuploadmenu.php");?></div>
               <h1><?php echo TEXT_BULK_PROD_UPLOAD;?></h1>
               <div align="center" class="text_information grey_tr"><?php echo $message?></div>
               <br>
               <div align="left">
                   <div class="table-responsive">
                      <form action="" method="post" enctype="multipart/form-data" name="frmProductBulk" >
                          <?php if($recordsper==0 && $flag=="true")
						{ // display upload if error free
                          ?>
                          <table width="98%" border="0" cellpadding="8" cellspacing="4" class="table admin_table no_margin">
                              <tr>
                                <td colspan="3"><?php echo MSG_USE_FORM;?></td>
                            </tr>
                            <tr><td width="34%" height="37"><strong><?php echo MSG_LINK_IMPFIELD;?></strong></td>
                                <td width="2%">&nbsp;</td>
                                <td width="64%">&nbsp;</td>
                            </tr>
                            <?php

                            foreach($sampleArray as $bulkvalue)
                            {
                                $bulkvalue = trim($bulkvalue);
                                $caption = str_replace("_"," ",$bulkvalue);

                                $filedArray='labels'.$bulkvalue;
                                ?>
                                <tr>
                                    <td>
                                        <?php echo TEXT_MATCH;?> '<?php echo $caption;?> ' <?php echo TEXT_WITH;?></td>
                                        <td>&nbsp;<?php if($bulkvalue=="product_name" ||  $bulkvalue=="product_category" || $bulkvalue=="product_price"  ||  $bulkvalue=="product_description") { ?><span class="required">*</span><?php } ?></td>
                                        <td><select name="labels<?php echo $bulkvalue;?>">
                                            <option value=""><?php echo TEXT_IGNORE;?></option>
                                            <?php
                                            $nameArray=bulkuploadText();

                                            foreach($listArray as $bulkkeys)
                                            {
                                                $textName = str_replace("_"," ",$bulkkeys);
                                                ?>
                                                <option value="<?php echo $bulkkeys?>" <?php if(trim($bulkvalue)==trim($bulkkeys)) { echo "selected" ; } ?>><?php echo $textName;?> </option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                        <input type="hidden" name="csvfilename" value="<?php echo $csvfilename;?>">
                                        <input type="hidden" name="sellerid" value="<?php echo $sellerid;?>"></td>
                                    </tr>
                                    <?php } ?>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td><input type="submit" name="btnSave" value="<?php echo BTN_NEXT;?>" class="button"></td>
                                    </tr>
                                </table>
                                <?php } // end if ?>

                                <?php if($recordsper>0  && $flag=="false")
						{ // check products uploaded or not
                          ?>
                          <table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
                              <tr>
                                <td colspan="3" align="left" class="text_information"><?php echo $recordsper?> product(s)saved successfully.</td>
                            </tr>
                            <?php if(is_array($parray) && count($parray)>0){ ?>
                            <tr>
                                <td colspan="3" align="left" class="text_information"><?php echo MSG_PROD_FAIL;?></td>
                            </tr>
                            <?php
                            $dd=1;
                            foreach($parray as $pnames)
                            {
                                ?>
                                <tr>
                                    <td colspan="3" align="left"><?php echo $dd. ")  ". $pnames;?></td>
                                </tr>
                                <?php
                                $dd++;
						      } // end for each
						   } // end if error
                         ?>
                         <tr>
                            <td width="22%" height="50" align="left"><input type="button" name="btnBack" value="<?php echo BTN_BACK_UPLD;?>" class="button" onClick="window.location.href='bulkupload.php'"></td>
                            <td width="30%" height="50" align="left"><input type="button" name="btnNext" value="<?php echo BTN_CONTINUE;?>" class="button" onClick="window.location.href='bulkimageupload.php?sellerid=<?php echo $sellerid;?>'"></td>
                            <td width="48%" height="50" align="left">&nbsp;</td>
                        </tr>

                    </table>

                    <?php }  // end if ?>

                    <?php if($recordsper==0 && $flag=="false")
						{ // check products uploaded or not
                          ?>
                          <table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
                              <tr>
                                <td colspan="3" align="left" class="text_information"><?php echo $recordsper;?>  <?php echo MSG_PROD_SAVD;?></td>
                            </tr>
                            <?php if(is_array($parray) && count($parray)>0){ ?>
                            <tr>
                                <td colspan="3" align="left" class="text_information"><?php echo MSG_PROD_FAIL;?> </td>
                            </tr>
                            <?php
                            $num=1;
                            foreach($parray as $value)
                            {
                                ?>
                                <tr>
                                    <td colspan="3" align="left"><?php echo $num. ")  ". $value;?> </td>
                                </tr>
                                <?php
                                $num++;
						      } // end for each
							 } // end if array check
                           ?>

                           <tr>
                            <td width="43%" height="50" align="left"><input type="button" name="btnBack" value="Back To Bulkupload" class="button" onClick="window.location.href='bulkupload.php'"></td>
                            <td width="46%" height="50" align="left">&nbsp;</td>
                            <td width="11%" height="50" align="left">&nbsp;</td>
                        </tr>
                    </table>
                    <?php
                }  // end if ?>

                <?php if($recordsper>0 && $flag=="true")
						{ // check products uploaded or not
                          ?>
                          <table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
                              <tr>
                                <td colspan="3" align="left" class="text_information"><?php echo $recordsper;?>  <?php echo MSG_PROD_SAVD;?></td>
                            </tr>
                            <?php if(is_array($productsSavedArray) && count($productsSavedArray)>0){ ?>
                            <tr>
                                <td colspan="3" align="left" class="text_information"><?php echo MSG_FPROD_SAVD;?> </td>
                            </tr>
                            <?php
                            $nums=1;
                            foreach($productsSavedArray as $products)
                            {
                                ?>
                                <tr>
                                    <td colspan="3" align="left"><?php echo $nums. ")  ". $products;?> </td>
                                </tr>
                                <?php
                                $nums++;
						      } // end for each
							 } // end if array check
                           ?>
                           <tr>
                            <td width="19%" height="50" align="left"><input type="button" name="btnBack" value="<?php echo BTN_BACK_UPLD;?>" class="button" onClick="window.location.href='bulkupload.php'"></td>
                            <td width="33%" height="50" align="left"><input type="button" name="btnNext" value="<?php echo BTN_CONTINUE;?>" class="button" onClick="window.location.href='bulkimageupload.php?sellerid=<?php echo $sellerid;?>'"></td>
                            <td width="48%" height="50" align="left">&nbsp;</td>
                        </tr>
                    </table>

                    <?php }  // end if ?>

                </form>
                .

            </div>
        </div>

        <!--content area end-->

        <div align="left" class="clear_float"><img src="<?php echo $imagefolder;?>/clear.gif" alt="" width="1" height="1" /></div>
        <!--main body end -->
    </div>
</div>
</div>


<?php include "../includes/footer_sellers.php"; ?>