<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of cls_products
 *
 * @author Asha S
 */



class Utils {

    //put your code here

  
    public static function check_product_stock_exists($productID, $productOptionID) {
        global $tableprefix,$pdo;

        $product_stock = 0;

        $objResult = new stdClass();

        if (!empty($productOptionID)) {
            $productStockSql = "SELECT po.product_stock
                                                    FROM " . $tableprefix . "products p
                                                    INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id 
                                                    WHERE p.product_id = :product_id AND po.product_option_id =:product_option_id ";
            $resSet = $pdo->pdoQuery($productStockSql,array("product_id"=>$productID,"product_option_id"=>$productOptionID))->results();
            $product_stock = $resSet[0]['product_stock'];
        }

        return $product_stock;
    }

    // Function to get seller registration plans

    public static function getsellerPlans($flag = '') {
        global $tableprefix,$pdo;
        $objResult = new stdClass();
        $selectCase = "plan_Status = 'Y'  ";
        if ($flag != '') {
            $selectCase.= " AND plan_Period!='F'  ";
        }
       $sql = "SELECT * FROM ".$tableprefix."sellerPlans WHERE ".$selectCase;
        $objResultRow = $pdo->pdoQuery($sql)->results();       
        // If user exists then assign user data to result object
        if ($objResultRow) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Get plan period of the selected plan 
    public static function getPlanPeriod($planId) {
        global $tableprefix,$pdo;
        $objResult = new stdClass();
        $objResultRow = $pdo->select($tableprefix."sellerPlans",array("plan_Period"),array("plan_Id"=>$planId))->results();        
        // If user exists then assign user data to result object
        if ($objResultRow) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0]['plan_Period']; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    /*
     * function to generate the alias for the input text
     */

    public static function generateAlias($table_name, $alias_text, $id_column = "id", $id = "", $alias_column = "alias") {


        global $tableprefix,$pdo;
       
        //format alias 
        $alias = str_replace("&amp;", "and", $alias_text);
        $alias = htmlspecialchars_decode($alias, ENT_QUOTES);
        $alias = str_replace("-", " ", $alias);
        $alias = preg_replace("/[^a-zA-Z0-9\s]/", "", $alias);
        $alias = preg_replace('/[\r\n\s]+/xms', ' ', trim($alias));
        $alias = strtolower(str_replace(" ", "-", $alias));

        //check for duplicates
   if($alias!=''){     
       $sql = "select count(*) as total from $table_name where $alias_column = :aliass";
       
       $dataArr = array();

       $dataArr['aliass'] = $alias;

        //$dataArr = array("aliass"=>$alias);
        if ($id)
        {
            $sql .= " and $id_column <> :id";
            $dataArr['id'] = $id;
        }
       
        $duplicates = $pdo->pdoQuery($sql,$dataArr)->results();

        //if duplicates exist recursively create a new alias and try
        if ($duplicates[0]['total'] > 0) {
            $rand_str = self::rand_str(4);
            return self::generateAlias($table_name, $alias . "-" . $rand_str, $id_column, $id, $alias_column);
        }

    }

    else{

        $rand_str = self::rand_str(4);

        $alias= self::generateAlias($table_name,$rand_str, $id_column, $id, $alias_column);
     }
        return strtolower($alias);
    
    }

    /*
     * function to generate a random string value
     */

    public static function rand_str($length = 32, $chars = 'abcdefghijklmnopqrstuvwxyz1234567890') {
        $chars_length = (strlen($chars) - 1);
        $string = $chars{rand(0, $chars_length)};
        for ($i = 1; $i < $length; $i = strlen($string)) {
            $r = $chars{rand(0, $chars_length)};
            if ($r != $string{$i - 1})
                $string .= $r;
        }
        return $string;
    }

    //Function to display special character escaped string
    public static function html_entity($txtString) {
        if ($txtString)
            return htmlentities(stripslashes($txtString));
    }

    //Function to save All currency code and data to table 

    public static function saveAllCurrencyCodes($obCurrencyVo) {
        global $tableprefix,$pdo;
        $objResult = new stdClass();
        $insertArr = array('vcurrency_name' => $obCurrencyVo->vcurrency_name,
                    'vcurrency_code' => $obCurrencyVo->vcurrency_code,
                    'vcurrency_symbol' => $obCurrencyVo->vcurrency_symbol,
                    'nexchange_price' => $obCurrencyVo->nexchange_price,
                    'vactive' => $obCurrencyVo->vactive           );
        $currencyId =  $pdo->insert($tableprefix."currency_master",$insertArr)->lastInsertId();
        if ($currencyId) {
            $objResult->status = SUCCESS;
            $objResult->data = $currencyId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //Check currency table wheter data exists

    public static function getCurrencyCodeCount() {
        global $tableprefix,$pdo;
        $objResult = new stdClass();       
        $objResultRow = $pdo->select($tableprefix."currency_master",array("COUNT(ncurrency_id) as currency_count"))->results(); 
        //Check Cart Details exist for the selected  Cart ID
        if ($objResultRow) {
        // Assign Cart details to object
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0];
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    //Select Active curreny to get avail for users

    public static function getActiveCurrencyList() {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        $objResultRow = $pdo->select($tableprefix . 'currency_master', '', array('vactive' => 'Y'), ' ORDER BY vcurrency_name ASC')->results();
        if (!empty($objResultRow[0])) {
        // Assign Cart details to object
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow;
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    //Update currency rate to table 

    public static function updateCurrencyRates($obCurrencyVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();

        $aWhere = array("vcurrency_code" => $obCurrencyVo->vcurrency_code);
        
        $currencyId = $pdo->update($tableprefix.'currency_master', array('nexchange_price' =>$obCurrencyVo->nexchange_price), $aWhere)->affectedRows();
        if ($currencyId) {
            $objResult->status = SUCCESS;
            $objResult->data = $currencyId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //Update US DOllar  rate for each currency  to table

    public static function updateUsdollarRates($obCurrencyVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        
        $aWhere = array("vcurrency_code" => $obCurrencyVo->vcurrency_code);
        
        $currencyId = $pdo->update($tableprefix.'currency_master', array('usdollar_rate' =>$obCurrencyVo->usdollar_rate), $aWhere)->affectedRows();
        if ($currencyId) {
            $objResult->status = SUCCESS;
            $objResult->data = $currencyId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //Get Plan detatils by plan Id
    // Function to get seller registration plans

    public static function getsellerPlansByPlanId($planId) {
        $objResult = new stdClass();
        global $tableprefix,$pdo;
        $objResultRow = $pdo->select($tableprefix."sellerPlans",'',array("plan_Id"=>$planId,"plan_Status"=>'Y'))->results(); 
        if ($objResultRow) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0];
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Function to clear cart and favorite tables while seller is deavtivated
    public static function makeDeactivateChanges($sellerId) {
        global $tableprefix, $pdo;
        //clear the seller product from carts table        
        $where = "seller_id = " . $sellerId;
        $tableName = $tableprefix.'cart';
        $objResultRow = $pdo->delete($tableName,array("seller_id"=>$sellerId))->affectedRows();
        // 
    }

    //  //Enable / Disable admin menu 

    public static function updateAdminSettings($obSettingsVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $tableName = $tableprefix.'admin_menu';
        //$where = "$obSettingsVo->field_name = '" . generalMethods::escapeString($obSettingsVo->page_name) . "'  ";
        $menuId = $pdo->update($tableName, array('status' =>$obSettingsVo->status), array($obSettingsVo->field_name=>$obSettingsVo->page_name))->affectedRows();
        //DbHelper::update($tableName, array('status' => generalMethods::escapeString($obSettingsVo->status),), $where);
        if ($menuId) {
            $objResult->status = SUCCESS;
            $objResult->data = $menuId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    public static function getProductInfo() {
        $objResult = new stdClass();
        global $tableprefix,$pdo;
        $objResultRow = $pdo->select($tableprefix."products",'','')->results();       
        return $objResultRow;
    }

    public static function UpdateProductInfo() {
        global $tableprefix,$pdo;

        //Update Product Information           
        $sqlUpdate1 = "UPDATE " . $tableprefix . "products SET default_additional_price = (SELECT additional_price from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet1 = $pdo->pdoQuery($sqlUpdate1)->results();

        $sqlUpdate2 = "UPDATE " . $tableprefix . "products t1 SET t1.default_image_small = (SELECT (SELECT CASE WHEN t2.image_big ='' THEN t2.image_small ELSE t2.image_big END AS ret) AS default_image_small from " . $tableprefix . "product_options t2 WHERE t1.product_id=t2.product_id and t2.default_option='YES' ) ";
        $resSet2 = $pdo->pdoQuery($sqlUpdate2)->results();

        $sqlUpdate3 = "UPDATE " . $tableprefix . "products SET default_discount = (SELECT discount from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet3 = $pdo->pdoQuery($sqlUpdate3)->results();

        $sqlUpdate4 = "UPDATE " . $tableprefix . "products SET default_discount_description= (SELECT discount_description from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet4 = $pdo->pdoQuery($sqlUpdate4)->results();

        $sqlUpdate5 = "UPDATE " . $tableprefix . "products SET default_stock = (SELECT sum(product_stock) as stock from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id =" . $tableprefix . "product_options.product_id )";
        $resSet5 = $pdo->pdoQuery($sqlUpdate5)->results();

        $sqlUpdate6 = "UPDATE " . $tableprefix . "products SET seller_name = (SELECT artist_name  from " . $tableprefix . "artists  WHERE " . $tableprefix . "products.product_artist_id = " . $tableprefix . "artists.artist_id )";
        $resSet6 = $pdo->pdoQuery($sqlUpdate6)->results();

        $sqlUpdate7 = "UPDATE " . $tableprefix . "products SET default_option_id = (SELECT product_option_id from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet7 = $pdo->pdoQuery($sqlUpdate7)->results();

        $sqlUpdate8 = "UPDATE " . $tableprefix . "product_options AS t1 INNER JOIN " . $tableprefix . "product_options AS t2  ON t1.product_option_id=t2.product_option_id SET t1.image_big = t2.image_small WHERE t1.image_big = '' AND t2.image_small!='' ";
        $resSet8 =$pdo->pdoQuery($sqlUpdate8)->results();
    }

    public static function UpdateDefaultValues() {
        global $tableprefix,$pdo;
        //Update Product Information           
        $sqlUpdate1 = "UPDATE " . $tableprefix . "products SET publish_status ='Y' , seller_vacation_mode='N' ,vSellerStatus='Y' ";
        $resSet1 = $pdo->pdoQuery($sqlUpdate1)->results();
    }

    public static function getsellerName($sellerId = '') {
        $objResult = new stdClass();
        global $tableprefix,$pdo;
       
        $objResultRow =  $pdo->select($tableprefix."artists",array("artist_name"),array("artist_id"=>$sellerId))->results(); 
        if ($objResultRow) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0]['artist_name']; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }

        return $objResult->data[0]->artist_name;
    }

    public static function getShippingInfo() {
        global $tableprefix,$pdo;
        $objResult = new stdClass();
        $objResultRow = $pdo->select($tableprefix."shipping_details",'','')->results();
        return $objResultRow;
    }

    public static function UpdateShippingValues() {
         global $tableprefix,$pdo;

        // Create Back Up Tabel of Shipping 

        $createSql = "CREATE TABLE IF NOT EXISTS " . $tableprefix . "shipping_details_backup SELECT * FROM " . $tableprefix . "shipping_details ";
        $resSet1 = $pdo->pdoQuery($createSql)->results();

        $sql_ShippingData = "SELECT DISTINCT od.product_option_id,od.order_id,od.artist_id,sum(sd.nshipping_cost)as shipcost, sum(sd.nshipping_weight) as shipWeight,sd.dshipped_date,sd.nshp_status,sd.user_id,sd.vshipping_name,sd.nshipping_type from " . $tableprefix . "order_details od 

                        INNER JOIN " . $tableprefix . "shipping_details_backup sd ON (sd.norder_id =od.order_id AND sd.nproduct_option_id = od.product_option_id) group BY od.artist_id,od.order_id";

        $objResultRow =$pdo->pdoQuery($sql_ShippingData)->results();        
        $QueryDelete = "TRUNCATE TABLE  " . $tableprefix . "shipping_details";
        $rs_Delete = $pdo->pdoQuery($QueryDelete)->results();        
        $objShippingVo = new stdClass();
        foreach ($objResultRow as $data) {

            $objShippingVo->norder_id = $data['order_id'];
            $objShippingVo->vshipping_name = $data['vshipping_name'];
            $objShippingVo->nshipping_cost = generalMethods::numberFormat($data['shipcost']);
            $objShippingVo->nshipping_weight = $data['shipWeight'];
            $objShippingVo->dshipped_date = $data['dshipped_date'];
            $objShippingVo->nshp_status = $data['nshp_status'];
            $objShippingVo->user_id = $data['user_id'];
            $objShippingVo->seller_id = $data['artist_id'];

            $shippingId =  array('norder_id' => $objShippingVo->norder_id,
                        'vshipping_name' => $objShippingVo->vshipping_name,
                        'nshipping_cost' => $objShippingVo->nshipping_cost,
                        'nshipping_weight' => $objShippingVo->nshipping_weight,
                        'dshipped_date' => $objShippingVo->dshipped_date,
                        'nshp_status' => $objShippingVo->nshp_status,
                        'user_id' =>$objShippingVo->user_id,
                        'seller_id' => $objShippingVo->seller_id
                    );
            $pdo->insert($tableprefix."shipping_details",$shippingId)->lastInsertId();
        }


        //Delete Back Up Table After Insertion 

        $QueryDelete1 = "DROP TABLE if exists " . $tableprefix . "shipping_details_backup";

        // $rs_Delete1         =   DbHelper::execute($QueryDelete1);
    }

    public static function GetCountryList() {
        $currency_list_string = '{
    "results": {
        "AU": {
            "alpha3": "AUS",
            "currencyId": "AUD",
            "currencyName": "Australian dollar",
            "currencySymbol": "&#36;",
            "id": "AU",
            "name": "Australia"
        },
        "BR": {
            "alpha3": "BRA",
            "currencyId": "BRL",
            "currencyName": "Brazilian real",
            "currencySymbol": "R$",
            "id": "BR",
            "name": "Brazil"
        },
        "MY": {
            "alpha3": "MYS",
            "currencyId": "MYR",
            "currencyName": "Malaysian ringgit",
            "currencySymbol": "RM",
            "id": "MY",
            "name": "Malaysia"
        },
        "IN": {
            "alpha3": "IND",
            "currencyId": "INR",
            "currencyName": "Indian rupee",
            "currencySymbol": "&#x20B9;",
            "id": "IN",
            "name": "India"
        },
              
        "CA": {
            "alpha3": "CAN",
            "currencyId": "CAD",
            "currencyName": "Canadian dollar",
            "currencySymbol": "&#36;",
            "id": "CA",
            "name": "Canada"
        },
     
        "GB": {
            "alpha3": "GBR",
            "currencyId": "GBP",
            "currencyName": "British pound",
            "currencySymbol": "&pound;",
            "id": "GB",
            "name": "United Kingdom"
        },
       
        "JP": {
            "alpha3": "JPN",
            "currencyId": "JPY",
            "currencyName": "Japanese yen",
            "currencySymbol": "&yen;",
            "id": "JP",
            "name": "Japan"
        },
      
        "DE": {
            "alpha3": "DEU",
            "currencyId": "EUR",
            "currencyName": "European euro",
            "currencySymbol": "&euro;",
            "id": "DE",
            "name": "Germany"
        },
       
        "US": {
            "alpha3": "USA",
            "currencyId": "USD",
            "currencyName": "United States Dollar",
            "currencySymbol": "&#36;",
            "id": "US",
            "name": "United States of America"
        },
       
        "RU": {
            "alpha3": "RUS",
            "currencyId": "RUB",
            "currencyName": "Russian ruble",
            "currencySymbol": "Ã‘â‚¬Ã‘Æ’Ã�Â±",
            "id": "RU",
            "name": "Russia"
        }
    }
}';

        $currency_list_array = json_decode($currency_list_string);
        return $currency_list_array;
    }

    public static function getCartInfo() {
        global $tableprefix,$pdo;
        $objResult = new stdClass();       
        $objResultRow = $pdo->select($tableprefix."cart",'','')->results(); 
        return $objResultRow;
    }

    public static function DeleteCart() {
        global $tableprefix,$pdo;
        $QueryDelete = "TRUNCATE TABLE  " . $tableprefix . "cart";
        $rs_Delete = $pdo->pdoQuery($QueryDelete);
    }

    public static function UpdateProductAlias($productObj) {
        global $tableprefix,$pdo;

        if (!empty($productObj)) {
            foreach ($productObj as $pdata) {
                $product_name = generalMethods::formatText($pdata['product_name']);
                $product_id = $pdata['product_id'];
                $aliasname = self::generateAlias($tableprefix . "products", $product_name);
                $ProductUpdateId = $pdo->update($tableprefix.'products', array('alias' => $aliasname), array("product_id"=>$product_id))->affectedRows();
                
            }
        }
    }

    public static function UpdateCategoryAlias() {
        global $tableprefix,$pdo;
        $selectCase = '';
        $objResultRow = $pdo->select($tableprefix."categories",'','')->results(); 
        if (!empty($objResultRow)) {
            foreach ($objResultRow as $pdata) {
                $category_name = generalMethods::formatText($pdata['category_name']);
                $category_id = $pdata['category_id'];
                $aliasname = self::generateAlias($tableprefix . "categories", $category_name);
                $where = array("category_id"=>$category_id);
                $categoryUpdateId = $pdo->update($tableprefix.'categories', array('alias' =>$aliasname), $where)->affectedRows();
            }
        }
    }

    public static function getProductMoreImageInfo() {
        $objResultRow = new stdClass();
        global $tableprefix,$pdo;   
        $objResultRow = $pdo->select($tableprefix."product_view_images",array("nimage_productid","vimage_name"),'')->results(); 
        return $objResultRow;
    }

    public static function getProductImageInfo() {
        $objResult = new stdClass();
         global $tableprefix,$pdo; 
        $objResultRow = $pdo->select($tableprefix."product_options",array("product_option_id","product_id","image_small","image_big"),'')->results(); 
        return $objResultRow;
    }

    public static function UpdateProductInfoforUpgarde() {
        global $tableprefix,$pdo;

        //Update Product Information           
        $sqlUpdate1 = "UPDATE " . $tableprefix . "products SET default_additional_price = (SELECT additional_price from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet1 = $pdo->pdoQuery($sqlUpdate1)->results();

        $sqlUpdate2 = "UPDATE " . $tableprefix . "products t1 SET t1.default_image_small = (SELECT (SELECT CASE WHEN t2.image_small ='' THEN t2.image_big ELSE t2.image_small END AS ret) AS default_image_small from " . $tableprefix . "product_options t2 WHERE t1.product_id=t2.product_id and t2.default_option='YES' ) ";
        $resSet2 = $pdo->pdoQuery($sqlUpdate2)->results();

        $sqlUpdate3 = "UPDATE " . $tableprefix . "products SET default_discount = (SELECT discount from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet3 = $pdo->pdoQuery($sqlUpdate3)->results();

        $sqlUpdate4 = "UPDATE " . $tableprefix . "products SET default_discount_description= (SELECT discount_description from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet4 = $pdo->pdoQuery($sqlUpdate4)->results();

        $sqlUpdate5 = "UPDATE " . $tableprefix . "products SET default_stock = (SELECT sum(product_stock) as stock from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id =" . $tableprefix . "product_options.product_id )";
        $resSet5 = $pdo->pdoQuery($sqlUpdate5)->results();

        $sqlUpdate6 = "UPDATE " . $tableprefix . "products SET seller_name = (SELECT artist_name  from " . $tableprefix . "artists  WHERE " . $tableprefix . "products.product_artist_id = " . $tableprefix . "artists.artist_id )";
        $resSet6 = $pdo->pdoQuery($sqlUpdate6)->results();

        $sqlUpdate7 = "UPDATE " . $tableprefix . "products SET default_option_id = (SELECT product_option_id from " . $tableprefix . "product_options  WHERE " . $tableprefix . "products.product_id = " . $tableprefix . "product_options.product_id and " . $tableprefix . "product_options.default_option='YES')";
        $resSet7 = $pdo->pdoQuery($sqlUpdate7)->results();

        $sqlUpdate8 = "UPDATE " . $tableprefix . "product_options AS t1 INNER JOIN " . $tableprefix . "product_options AS t2  ON t1.product_option_id=t2.product_option_id SET t1.image_big = t2.image_small WHERE t1.image_big = '' AND t2.image_small!='' ";
        $resSet8 = $pdo->pdoQuery($sqlUpdate8)->results();
    }

    public static function getActiveCurrencyListCount() {
        global $pdo, $tableprefix;

        $sql = "SELECT ncurrency_id FROM ".$tableprefix."currency_master where vactive = :status ORDER BY vcurrency_name ASC";
        $objResultRow = $pdo->pdoQuery($sql, array("status" => "Y"))->results();

        return count($objResultRow);
        //echopre($objResultRow);exit;
        /* if($objResultRow)
          // Assign Cart details to object
          {
          $objResult->status        =    SUCCESS;
          $objResult->data          =    $objResultRow;
          }
          else {
          $objResult->status        =   ERROR;

          }
          return $objResult; */
    }

    public static function getActiveCurrencyListWithLimit($start, $end) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        
        $orderBy = ' ORDER BY vcurrency_name ASC LIMIT ' . $start . ',' . $end . '';
        $sql = "SELECT * FROM ".$tableprefix."currency_master WHERE vactive = :status ".$orderBy;

        $objResultRow = $pdo->pdoQuery($sql, array("status" => "Y"))->results();
        //Check Cart Details exist for the selected  Cart ID
        if (count($objResultRow) > 0) {
        // Assign Cart details to object
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow;
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

}

?>