<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include_once('../includes/S3.php');

$adminCurrency = GetAdminCurrency();
if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
    $adminname = $_SESSION["sess_adminname"];
} else {
    header("Location:login.php");
    exit;
}

/** Manu R S - 24/01/18 */
/** -------Search keywords persistence------- */
$txtSeller = $_REQUEST['txtSeller'];
$txtSearch = trim($_REQUEST['txtSearch']);
$cmbSearchType = $_REQUEST['cmbSearchType'];

if (isset($_POST['gotoPage'])) {
    $txtSearch     = $_POST['searchbox'];
    $cmbSearchType = $_POST['searchboxtype'];
    $txtSeller     = $_POST['seller'];
    header("Location:".$_SERVER['PHP_SELF']."?page=".$_POST['gotoPage']."&txtSearch=".$txtSearch."&cmbSearchType=".$cmbSearchType."&txtSeller=".$txtSeller);
}


if (isset($_POST['txtProductId'])) {
    $ids = $_POST['txtProductId'];
    if (empty($ids)) {
        $message .= SEL_PROD_TO_DELETE."<br>";
    }

    if ($message == '') {


        $productid_format = substr($_POST['txtProductId'], 0, strlen($_POST['txtProductId']) - 1);

        $params = array('product_format'=>$formattedString);


        $select_product_images = "SELECT p.product_id,p.image_small,p.image_big
        FROM " . $tableprefix . "product_options p WHERE p.product_id IN(" . $productid_format . ")";

        $result_product_images= $pdo->pdoQuery($select_product_images,'')->results();


        if (!empty($result_product_images)) {
            foreach($result_product_images as $product_images_row) {

                $imagesmall_thumb = $product_images_row['image_small'];

                $imagelarge_thumb = $product_images_row['image_big'];

                @unlink("../products/" . $imagesmall_thumb);
                @unlink("../products/" . $imagelarge_thumb);
                deleteCDNImagesall($imagesmall_thumb,$imagelarge_thumb);


                /* -------Category count update patch------------ */
            }
        }
        $sql_options = "DELETE FROM " . $tableprefix . "product_options WHERE product_id IN ($productid_format) ";

        $del_options= $pdo->pdoQuery($sql_options,'');

        $select_product_images_more = "SELECT im.vimage_name
        FROM " . $tableprefix . "product_view_images im  WHERE im.nimage_productid IN(" . $productid_format . ")";

        $rs_product_image_more= $pdo->pdoQuery($select_product_images_more,'')->results();


        if (!empty($rs_product_image_more)) {

            foreach($rs_product_image_more as  $prows)
            {
                $moreimage = $prows['vimage_name'];
                $moreimage_thumb = "thumb_" . $prows['vimage_name'];

                @unlink("../products/" . $moreimage);
                @unlink("../products/" . $moreimage_thumb);
                deleteCDNImagesMore($moreimage);

            }
        }
        $sql_product_images_more = "DELETE FROM " . $tableprefix . "product_view_images WHERE nimage_productid IN ($productid_format) ";

        $del_images_more= $pdo->pdoQuery($sql_product_images_more,'');


        $delete_products = "DELETE FROM " . $tableprefix . "products WHERE product_id IN(" . $productid_format . ")";

        $pdo->pdoQuery($delete_products,'');


        $delete_cart_products = "DELETE FROM " . $tableprefix . "cart WHERE product_id IN(" . $productid_format . ")";

        $pdo->pdoQuery($delete_cart_products,'');


        $message = PRO_DELETED;

        header("Location:listProducts.php?page=1&msg=deleted");
} // end message empty check
}

$result_seller = $pdo->select($tableprefix.'artists',array('artist_id,artist_name,storename'),array('deleted'=>0))->results();
$qryopt = "";

$qryopt=" Where 1=1";

$whereArray =  array();

if ($txtSearch != "") {
    if ($cmbSearchType == "product") {

        $qryopt .= "  AND  prd.product_name like :product_name";
        $whereArray['product_name'] = $txtSearch."%";
    } else if ($cmbSearchType == "dateadded") {
        $dt = $txtSearch;
        $arrdt = explode("/", $dt);
        $day = $arrdt[1];
        $month = $arrdt[0];
        $year = $arrdt[2];
        $dt = $year . "-" . $month . "-" . $day;
        $qryopt .= "  AND  prd.date_added like :date_added";
        $whereArray['date_added'] = $dt."%";

    } else if ($cmbSearchType == "category") {
        $qryopt .= "  AND  cat.category_name like :category_name";
        $whereArray['category_name'] = $txtSearch."%";

    } else if ($cmbSearchType == "price") {

        $qryopt .= "  AND  (prd.product_price + prd.default_additional_price) =:productprice ";
        $whereArray['productprice'] = $txtSearch;

    }
}

if (isset($_REQUEST['txtSeller'])) {
    if ($_REQUEST['txtSeller'] != "") {
        $txtSeller =  $_REQUEST['txtSeller'];
        $qryopt .= "  AND  prd.product_artist_id =:productseller ";
        $whereArray['productseller'] = $txtSeller;
    }
}

// Filter Gift Certificates in product listing <M>
//$qryopt .= " AND prd.product_id NOT IN(SELECT GROUP_CONCAT(DISTINCT ngift_product_id ORDER BY ngift_product_id DESC SEPARATOR ', ') FROM " . $tableprefix . "giftcoupon_master)";

/*
$sql = "SELECT prd.product_id,prd.product_name,
(prd.product_price+po.additional_price) as product_price,
prd.date_added,cat.category_name,payment_status,
    (SELECT COUNT(pi.product_impression_id)
          FROM " . $tableprefix . "product_impression pi
         WHERE pi.product_id = prd.product_id) AS impression_count
            FROM " . $tableprefix . "products prd
            INNER JOIN " . $tableprefix . "product_options po ON po.product_id = prd.product_id AND po.default_option = 'YES'
            INNER JOIN " . $tableprefix . "categories cat ON prd.product_category = cat.category_id
	WHERE  1=1 " . $qryopt . ' ORDER BY product_id DESC';
*/
    $sql = "SELECT prd.product_id,prd.product_name,prd.publish_status,
    (prd.product_price+prd.default_additional_price) as product_price,
    prd.date_added,cat.category_name,payment_status,
    (SELECT COUNT(pi.product_impression_id)
    FROM " . $tableprefix . "product_impression pi
    WHERE pi.product_id = prd.product_id) AS impression_count
    FROM " . $tableprefix . "products prd
    INNER JOIN " . $tableprefix . "categories cat ON prd.product_category = cat.category_id
    " . $qryopt . " AND cat.gift_certificate_flag !='Y' ORDER BY product_id DESC";

    $resultAll= $pdo->pdoQuery($sql,$whereArray)->results();

//$whereArray['affiliate_id'] = $affiliateid;


    if (!(isset($pagenum))) {
        $pagenum = 1;
    }

    $limit = getSettingsValue('npagination_limit');

    $page = isset($_GET['page']) ? trim($_GET['page']) : 1;


    if (empty($page)) {
        $page = 1;
    }


    $sql_qr=dopagingbypdo($sql,'',$limit,$whereArray,$pdo) ;

    $result=$pdo->pdoQuery($sql_qr,$whereArray)->results();

    $totalrows = count($resultAll);

    $limitvalue = ($page - 1) * $limit;

    $numofpages = ceil($totalrows / $limit);
    if ($_GET["message"] && !$message)
        $message = $_GET["message"];

    if($_REQUEST['msg']==deleted)
    {
        $message = PRO_DELETED;
    }



    include "../includes/htmltop1.php";
    ?>
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/style/jquery-ui.css">
    <script src="<?php echo SITE_URL; ?>/js/jquery-ui.js"></script>

    <script>
      $(document).ready(function () {
        $("#datepicker").datepicker({
            dateFormat: 'mm/dd/yy',
            maxDate: '0'

        });

        $("#cmbSearchType").on("change",function(){
            if(this.value=='dateadded'){
               $("#textSelector").hide();
               $("#dateSelector").show();
               $("#txtSearch").attr("disabled","disabled");
               $("#datepicker").removeAttr("disabled");

           }else{
               $("#textSelector").show();
               $("#dateSelector").hide();
               $("#datepicker").attr("disabled","disabled");
               $("#txtSearch").removeAttr("disabled");

           }


       });
    });
      function clickSearch()
      {
        document.frmMyProducts.submit();
    }

    function addValues(order_value)
    {

        var checkbox_values = "";

        for(i=1;i<=document.frmMyProducts1.checkCount.value;i++)
        {

            var checkbox_name = "Product_"+i;

            if(document.getElementById(checkbox_name).checked)
            {
                checkbox_values += document.getElementById(checkbox_name).value + ',';
            }

            document.frmMyProducts2.txtProductId.value = checkbox_values;

        }
    }

    function checkAllOrders()
    {

        var checkbox_values = "";

        if(document.frmMyProducts1.checkAllBox.checked)
        {

            for(i=1;i<=document.frmMyProducts1.checkCount.value;i++)
            {

                var checkbox_name = "Product_"+i;
                document.getElementById(checkbox_name).checked = true;
                checkbox_values += document.getElementById(checkbox_name).value + ',';

            }

            document.frmMyProducts2.txtProductId.value = checkbox_values;

        }
        else
        {
            for(i=1;i<=document.frmMyProducts1.checkCount.value;i++)
            {

                var checkbox_name = "Product_"+i;
                document.getElementById(checkbox_name).checked = false;

            }

            document.frmMyProducts2.txtProductId.value = "";
        }

    }

    function duplicateProduct(){
        return confirm("<?php echo CONFIRM_DEL_DUPLICATE;?>");
    }

    function deleteProducts()
    {
        if(document.frmMyProducts2.txtProductId.value == "")
        {
            return confirm("<?php echo SEL_DEL;?>");
        }
        else
        {

            var status =  confirm('<?php echo DELETE_PRODUCTS;?>');

            if(status == true)
            {
                document.frmMyProducts2.submit();
            }
        }

    }

    function setValForSearchType(val)
    {
        document.frmMyProducts1.searchboxtype.value = val;
    }

    function setValForSellers(val)
    {
        document.frmMyProducts1.seller.value = val;
        document.frmMyProducts.submit();
    }
</script>
<body>


    <?php
    include_once("../includes/topheader_admin1.php")
    ?>
    <!--header area end -->
    <div class="contant_area">
        <!--main body start -->
        <?php
        include_once("../includes/admintopmenu1.php")
        ?>
        <div class="right_main_cont_outer">
          <div class="right_main_cont_inner">
             <h1>
                <?php echo PRODUCTS;?>
                <a href="catalog.php"  class="add_new_button"><?php echo BTN_ADD_NEW_PRODUCT; ?></a>
            </h1>

            <div class="clearfix"></div>

            <div class="full_width">
                <!--content area start -->
                <div class="text_information_success"><?php echo $message ?></div>

                <div align="left">
                    <form action="<?php echo $_SERVER["PHP_SELF"] ?>" method="post" name="frmMyProducts">

                        <div class="white_cont_outer margin_B_30">
                           <div class="row">
                              <div class="col-xs-12 col-sm-6 col-md-8 col-lg-8 list_search_outer_L">
                                 <h3><?php echo SEARCH;?></h3>
                                 <div class="row">
                                    <div class="col-xs-12 col-sm-4 col-md-4">
                                       <?php
                                       $dateblock = "none";
                                       if($cmbSearchType!= "dateadded"){
                                          $txtBlock = "display";
                                          $dateblock = "none";
                                          $txtSearch1 = $txtSearch;
                                          $disabled1   = "";
                                          $disabled2   = "disabled=disabled";
                                      } else{
                                          $txtBlock = "none";
                                          $dateblock = "display";
                                          $txtSearch2 = $txtSearch;
                                          $disabled1   = "disabled=disabled";
                                          $disabled2   = "";
                                      }

                                      ?>
                                      <select name="cmbSearchType" id="cmbSearchType" class="form-control" onChange="javascript:setValForSearchType(this.value);">
                                        <option value="product"  <?php
                                        if ($cmbSearchType == "product" || $cmbSearchType == "") {
                                            echo("selected");
                                        }
                                        ?>><?php echo PRODUCT_NAME;?></option>
                                        <option value="category"  <?php
                                        if ($cmbSearchType == "category") {
                                            echo("selected");
                                        }
                                        ?>><?php echo CATEGORY;?></option>
                                        <option value="price"  <?php
                                        if ($cmbSearchType == "price") {
                                            echo("selected");
                                        }
                                        ?>><?php echo PRICE;?></option>
                                        <option value="dateadded"  <?php
                                        if ($cmbSearchType == "dateadded") {
                                            echo("selected");
                                        }
                                        ?>><?php echo ADDED_DATE;?><!--(<?php // echo MM."/".DD."/".YYYY;?>)--></option>
                                    </select>
                                </div>
                                <div class="col-xs-12 col-sm-5 col-md-5 list_search_outer_L_inner">
                                   <span id="textSelector" style="display:<?php echo $txtBlock; ?>"  >
                                      <input type="text" <?php echo $disabled1; ?> name="txtSearch" id="txtSearch" size="20" maxlength="50" value="<?php echo(htmlentities($txtSearch1)); ?>"  onKeyPress="if(window.event.keyCode == '13'){ return false; }"  class="form-control">
                                  </span>
                                  <span id="dateSelector" style="display:<?php echo $dateblock; ?>" >
                                      <input type="text" <?php echo $disabled2; ?> name="txtSearch" id="datepicker" size="20" maxlength="50" value="<?php echo(htmlentities($txtSearch2)); ?>"   class="form-control">
                                  </span>
                              </div>
                              <div class="col-xs-12 col-sm-3 col-sm-3">
                               <a href="javascript:clickSearch();" class="search_button pull-left"><i class="fa fa-search" aria-hidden="true"></i><?php echo BTN_SEARCH; ?></a>
                           </div>
                       </div>
                   </div>
                   <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
                     <h3><?php echo SELLERS;?></h3>
                     <div class="row">
                        <div class="col-xs-12 col-sm-12 col-sm-12">
                          <select name="txtSeller" class="form-control" onChange="Javascript:setValForSellers(this.value);">
                              <option value="">--<?php echo ALL_SELLERS;?>--</option>
                              <?php
                              if (!empty($result_seller)) {
                                 foreach($result_seller as $seller_row )
                                 {

                                    if ($seller_row['artist_id'] == $_REQUEST['txtSeller']) {
                                       $select_seller = "selected";
                                   } else {
                                       $select_seller = "";
                                   }
                                   ?>
                                   <option value="<?php echo $seller_row['artist_id'] ?>" <?php echo $select_seller ?>><?php echo $seller_row['artist_name'] ?>&nbsp; (<?php echo $seller_row['storename'] ?> ) </option>
                                   <?php
                               }
                           }
                           ?>
                       </select>
                   </div>
               </div>
           </div>
       </div>
   </div>


</form>
</div>
<form action="" method="post" name="frmMyProducts1">
    <input type="hidden" name="searchbox" id="searchbox" value="<?php echo $_REQUEST['txtSearch']; ?>">
    <input type="hidden" name="searchboxtype" id="searchboxtype" value="<?php echo $_REQUEST['cmbSearchType']; ?>">
    <input type="hidden" name="seller" id="seller" value="<?php echo $_REQUEST['txtSeller']; ?>">

    <div class="table-responsive no_margin">
        <table border="0" width="100%" cellpadding="0" cellspacing="0" class="table admin_table no_margin">

            <tr class="form_header">
                <th width="3%">#</th>
                <th width="18%" align="left"><?php echo PRODUCT_NAME;?></th>
                <th width="11%" align="left"><?php echo PRICE;?></th>
                <th width="12%" align="left"><?php echo CATEGORY;?></th>
                <th width="10%" align="left"><?php echo DATE_ADDED;?></th>
                <th width="10%" align="left"><?php echo IMP_COUNT?></th>
                <th width="10%" align="left"><?php echo PUBLISH_STATUS?></th>
                <th width="10%" align="left"><?php echo LISTING_FEE;?></th>
                <th width="24%" colspan="2" align="left">
                    <input type="checkbox" name="checkAllBox" value="1" onClick="checkAllOrders();"><?php //echo SEL_OR_DESELECT;?> &nbsp;
                    <a onClick="deleteProducts();" title="<?php echo TITLE_DELETE_SELECTED; ?>">
                       <i class="fa fa-trash-o" aria-hidden="true"></i>
                   </a>
               </th>
           </tr>
           
           <?php
           if (!empty($result)) {
            $i = 1;
            foreach($result as $row) {
                             // echopre($row);
                $link = "<a class=links href='editproduct.php?productid=" . $row["product_id"] . "&page=" . $_GET['page'] . "&from=list'>";

                $btnlink = "duplicateproduct.php?productid=" . $row["product_id"] . "&page=" . $_GET['page'] . "&from=list";

                switch (htmlentities($row["payment_status"])){
                   case 'PENDING':$st2=strtoupper(PENDING);
                   break;
                   case 'COMPLETED':$st2=strtoupper(COMPLETED);
                   break;
               }
               ?>
               <tr>
                <td><?php echo (($page * $limit) + $i - $limit) ?></td>
                <td align="left"><?php echo $link . stripslashes($row["product_name"]) . "</a>"; ?></td>
                <td><?php echo $adminCurrency['currency_symbol']; ?>  <?php echo $link . htmlentities(number_format($row["product_price"], 2, ".", "")) . "</a>"; ?></td>
                <td><?php echo $link .$row["category_name"] . "</a>"; ?></td>
                <td align=""><?php echo $link . dateFormat($row["date_added"], "Y-m-d", "m/d/Y") . "</a>"; ?></td>
                <td><?php echo $link . htmlentities($row["impression_count"]) . "</a>"; ?></td>
                <?php $pstatus = ($row["publish_status"]=='Y')?TEXT_PUBLISHED:TEXT_NOT_PUBLISHED;?>
                <td align="left"><?php echo $link.$pstatus."</a>";?></td>
                <td><?php echo $link . $st2. "</a>"; ?></td>
                <td>
                    <?php
                    $product_checkbox = "Product_" . $i;
                    ?>
                    <input type="checkbox" name="<?php echo $product_checkbox ?>" id="<?php echo $product_checkbox ?>" value="<?php echo $row['product_id'] ?>" onClick="addValues('<?php echo $row['product_id'] ?>');">
                    <a onClick="return duplicateProduct();" href="<?php echo $btnlink; ?>"  class="duplicate_btt">
                     <i class="fa fa-files-o" aria-hidden="true"></i> Duplicate
                 </a>
             </td>
         </tr>
         <?php
         $i++;
     }
     ?>
     <input type="hidden" name="checkCount" value="<?php echo $i - 1 ?>">
     <?php
 } else {
    ?>
    <tr>
        <td align="center" valign="middle" colspan="7"  class="text_information"><?php echo NO_PRODUCT_FOUND_TEXT;?> !!</td>
    </tr>
    <?php
}
?>
</table>
</div>
<div class="clearfix"></div>
<?php
if ($page > 1) {
   $pageprev = $page - 1;

   $previous_page = "<a href=" . $_SERVER['PHP_SELF'] . "?page=$pageprev&cmbSearchType=$cmbSearchType&txtSearch=$txtSearch alt='Previous' border='0' class='prv_nxt_btt'><i class='fa fa-angle-left' aria-hidden='true'></i></a>";
}
if ($page < $numofpages) {
   $pagenext = ($page + 1);

   $next = "<a href=" . $_SERVER['PHP_SELF'] . "?page=$pagenext&cmbSearchType=$cmbSearchType&txtSearch=$txtSearch alt='Next' border='0' class='prv_nxt_btt'><i class='fa fa-angle-right' aria-hidden='true'></i></a>";
}
if ($numofpages) {
    ?>

    <div class="pagination_outer">
      <div class="row">
         <div class="col-xs-12 col-sm-4 col-md-7 col-lg-7">

         </div>
         <div class="col-xs-12 col-sm-8 col-md-5 col-lg-5">
            <div class="feild_outer">
                <select class="form-control" name="gotoPage">
                   <?php
                   for ($i = 1; $i <= $numofpages; $i++) {
                       if ($i == $_GET['page']) {
                           $page_selected = "selected";
                       } else {
                           $page_selected = "";
                       }
                       ?>
                       <option value="<?php echo $i ?>" <?php echo $page_selected ?>><?php echo $i ?></option>
                       <?php
                   }
                   ?>
               </select>
               <a onClick="Javascript:document.frmMyProducts1.submit();" class="go_btt"><i class="fa fa-paper-plane" aria-hidden="true"></i> <?php echo GO; ?></a>
           </div>
           <div class="prv_nxt_btt_outer">
               <?php echo $previous_page ?>
               <?php //echo PAGE."";?>
               <span class="numofpages"><?php echo $page ?>/<?php echo $numofpages ?> </span>
               <?php //echo GO_TO;?>
               <?php echo $next ?>
           </div>

       </div>

   </div>
</div>

<?php
}
?>
<div class="clearfix"></div>

</form>

<form name="frmMyProducts2" method="post" action="#">
    <input type="hidden" name="txtProductId">
</form>
<!--content area end-->

</div>
</div>
</div>

<div class="clearfix">&nbsp;</div>


<!--main body end -->
</div>
<?php
include "../includes/admin_new_footer.php";
?>
<script>
    $(document).ready(function (){
        $.ajax({       
    url:"https://botory.com/multicart/cronproduct.php", //the page containing php script
    type: "post", //request type,
    dataType: 'html',                
    beforeSend: function() {
      console.log("running");
  },
  success:function() {
      console.log("runned");
      } //Change to this
  });
    });
</script>