<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (c) 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php

include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include_once('../classes/cls_utils.php');
include_once('../includes/S3.php');

if (get_magic_quotes_gpc()) {
	$_POST = array_map('stripslashes_deep', $_POST);
	$_GET = array_map('stripslashes_deep', $_GET);
	$_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
	$adminname = $_SESSION["sess_adminname"];
} else {
	header("Location:login.php");
	exit;
}

if (isset($_GET["sectionid"]) and $_GET["sectionid"] != "") {
	$sectionid = $_GET["sectionid"];
} else if (isset($_POST["sectionid"]) and $_POST["sectionid"] != "") {
	$sectionid = $_POST["sectionid"];
} else {
	header("Location:section.php");
	exit;
}

$cdn_enabled = "N";
if(ENABLE_AMAZON_S3_IMAGES=="Y"){
	$cdn_enabled  = "Y";
}

/*if (isset($_GET["parentcatid"]) and $_GET["parentcatid"] != "") {
$parentcatid = $_GET["parentcatid"];
} else if (isset($_POST["parentcatid"]) and $_POST["parentcatid"] != "") {
$parentcatid = $_POST["parentcatid"];
}*/

$txtSectionName = $_POST["txtSectionName"];

if (isset($_POST["btnSaveChanges"])) {

//Avatar Start
	$timeNow = time();
	$secfilename = '';
	$avatarError = '';
$max_file = 10; //MB
$newFilePrefix = 'avatar_large' . $timeNow . '_';
$large_image_location = '../sections/' . $newFilePrefix;
$thumb_image_location = '../sections/avatar/avatar_' . $timeNow . '_';
// Only one of these image types should be allowed for upload.
$allowed_image_types = array('image/pjpeg', 'image/jpeg', 'image/png', 'image/x-png', 'image/gif');
$allowed_image_exts = array("jpg", "jpeg", "png", "gif");

$image_ext = ""; // initialise variable, do not change this.
foreach ($allowed_image_exts as $mime_type => $ext) {
	$image_ext.= strtoupper($ext) . " ";
}
if (isset($_FILES["image"]['size']) && ($_FILES["image"]['size']) > 0) {

//Get the file information
	$userfile_name = $_FILES['image']['name'];
	$userfile_tmp = $_FILES['image']['tmp_name'];
	$userfile_size = $_FILES['image']['size'];
	$userfile_type = $_FILES['image']['type'];
	$filename = basename($_FILES['image']['name']);
	$file_ext = strtolower(substr($filename, strrpos($filename, '.') + 1));

//Only process if the file is a JPG, PNG or GIF and below the allowed limit
	if ((!empty($_FILES["image"])) && ($_FILES['image']['error'] == 0)) {

		if (!(in_array($file_ext, $allowed_image_exts) && in_array($userfile_type, $allowed_image_types))) {
			$avatarError = ONLY . $image_ext . IMAGES_ACCEPTED . "<br />";
		}

    //check if the file size is above the allowed limit
		if ($userfile_size > ($max_file * 1048576)) {
			$avatarError = IMG_UNDER . $max_file . MB_SIZE;
		}
	} else {
		$avatarError = SEL_IMG_TO_UPLOAD;
	}
//Everything is ok, so we can upload the image.
	if (strlen($avatarError) == 0) {
		if (isset($_FILES['image']['name'])) {
        //this file could now has an unknown file extension (we hope it's one of the ones set above!)
        //$large_image_location = $large_image_location;
        //$thumb_image_location = $thumb_image_location;
			$large_image_location = $large_image_location . $filename;
        //$thumb_image_location = $thumb_image_location.$filename;

			$uploaded = move_uploaded_file($userfile_tmp, $large_image_location);
			chmod($large_image_location, 0777);

        /* list($width, $height)= getimagesize($large_image_location);
          if($width != 191 || $height != 183 )
          {
          $avatarError = "Images resolution must be 191px X 183px";
          }
          else
          {
          copy($large_image_location, $thumb_image_location);
          chmod($thumb_image_location, 0777);
      } */



      $secfilename = $newFilePrefix . $filename;
      copy($large_image_location, '../sections/avatar/' . $secfilename);
      $imagePath  = '../sections/avatar/'.$secfilename;
      $imageName  = 'sections/avatar/'.$secfilename;
      moveImageToCDN($imagePath,$imageName);


      if (file_exists($large_image_location)) {
      	unlink($large_image_location);
      }
  }
}
}
$message .= $avatarError;
//Avatar End  




if (!isNotNull($txtSectionName)) {
	$message .= SEC_NAME_REQD . "<br>";;
} else {
	$qry = "SELECT section_name FROM  " . $tableprefix . "sections WHERE section_name = '" . addslashes($txtSectionName) . "' AND section_id <> '" . addslashes($sectionid) . "' ";
	$resultquery = $pdo->pdoQuery($qry,'')->results();



	if (!empty($resultquery)) {
		$message .= SEC_EXIST . "<br>";
	}
}

if ($message == "") {

	if($_POST['section_name_old']!=$txtSectionName){
 //Generate Alias name for section
		$aliasname = Utils::generateAlias($tableprefix . "sections", $txtSectionName);
	} 

	$data  = array("section_name"=>$txtSectionName,
		"cdn_images_moved"=>$cdn_enabled);

	if ($secfilename != '') {
		$data['avatar'] = $secfilename;
	}

	if($aliasname!=NULL) {
		$data['alias'] = $aliasname;
	}


	$pdo->update($tableprefix.'sections',$data, array("section_id"=>$sectionid))->affectedRows();


	$update_message = SEC_UPDATED;

	header("Location:section.php?sectionid=$sectionid&message=$update_message");
	exit;
} else {
	$message = "<br>" . MSG_CORRECT_THE_ERRORS . "<br>" . $message;
}
} else if ($_POST["btnDelete"] == DELETE) {

	if ($message == "") {

		$pdo->delete($tableprefix."sections",array("section_id"=>$sectionid))->affectedRows();

		$update_message = SEC_DELETED;
		header("Location:section.php?message=$update_message");
	} else {
		$message = "<br>" . MSG_CORRECT_THE_ERRORS . "<br>" . $message;
	}
}


$avatarImage = '../sections/avatar/noimage.jpg';


$res = $pdo->select($tableprefix.'sections',array('*'),array("section_id"=>$sectionid))->result();

if (!empty($res)) {
	$rw = $res;
	$txtSectionName = $rw["section_name"];
//$parentcatid = $rw["parent_id"];
	if (is_file('../sections/avatar/' . $rw["avatar"]) && file_exists('../sections/avatar/' . $rw["avatar"])) {
		$avatarImage = '../sections/avatar/' . $rw["avatar"];
	}
}

$cancellink = "section.php";

include "../includes/htmltop1.php";
?>
<script>
	function confirmDelete(){
		if(confirm("<?php echo ARE_YOU_SURE_DELETE_RECORD; ?>") ){
			return true;
		}
		return false;
	}
</script>

<body>

	<div class="main_outer">

		<!--header area start -->
		<?php
		include_once("../includes/topheader_admin1.php")
		?>

		<!--header area end -->

		<!--main body start -->

		<div class="contant_area">
			<?php
			include_once("../includes/admintopmenu1.php")
			?>
			
			<div class="right_main_cont_outer">
				<div class="right_main_cont_inner">    
					<div class="form_outer">
						<form name="frmCategory" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
							<input type="hidden" name="sectionid" value="<?php echo htmlentities($sectionid); ?>">
							<!-- <input type="hidden" name="parentcatid" value="<?php echo htmlentities($parentcatid); ?>"> -->
							<h1>
								<?php echo EDIT_SECTION; ?>
								<div class="pull-right normal_txt padding_T_15"><span class="required">*</span><?php echo MANDATORY_FIELDS; ?></div>
							</h1>
							<div class="text_information"><?php echo $message ?></div>
							
							<div class="white_cont_outer margin_B_30">
								
								<div class="col-xs-12 col-sm-6 col-md-6 padding_B_30">
									<label><?php echo SECTION_NAME; ?>&nbsp;<span class="required">*</span></label>
									<input type="text" class="form-control" value="<?php echo (stripslashes($txtSectionName)); ?>" name="txtSectionName" size="30" maxlength="50">
								</div>
									<!-- <tr>
									<td colspan="2"></td>
									<td align="left">
										<?php
										if ($leafCat === true) {
			
											$queryOptionsR = $pdo->select($tableprefix.'options',array('*'),'')->results();
											if (!empty($queryOptionsR)) {
			
												 $alreadyAvailableOptionsQ = $pdo->select($tableprefix.'category_options',array('option_id'),array("category_id"=>$catid))->results();
												$alreadyAvailableOptionsArr = array();
			
												foreach($alreadyAvailableOptionsQ as $alreadyAvailableOptions )
												{
													$alreadyAvailableOptionsArr[] = $alreadyAvailableOptions['option_id'];
												}
												
											  foreach($queryOptionsR as $optionsArr )  
											  {
													$optionsObj =  generalMethods::arrayToObject($optionsArr);
											   
													$checked = "";
													if (in_array($optionsObj->option_id, $alreadyAvailableOptionsArr)) {
														$checked = "checked";
													}
													?>
													<input type="checkbox" name="category_options[]" value="<?php echo $optionsObj->option_id ?>" <?php echo $checked ?>>&nbsp;<?php echo $optionsObj->option_name; ?>
													<?php
												}
											}
											echo "<br>";
										}
										?>
									</td>
								</tr> -->
								<div class="col-xs-12 col-sm-6 col-md-6 padding_B_30">
									<label><?php echo IMAGE; ?>  (191px X 183px)</label>
									<label class="btn-bs-file btn btn-lg btn-info upload_image">
										Choose File
										<input name="image" id="image" type="file">
									</label>
									<div class="clearfix">&nbsp;</div>
									<div class="clearfix" align="center">
										<img src="<?php echo $avatarImage; ?>" alt="" width="150"/>
									</div>
								</div>
								<div class="clearfix"></div>
								<input type="hidden" name="section_name_old" value="<?php echo (stripslashes($txtSectionName)); ?>">
								<div class="col-xs-12 col-sm-4 col-md-4">
									<button type="button" value="<?php echo CANCEL; ?>" class="secondary" onClick="window.location.href='<?php echo $cancellink; ?>';" name="btnCancel">
										<i class="fa fa-chevron-left" aria-hidden="true"></i> <?php echo CANCEL; ?>
									</button>
								</div>
								<div class="col-xs-12 col-sm-4 col-md-4"></div>
								<div class="col-xs-12 col-sm-4 col-md-4">
									<button type="submit" value="<?php echo BTN_SAVE_CHANGES; ?>" class="primery_btt" name="btnSaveChanges">
										<i class="fa fa-floppy-o" aria-hidden="true"></i>
										<?php echo BTN_SAVE_CHANGES; ?>
									</button>
									<!-- <input class="button" type="submit" value="<?php echo DELETE; ?>" name="btnDelete" CANCEL="return confirmDelete();" >&nbsp;&nbsp; -->
									
								</div>
								<div class="clearfix"></div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>

		
		<?php
		include "../includes/admin_new_footer.php";
		?>
