<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Santhosh thomas Alexander<santhosh.thomas@armiasystems.com> |
// | & Manu R S <manu.r@armiasystems.com>                                 |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com ï¿½ 2005              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+

include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include('../includes/class.upload.php');
include_once('../includes/S3.php');
/* * **** Including resize library ****** */
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

$cdn_enabled = "N";
if (ENABLE_AMAZON_S3_IMAGES == "Y") {
    $cdn_enabled = "Y";
}

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
    $adminname = $_SESSION["sess_adminname"];
} else {
    header("Location:login.php");
    exit;
}

$action = isset($_GET['action']) ? trim($_GET['action']) : '';
switch ($action) {
    case "delmoreimage":
    $id = isset($_POST['id']) ? trim($_POST['id']) : '';
    $image = isset($_POST['image']) ? trim($_POST['image']) : '';

    $pdo->delete($tableprefix."product_view_images",array("nproduct_image_id"=>$id))->affectedRows();
    deleteCDNImagesMore($image);
    if (is_file("../products" . $image) && file_exists("../products" . $image)) {
        @unlink("../products" . $image);
    }
    echo json_encode(array('success' => MSG_MORE_IMAGE_DELETED_SUCCESSFULLY));
    exit;
    break;
    case "checkDelvariantsOption":
    $id = isset($_POST['id']) ? trim($_POST['id']) : '';
    $id = explode("_", $id);
    $id = $id[1];
    if($id) {
        $optionNameSql = "SELECT option_name FROM " . $tableprefix . "options WHERE option_id=".$id;
        $optionNameSqlRes = $pdo->pdoQuery($optionNameSql,'')->result();
    }
        //echo json_encode(array($optionNameSqlRes['option_name'])); exit;
        //check whether option is assigned to a category
    $query_assigned_checkR1 = $pdo->select($tableprefix.'category_options',array('category_option_id,category_id'),array("option_id"=>$id))->results();

    $optionCat = array();
    if (!empty($query_assigned_checkR1)) {
        foreach($query_assigned_checkR1 as $row)
        {
            $optionCat[] = $row['category_id'];
        }
    }
    $optionsCatList = implode(',', $optionCat);
    if($optionsCatList!='')  {
        $checkSql = "SELECT product_option_value_id FROM " . $tableprefix . "product_option_values WHERE option_id=".$id;
        $checkRes= $pdo->pdoQuery($checkSql,'')->result();
    }
        //echo json_encode(array($checkRes)); exit;

        if (!empty($checkRes)) { //if yes,restrict delete option
            echo json_encode(array('failed'=>'The option <span>'.$optionNameSqlRes['option_name'].'</span> is already assigned to some category which has products. So unable to remove this option!!'));
        } else {
            echo json_encode(array('success'=>$id,'optionName'=>$optionNameSqlRes['option_name']));
        }
        exit;
        break;
        case "delvariantsOption":
        $id = isset($_POST['id']) ? trim($_POST['id']) : '';
        $id = explode("_", $id);
        $id = $id[1];
        if($id){
            $optionNameSql = "SELECT option_name FROM " . $tableprefix . "options WHERE option_id=".$id;
            $optionNameSqlRes = $pdo->pdoQuery($optionNameSql,'')->result();
            $optionNameSqlRes = $optionNameSqlRes['option_name'];
            $pdo->delete($tableprefix."category_options",array("option_id"=>$id))->affectedRows();
            $pdo->delete($tableprefix."options",array("option_id"=>$id))->affectedRows();
            echo json_encode(array('success'=>'y','optionName'=>$optionNameSqlRes));
        } else {
            echo json_encode(array('failed'=>'Failed, Something went wrong !!'));
        }
        exit;
        break;
    }

    $maximagesizestringinPHP = ini_get("upload_max_filesize");

    $maximagesizeinPHP = $maximagesizestringinPHP * (1024 * 1024);



    if (isset($_GET["productid"]) and $_GET["productid"] != "") {
        $productid = $_GET["productid"];
    } else if (isset($_POST["productid"]) and $_POST["productid"] != "") {
        $productid = $_POST["productid"];
    } else {
        header("Location:catalog.php");
        exit;
    }


//echopre($_POST); exit;

    $sizeOfOptions=0;
    $shipping_product_display = "";
    $txtProductName = $_POST["txtProductName"];
    $txtProductCode = $_POST["txtProductCode"];
    $txtDescription = $_POST["txtDescription"];
    $txtPrice = $_POST["txtPrice"];
    $ddlArtist = $_POST["ddlArtist"];
    $sectionCat = $_POST["sectionCat"];
    $sectionCat = implode(",",$sectionCat);
//echopre($sectionCat); exit;

    $ddlCategory = $_POST["txtCategory"];
    $txtSearchTags = $_POST["txtProductTags"];
    (isset($_POST['chkAllowFreeShipping'])) ? $chkAllowFreeShipping = $_POST['chkAllowFreeShipping'] : $chkAllowFreeShipping = 'N';
    (isset($_POST['chkAllowSubscription'])) ? $chkAllowSubscription = $_POST['chkAllowSubscription'] : $chkAllowSubscription = 'N';
    $rdSubscriptionMode = $_POST["rdSubscriptionMode"];
    $rdPublishStatus = $_POST["rdPublishStatus"];
    if ($rdPublishStatus == "N") {
    //published time in 24_hour_format
        $selected_time = ($_POST['publishtime'] != '') ? $_POST['publishtime'] : '12:00am';
        $formatteDate = dateFormat($_POST['publishdate'], "m-d-Y", "Y-m-d");
        $publishDate = date("Y-m-d H:i:s", strtotime($formatteDate . $selected_time));

    //Get seller time zone
        $arrSellerTimezone = generalMethods::getSellerTimeZone($ddlArtist);
        $sellertimezone = $arrSellerTimezone['seller_time_zone'];
    } else {
        $publishDate = "0000-00-00 00:00:00";
        $sellertimezone = "";
    }

    if (getSettingsValue('enable_product_scheduled_publishing') == 'N') {
        $rdPublishStatus = 'Y';
    }

    $prodimagedir = "../products/";
    (isset($_POST['txtDigitalProduct'])) ? $txtDigitalProduct = $_POST['txtDigitalProduct'] : $txtDigitalProduct = 'N';

    $sql = "SELECT * FROM " . $tableprefix . "settings ";
    $result = $pdo->pdoQuery($sql)->results();

    if (count($result) > 0) {
        $row = ($result[0]);
        $chkcanship = $row["enable_canadapost"];
    }
    $sql_digital = "SELECT * FROM " . $tableprefix . "products WHERE product_id= :productid and product_artist_id = :artistid  ";
    $result_digital = $pdo->pdoQuery($sql_digital, array("productid" => $productid, "artistid" => $artistid))->results();
    if (count($result_digital) != 0) {
        $rr = ($result_digital[0]);
        $txtDigitalproduct = $rr['vdigital_product'];
    }
    if ($txtDigitalproduct == "Y") {
        $canshipblock = "none";
    } else {
        $canshipblock = "";
    }
    if (isset($_POST["btnSaveChanges"])) {
        $message = "";

        if (!isNotNull($txtProductName)) {
            $message .= PRO_NAME_EMPTY . "<br>";
        } else {
            $qry = "SELECT  product_name FROM  " . $tableprefix . "products WHERE product_name= :txtProductName
            and product_artist_id= :ddlArtist and product_category = :ddlCategory and product_id <> :productid  ";
            $Count = $pdo->pdoQuery($qry, array("txtProductName" => $txtProductName, "ddlArtist" => $ddlArtist, "ddlCategory" => $ddlCategory, "productid" => $productid))->results();
            if (count(($Count)) > 0) {
                $message .= PRO_WITH_SAME_NAME . "<br>";
            }
        }
        if ($txtDescription == '') {
            $message .= PRO_DESC_EMPTY . "<br>";
        }
        if (!isNotNull($txtProductCode)) {
        //$message .= "* Product Code cannot be empty! <br>";
        } else {
            $qry = "SELECT  product_code FROM  " . $tableprefix . "products WHERE product_code= :txtProductCode
            and product_artist_id= :ddlArtist and product_category = :ddlCategory and product_id <> :productid  ";
            $Count = $pdo->pdoQuery($qry, array("txtProductCode" => $txtProductCode, "ddlArtist" => $ddlArtist, "ddlCategory" => $ddlCategory, "productid" => $productid))->results();
            if (count(($Count)) > 0) {
                $message .= PRO_WITH_SAME_CODE . "<br>";
            }
        }

        if (!isNotNull($ddlArtist)) {
            $message .= SELLER_EMPTY . "<br>";
        }

    /*if (!isNotNull($sectionCat)) {
        $message .= SECTION_EMPTY . "<br>";
    }*/

    $txtPrice = doubleval($txtPrice);
    if ($txtPrice <= 0 || !is_numeric($txtPrice)) {
        $message .= PRO_PRICE_EMPTY . "<br>";
    } else {
        if ($txtPrice <= 0) {
            $message .= PRO_PRICE_POSITIVE . "<br>";
        }
    }

    if ($txtDigitalProduct != "Y") {
        if ($txtShippingWeight != '') {
            if (!is_numeric($txtShippingWeight) || $txtShippingWeight == 0) {
                $message .= ENTER_VALID_PRO_SHPNG_WEIGHT . "<br>";
            }
        }
    }


    /* ----Digital Product Block Starts------- */

    if (isNotNull($_FILES['txtProductZip']['name'])) {
        $uploadfile = ReplaceArrayImage($_FILES['txtProductZip']['name']);
        //$types = array('gif','jpg','png','zip', 'pdf', 'rar', 'psd', 'opf', 'azw', 'lit', 'pdb', 'pkg', 'mp3', 'mpeg', 'mp4', 'avi', 'mpg', 'wma');
        preg_match('/\.([a-zA-Z0-9]+?)$/', $uploadfile, $matches);
        if (!in_array(strtolower($matches[1]), $digital_product_types)) { // check file format is valid or not
            $message .= INVALID_FILE_FORMAT . "<br>";
        } // end format check
    }

    if (!in_array('1', $_POST['default_option'])) {
        $message .= SEL_DEFAULT_OPTION . "<br>";
    }

    $options_count = count($_POST['additional_price']);
    for ($i = 0; $i < $options_count; $i++) {
        $product_option_id = $_POST['product_option_id'][$i];
        $default_option = $_POST['default_option'][$i];
        $additional_price = $_POST['additional_price'][$i];
        $product_stock = $_POST['product_stock'][$i];
        $reorder_level = $_POST['reorder_level'][$i];
        $product_shipping_weight = $_POST['product_shipping_weight'][$i];

        $discount = $_POST['discount'][$i];
        $discount_description = $_POST['discount_description'][$i];
        $product_length = $_POST['product_length'][$i];
        $product_width = $_POST['product_width'][$i];
        $product_height = $_POST['product_height'][$i];

        $prodimagedir = "../products/";

        $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
        $picsmallorgname = $_FILES['image_small']['name'][$i];
        $picsmalltempname = $_FILES['image_small']['tmp_name'][$i];
        $picsmalltype = $_FILES['image_small']['type'][$i];

        $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
        $picbigtype = $_FILES['image_big']['type'][$i];
        $picbigorgname = $_FILES['image_big']['name'][$i];
        $picbigtempname = $_FILES['image_big']['tmp_name'][$i];

        if ($picbigname != "") {
            $final_image_big = "productlarge_" . $i . time() . $picbigname;
        } else {
            $final_image_big = "";
        }

        if ($picsmallname != "") {
            $final_image_small = "productsmall_" . $i . time() . $picsmallname;
        } else {
            $final_image_small = "";
        }

        $picsmalldest = $prodimagedir . $final_image_small;
        $picbigdest = $prodimagedir . $final_image_big;

        $picsmallname = $final_image_small;
        $picbigname = $final_image_big;

        if (!is_readable($prodimagedir) || !is_writable($prodimagedir)) {
            $error = true;
            $message .= CHANGE_PERMISSION . "<br>";
        }

        if ($picsmalltype != "") {
            if (!isValidWebImageType($picsmalltype, $picsmallorgname, $picsmalltempname)) {
                $message .= SMALL_PICTURE . " " . $i . "<br>";
                $error = true;
            } else {
                if (file_exists($picsmalldest)) {
                    $message .= SMALL_PIC_EXISTS . " " . $i . "<br>";
                    $error = true;
                }
            }
        }
        if ($picbigtype != "") {
            if (!isValidWebImageType($picbigtype, $picbigorgname, $picbigtempname)) {
                $message .= BIG_PICTURE . " " . $i . "<br>";
                $error = true;
            } else {
                if (file_exists($picbigdest)) {
                    $message .= BIG_PIC_EXISTS . " " . $i . "<br>";
                    $error = true;
                }
            }
        }


        $product_stock = doubleval($product_stock);
        if ($product_stock == "") {
            $message .= PRO_STOCK_EMPTY . " " . ($i + 1) . " ! <br>";
        }
        if ($product_stock < 0 || !is_numeric($product_stock)) {
            if ($product_stock < 0) {
                $message .= PRO_STOCK_POSITIVE . " " . ($i + 1) . " ! <br>";
            }
        }

        if ($additional_price != "") {
            if ($additional_price < 0 || !is_numeric($additional_price)) {
                $message .= ADDITIONAL_PRICE_POSITIVE . " " . ($i + 1) . "! <br>";
            }
        }

        if ($discount != "") {
            if ($discount >= 100) {
                $message .= DISCOUNT_VALIDATION . " " . ($i + 1) . "! <br>";
            }
        }


        if ($chkcanship == "Y" && $txtDigitalProduct != "Y") {
            if ($product_length == "") {
                $message .= PRO_LEN_EMPTY . " " . ($i + 1) . " !<br>";
            }
            if ($product_width == "") {
                $message .= PRO_WIDTH_EMPTY . " " . ($i + 1) . " !<br>";
            }
            if ($product_height == "") {
                $message .= PRO_HEIGHT_EMPTY . " " . ($i + 1) . " !<br>";
            }
            if ($txtDigitalProduct != "Y") {
                if ($product_shipping_weight == "") {
                    $message .= PRO_SHIPPING_EMPTY . " " . ($i + 1) . "!<br>";
                }
            }
        }

        if ($product_length != '') {
            if (!is_numeric($product_length)) {
                $message .= ENTER_VALID_PRO_LEN . " " . ($i + 1) . "! <br>";
            }
        }

        if ($product_width != '') {
            if (!is_numeric($product_width)) {
                $message .= ENTER_VALID_PRO_WID . " " . ($i + 1) . "! <br>";
            }
        }

        if ($product_height != '') {
            if (!is_numeric($product_height)) {
                $message .= ENTER_VALID_PRO_HEIGHT . " " . ($i + 1) . "! <br>";
            }
        }

        if ($txtDigitalProduct != "Y") {
            if (!is_numeric($product_shipping_weight) || $product_shipping_weight == 0) {
                $message .= ENTER_VALID_PRO_SHPNG_WEIGHT . " " . ($i + 1) . "! <br>";
            }
        }
        $product_shipping_weight = doubleval($product_shipping_weight);

        if ($product_shipping_weight < 0) {
            $message .= PRO_WEIGHT_POSITIVE . " " . ($i + 1) . "! <br>";
        }
        $reorder_level = doubleval($reorder_level);
        if ($reorder_level != "") {
            if ($reorder_level < 0 || !is_numeric($reorder_level)) {
                $message .= PRO_LEVEL_POSITIVE . " " . ($i + 1) . "! <br>";
            } else if ($reorder_level > $product_stock) {
                $message .= PRO_LEVEL_LESS . " " . ($i + 1) . "! <br>";
            }
        }
    }
    /*
     * More Images Validation
     */

    if (isset($_FILES['productMoreImage']['name']) && !empty($_FILES['productMoreImage']['name'])) {
        foreach ($_FILES['productMoreImage']['name'] as $key => $moreImage) {
            if ($moreImage != '') {
                $type = $_FILES['productMoreImage']['type'][$key];
                if (!isValidWebImageType($type)) {
                    $message .= INVALID_MORE_IMG . " " . ($key + 1) . "<br>";
                }
            }
        }
    }

    $moreFiles = array();
    foreach ($_FILES['productMoreImage'] as $k => $l) {
        foreach ($l as $j => $v) {
            if (!array_key_exists($j, $moreFiles)) {
                $moreFiles[$j] = array();
            }
            $moreFiles[$j][$k] = $v;
        }
    }



//default published if settings disabled

    if (getSettingsValue('enable_product_scheduled_publishing') == 'N') {
        $rdPublishStatus = 'Y';
    }
// get the seller information and set vacation mode status in product
    $sellerCartObj = Store::get_seller_account_info($ddlArtist);
//echopre($sellerCartObj);
    if ($sellerCartObj->status == SUCCESS) {
        $sellerCartObjVal = $sellerCartObj->data;
        $seller_vacation_mode = $sellerCartObjVal->is_vacation_mode;
    }

    /* ----Digital Product Block Ends------- */

    if ($message != "") { // error
        $message = "<br>" . MSG_CORRECT_THE_ERRORS . "<br>" . $message;
    } else { // no error so insert user details
        if ($_POST['product_name_old'] != $txtProductName) {
            //Generate Alias name for product
            $aliasname = Utils::generateAlias($tableprefix . "products", $txtProductName);
        }

    $product_category = $_POST['txtCategory']; //Manu R S Category Id mis. //03/10/17
    /*if((isset($_POST['txtCategory'])) && (strlen($_POST['txtCategory'])>0)){
           $product_category = $_POST['txtCategory'];
    } else {
          $product_category = $_POST['oldcategory'];
      }*/

      if($_POST['txtDigitalProduct'] == Y) {
        $dproduct = 'Y';
    } else {
        $dproduct = 'N';
    }   

    $aliasname = Utils::generateAlias($tableprefix . "products", $txtProductName);
    $data = array(
        "product_name" => addslashes($txtProductName),
        "product_code" => $txtProductCode,
        "product_description" => addslashes($txtDescription),
        "product_price" => $txtPrice,
        "product_category" => $product_category,
        "product_artist_id" => $ddlArtist,
        "product_section" => $sectionCat,
        "date_added" => date('Y-m-d'),
        "vdigital_product" => $dproduct,
        "vapproved" => 'Y',
        "payment_status" => 'COMPLETED',
        "alias" => addslashes($aliasname),
        "publish_status" => $rdPublishStatus,
        "publish_scheduled_date" => $publishDate,
        "product_tags" => addslashes($txtSearchTags),
        "allow_subscription" => $chkAllowSubscription,
        "subscription_mode" => $rdSubscriptionMode,
        "publish_timezone" => $sellertimezone,
        "allow_free_shipping" => $chkAllowFreeShipping,
        "seller_vacation_mode" => $seller_vacation_mode
        );
        //echo $sql;
        //$pdo->update($tableprefix.'products', $data, array("product_id" => $productid))->affectedRows();
    
    $productid = $pdo->insert($tableprefix."products",$data)->lastInsertId();

        ////options dont delete


        //Options area comes here
        //checking whether any option deleted
/*        $options_deleted = array();
        $queryOptionsAlready = "SELECT product_option_id FROM " . $tableprefix . "product_options WHERE product_id = :productid";
        $queryOptionsAlreadyQ = $pdo->pdoQuery($queryOptionsAlready, array("productid" => $productid))->results();
        foreach ($queryOptionsAlreadyQ as $optionsAlreadyObj) { $optionsAlreadyObj = (object)$optionsAlreadyObj;
            if (!in_array($optionsAlreadyObj->product_option_id, $_POST['product_option_id'])) {
                array_push($options_deleted, $optionsAlreadyObj->product_option_id);
            }
        }
        if (count($options_deleted)) {
            $options_delStr = implode(',', $options_deleted);
            list($qarr,$qstr) = getInQueryString($options_delStr);
            $query_option_value_delete = "DELETE FROM " . $tableprefix . "product_option_values WHERE product_option_id IN (" . $qstr . ")";
            $pdo->pdoQuery($query_option_value_delete, $qarr)->results();
            $query_option_delete = "DELETE FROM " . $tableprefix . "product_options WHERE product_option_id IN (" . $options_delStr . ")";
            $pdo->pdoQuery($query_option_delete, $qarr)->results();
        }

        $options_available_now_array = $_POST['product_option_id'];*/
        //Product Options Insertion here Santhosh thomas Alexander
        for ($i = 0; $i < $options_count; $i++) {

            $default_option = $_POST['default_option'][$i];
            $product_option_id = $_POST['product_option_id'][$i];
            $additional_price = $_POST['additional_price'][$i];
            $product_stock = $_POST['product_stock'][$i];
            $reorder_level = $_POST['reorder_level'][$i];
            $product_shipping_weight = $_POST['product_shipping_weight'][$i];
            $discount = $_POST['discount'][$i];
            $discount_description = $_POST['discount_description'][$i];
            $product_length = $_POST['product_length'][$i];
            $product_width = $_POST['product_width'][$i];
            $product_height = $_POST['product_height'][$i];
            $default_option_actual = "NO";
            if ($default_option == 1) {
                $default_option_actual = "YES";
            }
            $small_image_name_after_upload = "";
            $big_image_name_after_upload = "";

            $dir_dest = "../products";
            //small Image Upload

            $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);

            $final_image_small = "";

//************************************************Multicart3.0 Image Upload Modifications******************************

            if ($picsmallname != "") {
                $picSmallArr = explode('.', $picsmallname);
                $cntCountParamsSmall = count($picSmallArr);
                $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
            } else {

                // Save and resize Big Image to small size if small image not uploaded
                if ($_FILES['image_big']['name'][$i] != '') {
                    $picsmallname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);
                    $picSmallArr = explode('.', $picsmallname);
                    $cntCountParamsSmall = count($picSmallArr);
                    $name_small_with_out_extension = str_replace('.' . $picSmallArr[$cntCountParamsSmall - 1], '', $picsmallname);
                    $final_image_small = "productsmall_" . $productid . "_" . $i . "_" . time() . $name_small_with_out_extension;
                }
            }

            $picsmallname = $final_image_small;

            $picbigname = ReplaceArrayImage($_FILES['image_big']['name'][$i]);

            $final_image_big = "";
            if ($picbigname != "") {
                $picBigArr = explode('.', $picbigname);
                $cntCountParamsBig = count($picBigArr);
                $name_big_with_out_extension = str_replace('.' . $picBigArr[$cntCountParamsBig - 1], '', $picbigname);
                $final_image_big = "productbig_" . $productid . "_" . $i . "_" . time() . $name_big_with_out_extension;
            }
            $picbigname = $final_image_big;

            /*             * ****************************************************Saving the original image**************** */

            /* if ($_FILES['image_small']['name'][$i] != "") {
              $picsmallname = ReplaceArrayImage($_FILES['image_small']['name'][$i]);
              $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
              $file_extn              = end(explode(".",$picsmallname));
              //Save Small image
              $original_image_name_after_upload      = "productoriginal_".$productid."_".time().$picsmallname;
              $imageOriginal                        = "../products/".$original_image_name_after_upload;
              $imageOriginalSave                     = fopen($imageOriginal,'x');
              fwrite($imageOriginalSave, $imagecontent);
              fclose($imageOriginalSave);
          } */
          /*             * ************************************************Saving the original image**************** */
            // then we check if the file has been uploaded properly
            // in its *temporary* location in the server (often, it is /tmp)
            // Save Samll Images

          if ($_FILES['image_small']['name'][$i] != "") {
                //Commenting the previous code
            $files = array();
            foreach ($_FILES['image_small'] as $k => $l) {
                foreach ($l as $j => $v) {
                    if (!array_key_exists($j, $files))
                        $files[$j] = array();
                    $files[$j][$k] = $v;
                }
            }

            for ($x = 0; $x < count($files); $x++) {
                if ($x == $i) {
                    $handle = new Upload($files[$x]);
                    if ($handle->uploaded) {
                            // Modification resize
                            //   $info = getimagesize($inputFileName);
                        $handle->image_resize = true;
                        $handle->image_ratio = true;
                        $handle->image_x = 387;
                        $handle->image_y = 260;
                        $handle->file_new_name_body = $picsmallname;
                        $handle->Process($dir_dest);
                        $small_image_name_after_upload = $handle->file_dst_name;
                            // $imagepath = "../products/" . $small_image_name_after_upload;
                            // moveImageToCDN($imagepath, 'products/' . $small_image_name_after_upload);
                        if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                          $imagepath =  realpath(__DIR__ . '/..')."/products/".$small_image_name_after_upload;
                      }
                      else{
                          $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$small_image_name_after_upload;

                      }
                      moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$small_image_name_after_upload);
                  }
              }
          }
          /*                 * ************image resizing maintaining then aspect ratio **************** */
                /* $imagecontent = file_get_contents($_FILES['image_small']['tmp_name'][$i]);
                  $file_extn              = end(explode(".",$picsmallname));
                  //Save Small image
                  // $small_image_name_after_upload      = "productsmall_".$productid."_".time().$picsmallname;
                  $small_image_name_after_upload = str_replace('productoriginal_','productsmall_',$original_image_name_after_upload);
                  $imageSmall                         = "../products/".$small_image_name_after_upload;
                  $imageSmallSave                     = fopen($imageSmall,'x');
                  fwrite($imageSmallSave, $imagecontent);
                  fclose($imageSmallSave);
                  reSizeImageFromFolder($imageSmall,191,183); */
                  /*                 * ************image resizing maintaining then aspect ratio **************** */
              }
            //small image upload end
            //big Image Upload
            // then we check if the file has been uploaded properly
            // in its *temporary* location in the server (often, it is /tmp)
            // Save Big Images

              if ($picbigname != "") {
                //Commenting the previous code
                $files = array();
                foreach ($_FILES['image_big'] as $k => $l) {
                    foreach ($l as $j => $v) {
                        if (!array_key_exists($j, $files))
                            $files[$j] = array();
                        $files[$j][$k] = $v;
                    }
                }
                for ($x = 0; $x < count($files); $x++) {
                    if ($x == $i) {
                        $handle = new Upload($files[$x]);
                        if ($handle->uploaded) {

                            $handle->image_resize = true;
                            $handle->image_ratio = true;
                            $handle->image_x = 489;
                            $handle->image_y = 328;
                            $handle->file_new_name_body = $picbigname;
                            $handle->Process($dir_dest);
                            $big_image_name_after_upload = $handle->file_dst_name;
                            // $imagepath = "../products/" . $big_image_name_after_upload;
                            // moveImageToCDN($imagepath, 'products/' . $big_image_name_after_upload);
                            if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                              $imagepath =  realpath(__DIR__ . '/..')."/products/".$big_image_name_after_upload;
                          }
                          else{
                              $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$big_image_name_after_upload;

                          }
                          moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$big_image_name_after_upload);

                          $main_thumb_file_name = "thumb_" . $picbigname;
                          $handle->file_new_name_body = $main_thumb_file_name;
                          $handle->image_resize = true;
                          $handle->image_x = 82;
                          $handle->image_y = 79;
                          $handle->image_ratio = true;
                          $handle->Process($dir_dest);
                          $main_thumb_file_name_after_upload = $handle->file_dst_name;
                            // $imagethubpath = "../products/" . $main_thumb_file_name_after_upload;
                            // moveImageToCDN($imagethubpath, 'products/' . $main_thumb_file_name_after_upload);
                          if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                              $imagepath =  realpath(__DIR__ . '/..')."/products/".$main_thumb_file_name_after_upload;
                          }
                          else{
                              $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$main_thumb_file_name_after_upload;

                          }
                          moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$main_thumb_file_name_after_upload);
                      }




                        /*  // Create thumbnail Image and save to thumb folder
                          $big_file_name                  =    "thumb_".$picbigname;
                          $handle->file_new_name_body     =    $big_file_name;
                          $handle->image_resize           = true;
                          $handle->image_x                = 82;
                          $handle->image_y                = 79;
                          $handle->image_ratio            = true;
                          $handle->Process($dir_dest);

                          echo $imagethumbpath  = "../products/".$big_file_name;
                          moveImageToCDN($imagethumbpath,'products/'.$big_file_name); */


                        // Resize  Small images in listing if small image  not uploaded
                          if ($_FILES['image_small']['name'][$i] == '') {
                            $small_file_name = $picsmallname;
                            $handle->file_new_name_body = $small_file_name;
                            $handle->image_resize = true;
                            $handle->image_x = 387;
                            $handle->image_y = 260;
                            $handle->image_ratio = true;
                            $handle->Process($dir_dest);
                            $small_image_name_after_upload = $handle->file_dst_name;
                            // $imagepath = "../products/" . $small_image_name_after_upload;
                            // moveImageToCDN($imagepath, 'products/' . $small_image_name_after_upload);
                            if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                              $imagepath =  realpath(__DIR__ . '/..')."/products/".$small_image_name_after_upload;
                          }
                          else{
                              $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$small_image_name_after_upload;

                          }
                          moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$small_image_name_after_upload);
                      }
                  }
              }
          }
          /*             * ************image resizing maintaining then aspect ratio **************** */
            /* $imagecontent = file_get_contents($_FILES['image_big']['tmp_name'][$i]);
              $file_extn              = end(explode(".",$picbigname));
              //$big_image_name_after_upload      = "productbig_".$productid."_".time().$picbigname;
              $big_image_name_after_upload = str_replace('productoriginal_','productbig_',$original_image_name_after_upload);
              $imageSmall             = "../products/".$big_image_name_after_upload;
              $imageSmallSave         = fopen($imageSmall,'x');
              fwrite($imageSmallSave, $imagecontent);
              fclose($imageSmallSave);
              reSizeImageFromFolder($imageSmall,283,269); */
              /*             * ************image resizing maintaining then aspect ratio **************** */

            //big image upload end
            //Product option Images upload end
            //updating already existing options and inserting new ones
              /*if ($product_option_id == "") {*/

                $data = array (
                    "product_id" => $productid,
                    "additional_price" => $additional_price,
                    "product_stock" => $product_stock,
                    "reorder_level" => $reorder_level,
                    "product_shipping_weight" => $product_shipping_weight,
                    "image_small" => $small_image_name_after_upload,
                    "image_big" => $big_image_name_after_upload,
                    "discount" => $discount,
                    "discount_description" => $discount_description,
                    "product_length" => $product_length,
                    "product_width" => $product_width,
                    "product_height" => $product_height,
                    "default_option" => $default_option_actual,
                    "cdn_images_moved" => $cdn_enabled
                    );

                if ($small_image_name_after_upload != "") {
                    $data["image_small"] = $small_image_name_after_upload;
                } else{
                    $data["image_small"] = $_POST['image_big_op'][$i];
                }
                if ($big_image_name_after_upload != "") {
                    $data["image_big"] = $big_image_name_after_upload;
                } else {
                    $data["image_big"] = $_POST['image_big_op'][$i];

                    $oldfile = $dir_dest.'/'.$_POST['image_big_op'][$i];
                    $thumboldfile = $dir_dest.'/thumb_'.$_POST['image_big_op'][$i];
                    $rand = mt_rand();
                    $newfile = $dir_dest.'/'.$rand.'_'.$_POST['image_big_op'][$i];
                    $newfileNew = $rand.'_'.$_POST['image_big_op'][$i];
                    $newthumbfile = $dir_dest.'/thumb_'.$rand.'_'.$_POST['image_big_op'][$i];
                    if (copy($oldfile, $newfile)) {
                        copy($thumboldfile, $newthumbfile);
                        $data["image_big"] = $newfileNew;
                        $data["image_small"] = $newfileNew;
                    }
                }

/*echopre($_POST['productMoreImageName']);
$productMoreImageName = $_POST['productMoreImageName'];
$length = sizeof($productMoreImageName);
echopre1($length);*/

/*echopre1($_POST);
            echopre($product_option_id);
            $arrayval[] = $product_option_id;
       if($i = 2){
            echopre($arrayval);
            exit;
        }     */

        

        $product_option_id = $pdo->insert($tableprefix."product_options",$data)->lastInsertId();

            /*} else {

                $data = array(
                            "product_id" => $productid,
                            "additional_price" => $additional_price,
                            "product_stock" => $product_stock,
                            "reorder_level" => $reorder_level,
                            "product_shipping_weight" => $product_shipping_weight
                            );
                if ($small_image_name_after_upload != "") {
                    $data["image_small"] = $small_image_name_after_upload;
                }
                if ($big_image_name_after_upload != "") {
                    $data["image_big"] = $big_image_name_after_upload;
                }
                $data["discount"] = $discount;
                $data["discount_description"] = $discount_description;
                $data["product_length"] = $product_length;
                $data["product_width"] = $product_width;
                $data["product_height"] = $product_height;
                $data["default_option"] = $default_option_actual;

                $pdo->update($tableprefix.'product_options', $data, array("product_option_id" => $product_option_id))->affectedRows();

                // echo $sqlOptions;exit;
            }*/
            /*$queryDeleteOption = "DELETE FROM " . $tableprefix . "product_option_values WHERE product_option_id = :product_option_id";
            $pdo->pdoQuery($queryDeleteOption, array("product_option_id" => $product_option_id))->results();*/

            $options_arr = getOptionsFromCategory($ddlCategory);
            $num_of_options = count($options_arr);
            if ($num_of_options != "") {
                foreach ($options_arr AS $eachoption) {

                    $option_Id = $eachoption['option_id'];
                    $option_value = $_POST["option_" . $option_Id][$i];
                    if ($option_value != "") {

                        $data = array(
                            "product_option_id" => $product_option_id,
                            "option_id" => $option_Id,
                            "value" => $option_value
                            );
                        $pdo->insert($tableprefix."product_option_values", $data)->lastInsertId();
                    }
                }
            }
        }
//echopre($_POST);

//echopre($_POST['productMoreImageName']);
/*$productMoreImageName = $_POST['productMoreImageName'];
foreach ($productMoreImageName as $key => $value) {
    if($value){
        $oldfile = $dir_dest.'/'.$value;
        $rand = mt_rand();
        $newfile = $dir_dest.'/'.$rand.'_'.$value;
        $newfileNew = $rand.'_'.$value;
        if (copy($oldfile, $newfile)) {
            $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                SET nimage_productid = :productid,
                vimage_name= :moreImageNameAfterupload,
                vproduct_image_delete_status  ='N',
                cdn_images_moved = :cdn_enabled";
                $afrows = $pdo->pdoQuery($insertMImageQuery, array("productid" => $productid, "moreImageNameAfterupload" => $newfileNew, "cdn_enabled" => $cdn_enabled))->lastInsertId();
                if($afrows){
                    if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                      $imagepath =  realpath(__DIR__ . '/..')."/products/".$newfileNew;
                    } else {
                      $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$newfileNew;
                    }
                    moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$newfileNew);

                    $resarray[] = $afrows;
                }
        }
    }
}*/
//echopre1($resarray);

        //*************************************Multicart3.0 Scalability Modifications*******************************************
        // Save product default option values to product  table
if (getSettingsValue('enable_scalability_settings') == 'Y') {
    $objDefaultOptionVo = new stdClass();
    $objOptionVo = Products::getProduct_Default_Option_Values($productid);
    $objDefaultOptionVo->default_image_small = $objOptionVo->image_small;
    $objDefaultOptionVo->default_stock = $objOptionVo->product_stock;
    $objDefaultOptionVo->default_additional_price = $objOptionVo->additional_price;
    $objDefaultOptionVo->default_shipping_weight = $objOptionVo->product_shipping_weight;
    $objDefaultOptionVo->default_discount = $objOptionVo->discount;
    $objDefaultOptionVo->default_discount_description = $objOptionVo->discount_description;
    $objDefaultOptionVo->default_option_id = $objOptionVo->product_option_id;
    $objDefaultOptionVo->product_id = $productid;

            // Save default option values to product table
    $productinfoUpdate = Products::updateProduct_Default_Option_Value($objDefaultOptionVo);
}
        //**Multicart3.0 Scalability Modifications End ***//

        //** Manu R S 29/11/17 */ check later to check 
        //** -----------Digital Product Block Starts----------------- */
/*        $digital_product_upload = 0;
        $digitalproductname = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $_FILES['txtProductZip']['name']);
        $digitalproductname = trim(str_replace(' ', '_', $digitalproductname));
        $assignedname = randomDigitalProduct() . "_" . $digitalproductname;

        if (@file_exists("../digital_product/" . $assignedname)) {
            $message .= PLEASE_RENAME." " . "<br>";
        }

        if ($txtDigitalProduct == "Y" && $_FILES['txtProductZip']['size'] > $maximagesizeinPHP) {
            $message.= FILE_SIZE_EXCEEDS." $maximagesizestringinPHP. <br>";
        }

        if ($txtDigitalProduct == "Y" && $message == '') {

            if (move_uploaded_file($_FILES['txtProductZip']['tmp_name'], "../digital_product/" . $assignedname)) {
                $digital_product_upload = 1;
                chmod("../digital_product/$assignedname", 0777);
            } else {
                $message .= COULDNT_UPLOAD." " . "<br>";
            }
        }*/


     /*   if ($txtDigitalProduct == 'Y') {
            $txtDownloadTry = $_POST['txtDownloadTry'];
            $txtDownloadExpiry = $_POST['txtDownloadExpiry'];
            $data = array(
                        "ndigital_productid" => $productid,
                        "vdigital_product_name" => GetSQLValueString($assignedname, "text"),
                        "ndownload_try" => $txtDownloadTry,
                        "ndownload_expiry_days" => $txtDownloadExpiry
                        );
            /*$insert_digital_product = "INSERT INTO " . $tableprefix . "digital_product(ndigital_productid,
                vdigital_product_name,
                ndownload_try,
                ndownload_expiry_days)VALUES(" . $productid . ","
                                    . GetSQLValueString($assignedname, "text") . ",
                                    " . $txtDownloadTry . ",
                                    '" . $txtDownloadExpiry . "')";
                $pdo->pdoQuery($insert_digital_product);*
            $digital_product_insert_id = $pdo->insert($tableprefix."digital_product",$data)->lastInsertId();

            /*$data = array(
                        "ndownload_try" => $txtDownloadTry,
                        "ndownload_expiry_days" => $txtDownloadExpiry
                        );
            $rs_digital_product = $pdo->update($tableprefix.'digital_product', $data, array("ndigital_productid" => $productid, "ndigital_orderid" => '0'))->affectedRows();*
        } */

        //echopre1($_POST);

        if ($_FILES['txtProductZip']['name'] != '' && $message == "") {

            $digitalproductname = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $_FILES['txtProductZip']['name']);
            $digitalproductname = trim(str_replace(' ', '_', $digitalproductname));

            $assignedname = randomDigitalProduct() . "_" . $digitalproductname;

            if (move_uploaded_file($_FILES['txtProductZip']['tmp_name'], "../digital_product/" . $assignedname)) {

                chmod("../digital_product/$assignedname", 0777);

                $update_digital_product = "UPDATE " . $tableprefix . "digital_product
                SET vdigital_product_name = :assignedname
                WHERE ndigital_productid = :productid ";

                $pdo->pdoQuery($update_digital_product, array("assignedname" => $assignedname, "productid" => $productid))->results();

                @unlink("../digital_product/" . $_POST['digital_image_buffer']);
            } 
        } else {
            //echopre($_POST['digital_image_buffer']);
            $file = $_POST['digital_image_buffer'];
            if($file){
                $ddir_dest = '../digital_product';
                $dfile = preg_replace("/^[^a-z0-9.-]?(.*?)[^a-z0-9]?$/i", "$1", $file);
                $dfile = trim(str_replace(' ', '', $dfile));
                $dfile = randomDigitalProduct() . "_" . $dfile;
                $dfile = trim(str_replace('_', '', $dfile));

                $oldfile = $ddir_dest.'/'.$file;
                $rand = mt_rand(10,99);
                $newfile = $ddir_dest.'/'.$rand.$dfile;
                $newfileNew = $rand.$dfile;
                if (copy($oldfile, $newfile)) {
                    chmod("../digital_product/$newfileNew", 0777);
                    $txtDownloadTry = $_POST['txtDownloadTry'];
                    $txtDownloadExpiry = $_POST['txtDownloadExpiry'];
                    $data = array(
                        "ndigital_productid" => $productid,
                        "vdigital_product_name" => $newfileNew,
                        "ndownload_try" => $txtDownloadTry,
                        "ndownload_expiry_days" => $txtDownloadExpiry
                        );
                    $digital_product_insert_id = $pdo->insert($tableprefix."digital_product",$data)->lastInsertId();

                        //echopre1($digital_product_insert_id);
                }
            } /*else {
                $message .= COULDNT_UPLOAD . " " . "<br>";
            }*/
        }
        //echopre1($_POST);
        //** Manu R S 29/11/17 */
        //** -----------Digital Product Block Ends----------------- */


        /*
         * Update Product more images By Binu Chandran.E
         */
        $moreFiles = array();
        foreach ($_FILES['productMoreImage'] as $k => $l) {
            foreach ($l as $j => $v) {
                if (!array_key_exists($j, $moreFiles)) {
                    $moreFiles[$j] = array();
                }
                $moreFiles[$j][$k] = $v;
            }
        }
///////////////////////////Manu R S - 20/12/17 More image duplication starts
//echopre1($moreFiles);
        $productMoreImageName = $_POST['productMoreImageName'];
        foreach ($moreFiles as $key => $value) {
            if($value['name']==''){
        //echopre($value['name']); //echopre($moreFiles); //echopre($key);
        //echopre1($productMoreImageName[$key]);
                $file = $productMoreImageName[$key];
                if($file){
                    $oldfile = $dir_dest.'/'.$file;
                    $thumboldfile = $dir_dest.'/thumb_'.$file;
                    $rand = mt_rand();
                    $newfile = $dir_dest.'/'.$rand.'_'.$file;
                    $newthumbfile = $dir_dest.'/thumb_'.$rand.'_'.$file;
                    $newfileNew = $rand.'_'.$file;
                    if (copy($oldfile, $newfile)) {
                        copy($thumboldfile, $newthumbfile);
                        $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                        SET nimage_productid = :productid,
                        vimage_name= :moreImageNameAfterupload,
                        vproduct_image_delete_status  ='N',
                        cdn_images_moved = :cdn_enabled";
                        $afrows = $pdo->pdoQuery($insertMImageQuery, array("productid" => $productid, "moreImageNameAfterupload" => $newfileNew, "cdn_enabled" => $cdn_enabled))->lastInsertId();
                        if($afrows){
                            if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                              $imagepath =  realpath(__DIR__ . '/..')."/products/".$newfileNew;
                          } else {
                              $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$newfileNew;
                          }
                          moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$newfileNew);
                          $resarray[] = $afrows;
                      }
                  }
              } else { /*echopre1($resarray);*/ }
          }
      }
///////////////////////////Manu R S - 20/12/17 More image duplication ends


      $dir_dest = "../products";

      for ($x = 0; $x < count($moreFiles); $x++) {
        $moreImageName = ReplaceArrayImage($moreFiles[$x]['name']);
        if ($moreImageName != "") {
            /*                 * ******** Image resizing maintaining aspect ratio begin********** */

            $moreImageName = "productmore_" . $x . time() . $moreImageName;
            $moreImageName_Upload = substr($moreImageName, 0, strrpos($moreImageName, '.'));
            $handle = new Upload($moreFiles[$x]);
            if ($handle->uploaded) {

                $handle->image_resize = true;
                $handle->image_x = 489;
                $handle->image_y = 328;
                $handle->image_ratio = true;
                $handle->file_new_name_body = $moreImageName_Upload;
                $handle->Process($dir_dest);
                $moreImageNameAfterupload = $handle->file_dst_name;

                    // $moreimagepath = "../products/" . $moreImageNameAfterupload;
                    // moveImageToCDN($moreimagepath, 'products/' . $moreImageNameAfterupload);
                if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                  $imagepath =  realpath(__DIR__ . '/..')."/products/".$moreImageNameAfterupload;
              }
              else{
                  $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$moreImageNameAfterupload;

              }
              moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$moreImageNameAfterupload);

                    // Save More Image Thubnail to thumb folder
              $more_thumb_file_name = "thumb_" . $moreImageName_Upload;
              $handle->file_new_name_body = $more_thumb_file_name;
              $handle->image_resize = true;
              $handle->image_x = 82;
              $handle->image_y = 79;
              $handle->image_ratio = true;
              $handle->process($dir_dest);
              $more_thumb_file_name_after_upload = $handle->file_dst_name;
                    // $imagethubpath = "../products/" . $more_thumb_file_name_after_upload;
                    // moveImageToCDN($imagethubpath,'products/'.$more_thumb_file_name_after_upload);
              if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                  $imagepath =  realpath(__DIR__ . '/..')."/products/".$more_thumb_file_name_after_upload;
              }
              else{
                  $imagepath =  realpath(dirname(__FILE__) . '/..')."/products/".$more_thumb_file_name_after_upload;

              }
              moveImageToCDN($imagepath,AMAZON_S3_FOLDER.'/products/'.$more_thumb_file_name_after_upload);

                    //$alreadyAddedID = isset($_POST['productMoreImageID'][$x]) ? ($_POST['productMoreImageID'][$x]) : 0;
                    //$alreadyAddedImage = isset($_POST['productMoreImageName'][$x]) ? ($_POST['productMoreImageName'][$x]) : 0;

                    /*if ($alreadyAddedID > 0) {
                        $updateMImageQuery = "UPDATE " . $tableprefix . "product_view_images
                                                                  SET vimage_name = :moreImageNameAfterupload,
                                                                       cdn_images_moved = :cdn_enabled
                                                                      WHERE nproduct_image_id = :alreadyAddedID";
                        $pdo->pdoQuery($updateMImageQuery, array("moreImageNameAfterupload" => $moreImageNameAfterupload, "cdn_enabled" => $cdn_enabled, "alreadyAddedID" => $alreadyAddedID))->results();
                        if (is_file("../products" . $alreadyAddedImage) && file_exists("../products" . $alreadyAddedImage)) {
                            unlink("../products" . $alreadyAddedImage);
                        }
                    } else {*/
                        $insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                        SET nimage_productid = :productid,
                        vimage_name= :moreImageNameAfterupload,
                        vproduct_image_delete_status  ='N',
                        cdn_images_moved = :cdn_enabled";

/*$insertMImageQuery = "INSERT INTO " . $tableprefix . "product_view_images
                SET nimage_productid = :product_insert_id,
                vimage_name= :moreImageName,
                vproduct_image_delete_status  ='N',
                cdn_images_moved = :cdn_enabled";*/

                $pdo->pdoQuery($insertMImageQuery, array("productid" => $productid, "moreImageNameAfterupload" => $moreImageNameAfterupload, "cdn_enabled" => $cdn_enabled));

                /*$pdo->pdoQuery($insertMImageQuery, array("product_insert_id" => $product_insert_id, "moreImageName" => $moreImageName, "cdn_enabled" => $cdn_enabled));*/
                /*}*/
            }
        }
    }
    if ($message == '') {
        $message = CHANGES_SAVED_SUCCESSFULLY . "<br>";
    }
    if ($_POST["from"] == "list") {
        header("Location:listProducts.php?message=" . $message);
        exit;
    } else {

        header("Location:catalog.php?catid=" . $ddlCategory . "&message=" . $message);
        exit;
    }
}
} else if ($_POST["btnDelete"] == "Delete") {
    $sql = "DELETE FROM  " . $tableprefix . "products
    WHERE product_id = :productid";
    $pdo->pdoQuery($sql, array("productid" => $productid))->results();

    $select_product_images = "SELECT p.image_small,p.image_big
    FROM " . $tableprefix . "product_options p WHERE p.product_id = :productid";

    $result_product_images = $pdo->pdoQuery($select_product_images, array("productid" => $productid))->results();


    if (count($result_product_images) > 0) {
        foreach ($result_product_images as $product_images_row) {

            $imagesmall_thumb = $product_images_row['image_small'];

            $imagelarge_thumb = $product_images_row['image_big'];

            @unlink("../products/" . $imagesmall_thumb);
            @unlink("../products/" . $imagelarge_thumb);



            /* -------Category count update patch------------ */
        }
    }
    $sql_options = "DELETE FROM " . $tableprefix . "product_options WHERE product_id = :productid ";
    $del_options = $pdo->pdoQuery($sql_options, array("productid" => $productid))->results();
    $select_product_images_more = "SELECT im.vimage_name
    FROM " . $tableprefix . "product_view_images im  WHERE im.nimage_productid = :productid";
    $rs_product_image_more = $pdo->pdoQuery($select_product_images_more, array("productid" => $productid))->results();

    if (count($rs_product_image_more) > 0) {

        foreach ($rs_product_image_more as $prows) {
            $moreimage = $prows['vimage_name'];

            $moreimage_thumb = "thumb_" . $prows['vimage_name'];

            @unlink("../products/bulk_images/" . $moreimage);

            @unlink("../products/bulk_images/" . $moreimage_thumb);
        }
    }
    $sql_product_images_more = "DELETE FROM " . $tableprefix . "product_view_images WHERE nimage_productid = :productid ";
    $del_product_images_more = $pdo->pdoQuery($sql_product_images_more, array("productid" => $productid))->results();


    header("Location:catalog.php?catid=$ddlCategory");
    exit;
}

$catlist = make_selectlist(0, 0);
$artistlist = makeArtistList();

$sql = "SELECT * FROM " . $tableprefix . "products WHERE product_id= :productid ";
$result = $pdo->pdoQuery($sql, array("productid" => $productid))->results();
if (count($result) != 0) {
    $row = ($result[0]);
    $txtProductName = $row["product_name"];
    $txtProductCode = $row["product_code"];
    $txtDescription = $row["product_description"];
    $txtPrice = $row["product_price"];
    $ddlCategory = $row["product_category"];
    $sectionCat = $row["product_section"];
    $sectionCat = explode(",",$sectionCat);
    $ddlArtist = $row["product_artist_id"];
    $oldcategory = $ddlCategory;
    $txtSearchTags = $row["product_tags"];
    $chkAllowFreeShipping = $row["allow_free_shipping"];
    $chkAllowSubscription = $row["allow_subscription"];
    $rdSubscriptionMode = $row["subscription_mode"];
    $rdPublishStatus = $row["publish_status"];
    if ($rdPublishStatus == "N" || $rdPublishStatus == '') {
        //published time in 24_hour_format
        $publishDate = $row["publish_scheduled_date"];
        $publishTime = date('h:i a', strtotime($publishDate));

        $publishDate = date('m-d-Y', strtotime($publishDate));
    } else {
        $publishDate = "";
        $publishTime = "";
    }


    /* -------Product shipping weight starts------ */

    $txtShippingWeight = $row["nproduct_shipping_weight"];

    /* -------Product shipping weight ends------ */

    /* -----------Digital Product Block Starts----------------- */

    if ($row["vdigital_product"] == "Y") {
        $digital_product_display = "";

        $canshipblock = "none";

        $shipping_product_display = "none";


        $select_digital_product_zip = "SELECT vdigital_product_name,ndownload_expiry_days,ndownload_try FROM " . $tableprefix . "digital_product
        WHERE ndigital_productid = :product_id ";
        $result_digital_product_zip = $pdo->pdoQuery($select_digital_product_zip, array("product_id" => $row["product_id"]))->results();

        if (count($result_digital_product_zip) > 0) {

            $digital_product_zip_row = ($result_digital_product_zip[0]);
            $digital_product_display = $digital_product_zip_row["vdigital_product_name"];
        }
    } else {
        $digital_product_display = "none";
        $canshipblock = "";
    }

    /* -----------Digital Product Block Ends----------------- */
}
if ($imgsmall == '') {
    $imgsmall = 'noimage.jpg';
}

if ($imgbig == '') {
    $imgbig = 'noimage.jpg';
}

include "../includes/htmltop1.php";

$sectionlist = makeSectionList($ddlCategory);

/// Vacation Mode settings
$sellerObj = Store::get_seller_account_info($ddlArtist);
$seller_vacation_mode = 'N';
if ($sellerObj->status == SUCCESS) {
    $sellerObjVal = $sellerObj->data;
    $seller_vacation_mode = $sellerObjVal->is_vacation_mode;
}


$queryOtherOption = "SELECT * FROM " . $tableprefix . "product_options WHERE product_id = :productid AND default_option != 'YES'";
$otherOptionQ = $pdo->pdoQuery($queryOtherOption, array("productid" => $productid))->results();
//echopre(sizeof($otherOptionQ));
//echopre(count($_POST['additional_price']));
$sizeOfOptions = sizeof($otherOptionQ);
?>
<!-- <link rel="stylesheet" href="<?php echo $site_url; ?>/style/jquery-ui.css"> -->
<script src="<?php echo $site_url; ?>/js/jquery-1.11.2.js"></script>
<!-- <script src="<?php echo $site_url; ?>/js/jquery-ui.js"></script> -->
<link href="<?php echo $site_url; ?>/style/jquery.timepicker.css" rel="stylesheet" type="text/css">
<link href="<?php echo $site_url; ?>/style/jquerysctipttop.css" rel="stylesheet" type="text/css">

<!-- CSS Stylesheet -->

<style type="text/css">
    .brd_pc_stls .mn_pcs{
        margin:0 0 2px 0;
        border:5px solid #DEDEB5;
    }
</style>
<?php
$variantNameSql = "SELECT option_name FROM " . $tableprefix . "options";
$variantNameSqlRes = $pdo->pdoQuery($variantNameSql,'')->results();
foreach ($variantNameSqlRes as $key => $value) {
    $variantsArray[] = strtolower($value['option_name']);
}
?>
<script type="text/javascript">

    var SiteUrlName = '<?php echo SITE_URL;?>';

    var variants =  <?php echo json_encode($variantsArray); ?>;

    function confirmDelete() {
        if (confirm("<?php echo ARE_YOU_SURE_DELETE_RECORD; ?>")) {
            return true;
        }
        return false;
    }

    function openWindow(id)
    {
        var url = "../viewimage.php?id=" + id;
        window.open(url, "Image", "height=500,width=500,scrollbars=yes");
    }
    function checkDigitalProduct()
    {

        if (document.frmProductDetails.txtDigitalProduct.checked == true)
        {
            document.getElementById("digitalProductBlock").style.display = "";
            $(".canshipBlock").hide();
        }
        else
        {
            document.getElementById("digitalProductBlock").style.display = "none";
            $(".canshipBlock").show();
        }
    }

    function deleteVariantsOptionCancel() {
        $('#failedMessager').hide();
        $('#deletedMessager').hide();
        $('#messager').fadeOut('slow');
    }

    $(document).on('click', '.jqVariantsOptionDeleteCheck', function() {
    //function checkDeleteVariantsOption() {
        var optionid = $(this).parents().attr('id');
        //$('.class'+optionid).remove();
        ///////////////////////Ajax variants delete check/////////////
        $.blockUI({ message: null });
        $.ajax({url: 'editproduct.php?action=checkDelvariantsOption',
            data: {id: optionid},
            type: 'post',
            dataType: 'json',
            success: function (reply) {
                if (reply)
                {
                    if (reply.success){
                        var optid = 'option_'+reply.success;
                        $('.jqVariantsOptionDelete').attr('id',optid);
                        $('.jqVariantsOptionName').text(reply.optionName);
                        $("html, body").animate({ scrollTop: 0 }, 1000);
                        $('#messager').show();
                        $('#failedMessager').hide();
                        $('#deletedMessager').hide();
                            //$('#messager').delay(5000).fadeOut('slow');
                        } else if(reply.failed){
                            $("html, body").animate({ scrollTop: 0 }, 1000);
                            $('#failedMessager').show().html(reply.failed);
                            $('#messager').hide();
                            $('#deletedMessager').hide();
                            //$('#messager').delay(5000).fadeOut('slow');
                        }
                    }
                }
            });
        ///////////////////////Ajax variants delete check/////////////
    });

    function deleteVariantsOption() {
        var optionid = $(this).attr('id');
        $('.class'+optionid).remove();
        ///////////////////////Ajax variants delete/////////////
        $.blockUI({ message: null });
        $.ajax({url: 'editproduct.php?action=delvariantsOption',
            data: {id: optionid},
            type: 'post',
            dataType: 'json',
            success: function (reply) {
                if (reply)
                {
                    if (reply.success){
                        $("html, body").animate({ scrollTop: 0 }, 1000);
                        $('#deletedMessager').show();
                        $('#messager').hide();
                        $('#failedMessager').hide();
                        var index = variants.indexOf(reply.optionName);
                        variants.splice(index, 1);
                    } else if(reply.failed){
                        $("html, body").animate({ scrollTop: 0 }, 1000);
                        $('#failedMessager').show().html(reply.failed);
                        $('#messager').hide();
                        $('#deletedMessager').hide();
                    }
                }
            }
        });
        ///////////////////////Ajax variants delete/////////////
    }

    function deleteMoreImage()
    {
        if (confirm('<?php echo DEL_IMG_CONFIRM; ?>'))
        {
            var id = $(this).parents('.jqMoreImageContainer').find('.jqMoreImageID').val();
            var image = $(this).parents('.jqMoreImageContainer').find('.jqMoreImageName').val();
            var delLink = $(this);

            $.ajax({url: 'editproduct.php?action=delmoreimage',
                data: {id: id, image: image},
                type: 'post',
                dataType: 'json',
                success: function (reply) {
                    if (reply)
                    {
                        if (reply.success)
                        {
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageZoom').remove();
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImage').remove();
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageDelete').remove();
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageID').val('');
                            $(delLink).parents('.jqMoreImageContainer').find('.jqMoreImageName').val('');
                        }
                    }
                }
            });
        }
    }
</script>
<script type="text/javascript" src="<?php echo SITE_URL ?>/js/blockUI.js"></script>
<script type="text/javascript" src="<?php echo SITE_URL ?>/ckeditor/ckeditor.js"></script>
<?php
$options_arr = getOptionsFromCategory($ddlCategory);
$num_of_options = count($options_arr);
$StrOptions = "";
if ($num_of_options != "") {
    foreach ($options_arr AS $eachoption) {
        $StrOptions .='<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label>' . $eachoption['option_name'] .'</label>';
        $StrOptions .='<input type="text" name="option_' . $eachoption['option_id'] . '[]" value="" class="form-control"></div>';
    }
}
?>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL ?>/js/jquery.timepicker.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL ?>/js/dateselector.js"></script>
<script language="JavaScript" type="text/JavaScript" src="<?php echo SITE_URL ?>/js/dateselector.min.js"></script>
<link rel="stylesheet" href="<?php echo SITE_URL ?>/style/thickbox.css" type="text/css" media="screen" />
<script type="text/javascript" src="<?php echo SITE_URL ?>/js/thickbox.js"></script>
<script src="../js/product-check.js"  type="text/javascript"></script>
<script type="text/javascript">
    $(document).ajaxStop($.unblockUI);
    window.onload = function ()
    {
        var editor = CKEDITOR.replace('editor1'
            , {
                filebrowserBrowseUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html',
                filebrowserImageBrowseUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Images',
                filebrowserFlashBrowseUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/ckfinder.html?type=Flash',
                filebrowserUploadUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                filebrowserImageUploadUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                filebrowserFlashUploadUrl: '<?php echo SITE_URL ?>/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'
            });
        CKFinder.setupCKEditor(editor, '<?php echo SITE_URL ?>/ckeditor/ckfinder/');
    };
    $(document).ready(function () {

        $('#primery_btt_tab_1').click(function(e){
            e.preventDefault();
            if(!validateProductForm(1,'e','d'))
                return false;
            $("#ui-id-2").trigger('click');
        });

        $('#primery_btt_tab_2').click(function(e){
            e.preventDefault();
            $("#ui-id-3").trigger('click');
        });

        var myFuncCalls = 0;

        var ProductCategory = '<?php echo $ddlCategory;?>';

        $("#txtCategory").val(ProductCategory);


        $('#txtPrice').keyup(function (e) {
            var price = parseFloat($('#txtPrice').val());
            var newVal = $('#txtPrice').val().replace(/[^\d.]/, '');
            var number = (newVal.split('.'));
            $('#txtPrice').val(newVal);
            if (typeof (number[1]) != "undefined") {
                if (number[1].length > 2)
                {
                    $("#txtPrice").val(price.toFixed(2));
                }
            }

        });
        $('.jqPrice').keyup(function (e) {
            var price = parseFloat($(this).val());
            var newVal = $(this).val().replace(/[^\d.]/, '');
            var number = (newVal.split('.'));
            $(this).val(newVal);
            if (typeof (number[1]) != "undefined") {
                if (number[1].length > 2)
                {
                    $(this).val(price.toFixed(2));
                }
            }

        });

        $(".jqMoreImageDelete").click(deleteMoreImage);
        //$(".jqVariantsOptionDeleteCheck").click(checkDeleteVariantsOption);
        $(".jqVariantsOptionDelete").click(deleteVariantsOption);
        $(".jqVariantsOptionDeleteCancel").click(deleteVariantsOptionCancel);


        $("#add_more_options").click(function () {
            myFuncCalls++;
            var addVal = $("#add_value").val();
            var catid_val = '<?php echo $ddlCategory; ?>';
            $("#add_value").val(parseInt(addVal)+1);
            var block = '<div class="variant_detail_outer option_block"><div class="variant_detail_top_outer"><div class="col-xs-12 col-sm-5 col-md-4 col-lg-6"><h1>Variants</h1></div><div class="col-xs-12 col-sm-7 col-md-8 col-lg-6"><div class="variants_top_btt_outer"><span class="variants_default_show_btt"><input type="radio" name="default" id="default" onclick="setDefaultOption(this);"> &nbsp<?php echo DEFAULT_OPT; ?></span><input type="hidden" name="product_option_id[]" value=""><input type="hidden" class="default_option" name="default_option[]" id="default_option[]" value=""><button type="button" class="delete_btt pull-left" onclick="javascript:delete_option(this);"><i class="fa fa-trash-o" aria-hidden="true"></i></button></div></div><div class="clearfix"></div><div class="default_setting_box" id="default_setting_box_ID_'+myFuncCalls+'"><div class="clearfix">&nbsp;</div><?php //echo $StrOptions ?></div><div class="clearfix"></div></div><div class="clearfix"></div><div class="variant_detail_bottom_outer "><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo ADD_PRICE; ?> (<?php echo $adminCurrency['currency_code']; ?>)</label><input type="text" name="additional_price[]" id="additional_price[]" onpaste="return false;" value="" class="jqPrice jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></label><input type="text" name="product_stock[]" id="product_stock[]" class="jQNumeric form-control" value=""></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo REORDER_LEVEL; ?></label><input type="text" name="reorder_level[]" id="reorder_level[]" class="jQNumeric form-control" value=""></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo DISCOUNT_PERC; ?></label><input type="text" name="discount[]" id="discount[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo DISCOUNT_DESC; ?></label><input type="text" name="discount_description[]" id="discount_description[]" value="" class="form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><div class="canshipBlock"><label><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></label><input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="" class="jQNumeric form-control"></div></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo LENGTH; ?></label><input type="text" name="product_length[]" id="product_length[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo WIDTH; ?></label><input type="text" name="product_width[]" id="product_width[]" value="" class="form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo HEIGHT; ?></label><input type="text" name="product_height[]" id="product_height[]" value="" class="jQNumeric form-control"></div><div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo BIG_IMG; ?>&nbsp;<span class="required">*</span></label><label class="btn-bs-file btn btn-lg btn-info upload_image">Choose File<input type="file" name="image_big[]" id="image_big_'+addVal+'" onchange="showBigImages(this.files,' + addVal + ',this);" value=""></label><img name="bigimagepreview[]" style="display:none" width="183" height="auto" id="big_img_preview_' + addVal + '"></div></div><div class="clearfix"></div></div>';

            /*<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30"><label><?php echo SMALL_IMG; ?></label><label class="btn-bs-file btn btn-lg btn-info upload_image">Choose File<input type="file" name="image_small[]" id="image_small_'+addVal+'" onchange="showSmallImages(this.files,' + addVal + ',this);" value=""></label><img src="" style="display:none" width="183" height="auto" id="small_img_preview_' + addVal + '"></div><div class="clearfix"></div>*/

            $("#options_window").append(block);
            // Manu R S 12/08/17 S
            var dataString = {categoryid:catid_val};
            $.ajax({
                url     : "<?php echo SITE_URL?>/getStrOptionsAjax.php",
                type        : "POST",
                data        : dataString,
                dataType        : "json",
                success: function(data) {
            //$("#options_window").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
            //$("#navcontainer ul").append('<li><a href="#">'+variantname+'</a></li>&nbsp;');
            ///////////////////MANU////////////////////////
            //alert(data.length);
            var divid = "#default_setting_box_ID_"+myFuncCalls;
            for (var i = 0; i < data.length; i++) {
                $(divid).append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data[i]['option_id']+'"><label><span class="category_option_label">'+ data[i]['option_name'] +'</span></label><span class="category_option_field"><input name="option_'+data[i]['option_id']+'[]" value="" type="text" class="form-control"></span></div>');
            }  }});
            //  $("#options_window").append(  $( "#default_setting_box_ID" )   );
            // Manu R S 12/08/17 E
            $('.jqPrice').keyup(function (e) {
                var price = parseFloat($(this).val());
                var newVal = $(this).val().replace(/[^\d.]/, '');
                var number = (newVal.split('.'));
                $(this).val(newVal);
                if (typeof (number[1]) != "undefined") {
                    if (number[1].length > 2)
                    {
                        $(this).val(price.toFixed(2));
                    }
                }

            });
            checkDigitalProduct();
        });

$('.rdPublishStatus').click(function () {

    if ($('input[name=rdPublishStatus]:checked').val() == "N") {
        $("#publish_time").show();
    } else if ($('input[name=rdPublishStatus]:checked').val() == "Y") {
        $("#publish_time").hide();
    }

});


        //Datepicker
        //var dateToday = "<?php echo $publishDate; ?>";
        <?php if ($publishDate != '') { ?>
            var dateToday = "<?php echo $publishDate; ?>";
            <?php } else { ?>
                var dateToday = new Date(Date.now());
                <?php } ?>

                $("#publishdate").datepicker({
                    dateFormat: 'mm-dd-yy',
                    minDate: dateToday
                }).datepicker('setDate', dateToday)

                $('#chkAllowSubscription').click(function (e) {
                    if ($('input[name=chkAllowSubscription]:checked').val()) {
                        $('#subscription_mode').show();
                    } else {
                        $('#subscription_mode').hide();
                    }
                });
        //$(".thickbox").thickbox();

        $("#publishtime").timepicker();
        $('#publishtime').on('changeTime', function () {
            $('#publishtimeval').val($(this).val());
        });

/////js variants

$('#jQAddOpt').click(function(){
    $('#jQOptDiv').toggle();
});

/*variants =  <?php echo json_encode($variantsArray); ?>;*/

$('#btnAddVariant').click(function(){

    var catid = '<?php echo $ddlCategory; ?>';
    var oc = '<?php echo $sizeOfOptions; ?>';

    var variantname = $('#txtNewOption').val();
    var variantname = variantname.toLowerCase();
    //console.log(JSON.stringify(variants));

    if(variantname=="") {
        alert("Enter variant name");
        $('#txtNewOption').focus();
    } else {
        if ($.inArray(variantname, variants) != -1) {
            alert("Variant name already exists");
            return false;
        } else {

            variants.push(variantname);
            $.blockUI({ message: null });
            var dataString = {variantname:variantname,categoryid:catid};
            $.ajax({
                url     : "<?php echo SITE_URL?>/addProductVariantsAjax.php",
                type        : "POST",
                data        : dataString,
                dataType        : "json",
                success: function(data) {
                    /*$("#navcontainer ul").append('<li><span id='+data['optionid']+'>'+variantname+'</span></li>&nbsp;');*/
                    $("#navcontainer ul").append('<li class="classoption_'+data['optionid']+'" id="option_'+data['optionid']+'">'+variantname+'<a href="javascript:;" class="jqVariantsOptionDeleteCheck"><i class="fa fa-times" aria-hidden="true" title="delete this variant"></i></a></li>&nbsp;');
///////////////////MANU-Dynamic variants STARTs////////////////////////
$("#default_setting_box_ID").append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data['optionid']+'"><label><span class="category_option_label">'+ variantname +'</span></label><span class="category_option_field"><input name="option_'+data['optionid']+'[]" value="" type="text" class="form-control"></span></div>');

for (var i = 1; i <= myFuncCalls; i++) {
    $("#default_setting_box_ID_"+i).append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data['optionid']+'"><label><span class="category_option_label">'+ variantname +'</span></label><span class="category_option_field"><input name="option_'+data['optionid']+'[]" value="" type="text" class="form-control"></span></div>');
}

for (var i = 1; i <= oc; i++) {
    $("#default_setting_box_ID_"+i+"_"+i).append('<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_'+data['optionid']+'"><label><span class="category_option_label">'+ variantname +'</span></label><span class="category_option_field"><input name="option_'+data['optionid']+'[]" value="" type="text" class="form-control"></span></div>');
}
////////////////////MANU-Dynamic variants ENDs///////////////////////
                // $("#jqVariants > tbody").append("<tr><td>"+ variantname+"</td></tr>");

                // if(data.flag=='1')
                // {
                //     alert(data.message);
                //     return false;
                // }else{

                // }

                       // var flag =data.flag;
                         /*  if(flag=='Y')
                          {
                                $("#publish_time").show();
                                $("#jQPublishY").hide();
                                $('#jQPublish_N').prop('checked', true);

                         }else{

                                  $("#jQPublishY").show();
                                  $("#publish_time").hide();
                                  $('#jQPublish_Y').prop('checked', true);
                              }*/
                          }

                      });

        }
    }
});
/////js variants ends
});

function checkOptionsSame(categoryId,existCategory) {
    var Site_Url = '<?php echo SITE_URL;?>';
    var dataString = 'catID='+ categoryId +"&existCagoryId="+existCategory;
    $.blockUI({ message: null });
    $.ajax({
        type: "POST",
        url: Site_Url+"/getCategoryOptionsProduct.php",
        data: dataString,
        dataType: 'json',
        cache: true,
        success: function(response)
        {
            if(response.status=='1')
            {
                alert(INVALID_CATEGORY_OPTIONS);
                $("#txtCategory").val(existCategory);
                getCategorySection(existCategory);
            } else {
                getCategorySection(categoryId);
            }
        }
    });
}


    /*function checkProName(categoryId,existCategory) {
        var Site_Url = '<?php echo SITE_URL;?>';
        var dataString = 'catID='+ categoryId +"&existCagoryId="+existCategory;
        $.blockUI({ message: null });
            $.ajax({
            type: "POST",
            url: Site_Url+"/checkProName.php",
            data: dataString,
            dataType: 'json',
            cache: true,
            success: function(response)
            {
                if(response.status=='1')
                {
                    alert(INVALID_CATEGORY_OPTIONS);
                    $("#txtCategory").val(existCategory);
                    getCategorySection(existCategory);
                } else {
                    getCategorySection(categoryId);
                }
            }
            });
        }*/


        function getCategorySection(categoryId) {
            var Site_Url = '<?php echo SITE_URL;?>';
            var dataString = 'catID='+ categoryId;

            $.ajax({
                type: "POST",
                url: Site_Url+"/getCategorySectionAjax.php",
                data: dataString,
                dataType: 'json',
                cache: true,
                success: function(response)
                {
                    if(response)
                    {
                        $("#categorySectionChooser").html(response);
                    } else {
                        $("#categorySectionChooser").html('--<font color="#0192c3"> Section not linked to Category </font>--');
                    }
                }
            });
        }

        function setDefaultOption(obj) {
            $(".default_option").val("");
        //$(obj).parents(".default_setting_box").find(".default_option").val("1");
        $(obj).parents(".variants_top_btt_outer").find(".default_option").val("1");
    }

    function delete_option(obj) {
        $(obj).parents(".option_block").hide("slow");
        $(obj).parents(".option_block").html("");
    }

    var _URL = window.URL || window.webkitURL;

    function showMyImage(files, imageId, dbImagePreview, fileInput) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;
        //alert(imageId);
        img.onload = function () {

            if(imageId == 'small_img_preview'){
                img_width = 200;
                img_height = 150;
            }
            else{

                img_width = 350;
                img_height = 245;
            }


            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                if(imageId == 'small_img_preview'){
                    $(".dbsmallimagepreview").hide();
                } else {
                    //$(".dbbigimagepreview").hide();
                }
                $(".jqMoreImagefromDb_" + dbImagePreview).remove();
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }


        }
        img.src = _URL.createObjectURL(file);
    }

    function showBigImages(files, value, fileInput ) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;

        img.onload = function () {

            img_width = 350;
            img_height = 245;

            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                $(".dbbigimagepreview").hide();
                var imageId = 'big_img_preview_' + value;
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }
        }
        img.src = _URL.createObjectURL(file);
    }

    function showSmallImages(files, value, fileInput) {
        var file = files[0];
        var img = new Image();
        var sizeKB = file.size / 1024;

        img.onload = function () {

            img_width = 200;
            img_height = 150;

            if (img.width < img_width) {

                warning_msg = "The image width should be " + img_width;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else if (img.height < img_height) {

                warning_msg = "The image height should be " + img_height;
                alert(warning_msg);
                fileInput.value = '';
                return false;

            }
            else {
                var imageType = /image.*/;
                $(".dbsmallimagepreview").hide();
                var imageId = 'small_img_preview_' + value;
                $("#" + imageId).show();
                var newimg = document.getElementById(imageId);
                newimg.file = file;
                var reader = new FileReader();
                reader.onload = (function (aImg) {
                    return function (e) {
                        aImg.src = e.target.result;
                    };
                })(newimg);
                reader.readAsDataURL(file);
            }
        }
        img.src = _URL.createObjectURL(file);
    }
</script>
<body>
    <div class="main_outer">
        <!--header area start -->
        <?php include_once("../includes/topheader_admin1.php"); ?>
        <!--header area end -->
        <div class="clearfix"></div>
        <?php /*/////////////////////////Contant Area Starts //Manu R S - 21/09/17 */?>
        <div class="contant_area">
           <?php include_once("../includes/admintopmenu1.php"); ?>
           <div class="right_main_cont_outer">
            <div class="right_main_cont_inner">
                <h1><?php echo EDIT_DUPLICATE_PRODUCT; ?></h1>
                <div align="center" class="text_information grey_tr"><?php echo $message;?></div>
                <br>
                <div class="clearfix"></div>
                <?php $shipping_Dimension_Required    =   checkShippingDimensionEnable(); ?>
                <input type="hidden" name="sellerid" id="clsSeller" value="<?php echo $artistid;?>">
                <input type="hidden" name="txtShippingDimension" id="clsShippingdimension" value="<?php echo $shipping_Dimension_Required;?>">


                <!-- <div class="bread_crumb_outer">
                    <ul>
                        <li><a href="#">Category</a></li>
                        <li><a href="#">Cloth</a></li>
                        <li><a href="#">Shirt</a></li>
                    </ul>
                </div>
                <div class="clearfix"></div> -->
                <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
                <!-- <link rel="stylesheet" href="/resources/demos/style.css"> -->
                <!-- <script src="https://code.jquery.com/jquery-1.12.4.js"></script> -->
                <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
                <script>
                  $( function() {
                      $( "#tabDiv" ).tabs();
                  } );
              </script>
              <div class="right_cont_inner" id="tabDiv">
                <div class="right_cont_inner_L">
                    <ul>
                        <li><a href="#tabs-1">Basic Info</a></li>
                        <li><a href="#tabs-2">Variants</a></li>
                        <li><a href="#tabs-3">Variant Details</a></li>
                    </ul>
                </div> <!-- right_cont_inner_L ends -->
                <div class="right_cont_inner_R">
                    <h1><?php echo DUPLICATE_COPYOF;?><?php echo $txtProductName; ?><div class="txt_R"><span class="warning">*</span> Mandatory Fields</div></h1>
                    <div class="clearfix"></div>
                    <div class="form_outer">
                      <div class="full_width">

                          <form name="frmProductDetails" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="productid" id="oldproductid" value="<?php echo $productid; ?>" >
                            <input type="hidden" name="oldcategory" value="<?php echo $oldcategory; ?>" >
                            <input type="hidden" name="txtCategory" id="txtCategoryID" value="<?php echo $ddlCategory ?>">
                            <input name="from" type="hidden" id="from" value="<?php echo $_GET["from"] ?>" >

                            <div id="tabs-1">
                             <div class="row">
                                <?php /*/////////////////////////Input Fields START //Manu R S - 20/09/17 */?>
                                <?php $optionCount = Products::getOptionsCount($productid);?>
                                <div class="col-xs-12 col-sm-6 padding_B_30">
                                 <label><?php echo SELECT_CATEGORY; ?> <span class="warning">*</span></label>

                                 <select name="txtCategory" class="form-control" id="txtCategory" onChange="checkOptionsSame(this.value,'<?php echo $ddlCategory;?>');">
                                    <?php getSelectBoxListDuplicate($ddlCategory); ?>
                                </select>
                            </div>

                            <div class="col-xs-12 col-sm-6 padding_B_30">
                             <label><?php echo PRODUCT_NAME; ?><span class="warning">*</span></label>
                             <input class="form-control" type="text" value="<?php echo Utils::html_entity($txtProductName); ?>" name="txtProductName" id="txtProductName" size="50" maxlength="100">
                         </div>

                         <div class="col-xs-12 col-sm-4 col-md-4 padding_B_30">
                             <label><?php echo PRODUCT_CODE; ?></label>
                             <input class="form-control" type="text" value="<?php echo stripslashes($txtProductCode); ?>" name="txtProductCode" id="txtProductCode" size="50" maxlength="100">
                         </div>

                         <div class="col-xs-12 col-sm-4 col-md-4 padding_B_30">
                             <label><?php echo SELLER; ?><span class="warning">*</span></label>
                             <?php
                             echo makeDropDownList("ddlArtist", $artistlist, $ddlArtist, false, "form-control", $properties, $behaviors);
                             ?>
                         </div>

                         <div class="col-xs-12 col-sm-4 col-md-4 padding_B_30 add_editproduct_price">
                             <label><?php echo PRICE; ?><span class="warning">*</span></label>
                             <input type="text" class="form-control"  onpaste="return false;" value="<?php echo Utils::html_entity($txtPrice); ?>" name="txtPrice" size="30" maxlength="100" id="txtPrice">
                             <span class="add_editproduct_price_inner"><?php echo $adminCurrency['currency_code']; ?></span>
                         </div>

                         <div class="col-xs-12 col-sm-6 col-md-6 padding_B_30">
                          <label><?php echo SECTION; ?><!-- <span class="warning">*</span> --></label>
                          <div id="categorySectionChooser">
                              <?php
    		//$sectionCat = array(2,3);
                              $behaviors = 'multiple';
                              if(sizeof($sectionlist)>0){
                                echo makeDropDownList("sectionCat[]", $sectionlist, $sectionCat, false, "form-control height_70", $properties, $behaviors, 'categorySectionList');
                            } else{
                                echo "--<font color='#0192c3'> Section not linked to Category </font>--";
                            }
                            $behaviors = '';
                            ?>
                        </div>
                    </div>

                    <div class="col-xs-12 col-sm-6 col-md-6 padding_B_30">
                     <label><?php echo TEXT_SEARCH_TAGS; ?>
                         <span class="help"><a href="#" title="<?php echo PROD_TAGS_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></label>
                         <textarea id="txtProductTags" name="txtProductTags" class="form-control height_70"><?php echo htmlentities($txtSearchTags); ?></textarea>
                     </div>


                     <div class="col-xs-12 col-sm-12 padding_B_30">
                         <label><?php echo DESCRIPTION; ?><span class="warning">*</span></label>
                         <textarea id="editor1" class="form-control" name="txtDescription"><?php echo Utils::html_entity($txtDescription); ?></textarea>
                     </div>

                     <div class="col-xs-12 col-sm-6 padding_B_30">
                         <label><?php echo TEXT_ALLOW_FREE_SHIPPING; ?>
                             <span class="help"><a href="#" title="<?php echo FREE_SHIPPING_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></label>
                             <input type="checkbox" id="chkAllowFreeShipping" name="chkAllowFreeShipping" <?php if ($chkAllowFreeShipping == "Y") {
                                echo "checked";
                            } ?>  value="Y" <?php echo $chkAllowFreeShipping; ?>>
                        </div>

										<!--<?php if (getSettingsValue('enable_subscription_products') == 'Y') { ?>
										<tr>
											<td align="right"><?php echo TEXT_ALLOW_SUBSCRIPTION; ?>&nbsp;</td>
											<td>:</td>
											<td align='left'><input type="checkbox" id="chkAllowSubscription"  name="chkAllowSubscription" <?php if ($chkAllowSubscription == "Y") {
												echo "checked";
												} ?> value="Y" <?php echo $chkAllowSubscription; ?>>
												<span class="help"><a href="#" title="<?php echo ALLOW_SUBSCRIPTION_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
											</td>
										</tr>
										<tr id="subscription_mode" <?php if ($chkAllowSubscription == "N") { ?> style="display: none;" <?php } ?>>
											<td align="right"><?php echo TEXT_SUBSCRIPTION_MODE; ?>&nbsp;</td>
											<td>:</td>
											<td align='left'>
												<input type="radio" name="rdSubscriptionMode" value="Daily" <?php if ($rdSubscriptionMode == "Daily") {
												echo "checked";
												} ?>><?php echo TEXT_DAILY; ?>
												<input type="radio" name="rdSubscriptionMode" value="Monthly" <?php if ($rdSubscriptionMode == "Monthly") {
												echo "checked";
												} ?>><?php echo TEXT_MONTHLY; ?>
												<input type="radio" name="rdSubscriptionMode" value="Yearly" <?php if ($rdSubscriptionMode == "Yearly") {
												echo "checked";
												} ?>><?php echo TEXT_YEARLY; ?>
												<span class="help"><a href="#" title="<?php echo SUBSCRIPTION_MODE_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span>
											</td>
										</tr>
										<?php } ?> -->

                                       <?php if (getSettingsValue('enable_product_scheduled_publishing') == 'Y') { ?>
                                       <div class="col-xs-12 col-sm-6 padding_B_30">
                                         <label><?php echo TEXT_PUBLISH_STATUS; ?>&nbsp;<span class="help"><a href="#" title="<?php echo PUBLISH_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></label>
                                         <?php if ($seller_vacation_mode == 'N') { ?>
                                         <input type="radio" name="rdPublishStatus" class="rdPublishStatus" value="Y" <?php if ($rdPublishStatus == "Y") {
                                          echo "checked";
                                      } elseif ($rdPublishStatus == NULL) {
                                          echo "checked";
                                      } ?>><?php echo TEXT_PUBLISH_NOW; ?>
                                      <?php } ?>
                                      <input type="radio" name="rdPublishStatus" class="rdPublishStatus" value="N" <?php if ($rdPublishStatus == "N") {
                                        echo "checked";
                                    } ?>><?php echo TEXT_PUBLISH_LATER; ?>
                                </div>

                                <div class="col-xs-12 col-sm-6 padding_B_30" id="publish_time" <?php if ($rdPublishStatus == "Y") { ?>style="display: none;"<?php } ?>>
                                 <label><?php echo TEXT_PUBLISH_DATE; ?><span class="help"><a href="#" title="<?php echo TEXT_PUBLISH_TIME_TOOLTIP; ?>"><img src="../images/question_mark.jpg" border="0" height="15"></a></span></label>
                                 <table><tr><td><input type="text" id="publishdate" name="publishdate" value="<?php echo $publishDate; ?>"></td>
                                  <td><?php echo TEXT_PUBLISH_TIME; ?></td>
                                  <td><input type="text" id="publishtime" name="publishtime" class="publishtime" value="<?php echo $publishTime; ?>" style="width: 54px;"></td>
                                  <input type="hidden" id="publishtimeval" name="publishtimeval"  value="<?php echo $publishTime; ?>" style="width: 54px;">
                              </tr>
                          </table>
                      </div>
                      <?php } ?>

                      <!--Digital Product Block Starts-->

                      <div class="col-xs-12 col-sm-12 padding_B_30"><?php //$digital_product_display = "block";?>
                       <div id="digitalProductBlock" style="display:<?php echo $digital_product_display; ?>">

                          <div class="row">
                             <div class="col-xs-12">
                                <h1><?php echo DIG_PRO_DETAILS; ?></h1>
                                <div class="image_upload_txt no_padding">
                                   <div class="digital_product_details_msg">
                                      <h2><?php echo MAX_UPLOAD_SIZE; ?>  <?php echo $maximagesizestringinPHP; ?></h2>
                                      <h3 class="txt_clean"><?php echo ALLOWED_DIGITAL_FORMATS; ?> :  <?php echo implode(",", $digital_product_types); ?></h3>
                                  </div>

                                  <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                                      <label><?php echo UPLOAD_DIGPRO; ?></label>
                                      <label class="btn-bs-file btn btn-lg btn-info upload_image">
                                         Choose File
                                         <input type="file" name="txtProductZip">
                                         <input type="hidden" name="digital_image_buffer" value="<?php echo $digital_product_zip_row['vdigital_product_name'] ?>">
                                         <input type="hidden" name="txtDigitalProduct" value="<?php echo $row["vdigital_product"] ?>">
                                     </label>
                                     <div class="clearfix"></div>
                                     <div class="input_file_name">
                                         <?php echo $digital_product_zip_row['vdigital_product_name'] ?>
                                     </div>
                                 </div>
                                 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                                  <label><?php echo DWNLD_TRY; ?></label>
                                  <select name="txtDownloadTry" class="textarea" id="txtDownloadTry">
                                     <?php
                                     for ($i = 1; $i <= 10; $i++) {
                                         ?>
                                         <option value="<?php echo $i ?>" <?php
                                            if ($digital_product_zip_row['ndownload_try'] == $i) {
                                                echo "selected";
                                            }
                                            ?>><?php echo $i ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                    <div class="clearfix"></div>
                                    <span><?php echo TIME; ?></span>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
                                  <label><?php echo D_EXPIRY; ?></label>
                                  <select name="txtDownloadExpiry" class="textarea" id="txtDownloadExpiry">
                                     <?php
                                     for ($i = 1; $i <= 10; $i++) {
                                         ?>
                                         <option value="<?php echo $i ?>" <?php if ($digital_product_zip_row['ndownload_expiry_days'] == $i) {
                                            echo "selected";
                                        } ?>><?php echo $i ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                                <div class="clearfix"></div>
                                <span><?php echo DAY; ?></span>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <!--Digital Product Block Ends-->


								<!--  <div class="col-xs-12 col-sm-6 padding_B_30">
									<label>Seller <span class="warning">*</span></label>
									<input name="" type="text" class="form-control">
								</div>> -->

                               <?php /*/////////////////////////More Image uploads Start //Manu R S - 21/09/17 */?>
                               <div class="clearfix"></div>

                               <div class="col-xs-12">
                                  <h1>Image Upload</h1>
                                  <div class="image_upload_txt">
                                     <ul>
                                        <li><span class="warning">*</span> Small Image Best Size - 400 X 300</li>
                                        <li><span class="warning">*</span> Big Image & More Images Best Size - 500 X 350</li>
                                        <li><span class="warning">*</span> Length ,Width ,Height Fields are required for Canada Post, Fedex Shipping.</li>
                                    </ul>
                                </div>
                                <div class="full_width">
                                  <?php /* 4 more images browse */ ?>
                                  <div class="full_width">
                                     <div><?php echo MORE_IMG; ?> (jpg/gif/png)</div>
                                     <div class="clearfix"></div>
                                     <div class="row">
                                        <?php
                                        $moreImages = array();
                                        $moreImagesql = "SELECT nproduct_image_id, nimage_productid,
                                        vimage_name, vimage_description, vproduct_image_delete_status
                                        FROM " . $tableprefix . "product_view_images
                                        WHERE nimage_productid= :productid";
                                        $result = $pdo->pdoQuery($moreImagesql, array("productid" => $productid))->results();
                                        if (count($result) != 0) {
                                            foreach ($result as $imRow) { $imRow = (object)$imRow;
                                                $moreImages[] = array('Name' => $imRow->vimage_name, "ID" => $imRow->nproduct_image_id);
                                            }
                                        }
                                        $moreImageMaxLImit = getSettingsValue('more_image_limit');
                                        if ($moreImageMaxLImit > 0) {
                                            for ($iCount = 0; $iCount < $moreImageMaxLImit; $iCount++) {
                                                ?>
                                                <div class="jqMoreImageContainer brd_pc_stls"><!--  style="padding:5px;border:0px solid #D3D1D1;margin:10px; position:relative; float:left;width:200px;" -->
					<!-- <?php
					if (array_key_exists($iCount, $moreImages)) {
					if (strstr($moreImages[$iCount]['Name'], "http://") || strstr($moreImages[$iCount]['Name'], "https://")) {
					$image = $moreImages[$iCount]['Name'];
					} else {
					$image = '../products/' . $moreImages[$iCount]['Name'];
					}
					?>
					<div class="jqMoreImagefromDb_<?php echo $iCount ?>">
						<div style="width:22px; position:absolute; top:18px; left:16px; height:22px;">
							<a href="<?php echo $image; ?>" class="jqMoreImageZoom thickbox"><img border="0" src="../images/srh_btn.png" title="Zoom" /></a>
						</div>
						<div style="width:22px; position:absolute; top:18px; right:26px; height:22px;">
							<a href="javascript:;" class="jqMoreImageDelete" ><img border="0" src="../images/dlt_btn.png" title="delete this image" /></a>
						</div>
						<img   class="jqMoreImage mn_pcs" src="<?php echo $image; ?>" height="180"/>  <br/>
					</div>
					<?php
					}
					?> -->
					<!-- <div style="width:180px;float:left;margin-bottom: 4px;">
						<input class="jqMoreImageFile" type="file" name="productMoreImage[]"  onchange="showMyImage(this.files, 'more_img_preview_<?php echo $iCount ?>', '<?php echo $iCount ?>', this)"/>
						<img style="display:none" src="" id="more_img_preview_<?php echo $iCount ?>" border="0" width="183" height="191">
						<input class="jqMoreImageName" type="hidden" name="productMoreImageName[]" value="<?php echo $moreImages[$iCount]['Name'] ?>"/>
						<input class="jqMoreImageID" type="hidden" name="productMoreImageID[]" value="<?php echo $moreImages[$iCount]['ID'] ?>"/>
					</div> -->

                   <div class="col-xs-12 col-sm-6 image_upload_box_outer">
                      <div class="image_upload_box_inner">
                         <div class="row">
                            <div class="col-xs-12 col-sm-8 jqMoreImageContainer">
                               <h2>More Image</h2>
                               <div class="clearfix"></div>
                               <label class="btn-bs-file btn btn-lg btn-info upload_file">
                                  Choose File
                                  <input class="jqMoreImageFile" type="file" name="productMoreImage[]"  onchange="showMyImage(this.files, 'more_img_preview_<?php echo $iCount ?>', '<?php echo $iCount ?>', this)"/>
                                  <!-- <img style="display:none" src="" id="more_img_preview_<?php echo $iCount ?>" border="0" width="183" height="191"> -->
                                  <input class="jqMoreImageName" type="hidden" name="productMoreImageName[]" value="<?php echo $moreImages[$iCount]['Name'] ?>"/>
                                  <input class="jqMoreImageID" type="hidden" name="productMoreImageID[]" value="<?php echo $moreImages[$iCount]['ID'] ?>"/>
                              </label>
                          </div>

                          <div class="col-xs-12 col-sm-4">
                              <?php
                              if (array_key_exists($iCount, $moreImages)) {
                                  if (strstr($moreImages[$iCount]['Name'], "http://") || strstr($moreImages[$iCount]['Name'], "https://")) {
                                      $image = $moreImages[$iCount]['Name'];
                                  } else {
                                      $image = '../products/' . $moreImages[$iCount]['Name'];
                                  }
                                  ?>
                                  <div class="jqMoreImagefromDb_<?php echo $iCount ?>">
                                     <div><!-- style="width:22px; position:absolute; top:18px; left:16px; height:22px;" -->
                                        <a href="<?php echo $image; ?>" class="jqMoreImageZoom thickbox"><img border="0" src="../images/srh_btn.png" title="Zoom" /></a>
                                    </div>
                                    <div><!--  style="width:22px; position:absolute; top:18px; right:26px; height:22px;" -->
                                        <a href="javascript:;" class="jqMoreImageDelete" ><img border="0" src="../images/dlt_btn.png" title="delete this image" /></a>
                                    </div>
                                    <img class="jqMoreImage mn_pcs" src="<?php echo $image; ?>" height="280"/>
                                </div>
                                <?php
                            }
                            ?>
                            <img style="display:none;" src="images/upload_img_demo.jpg" id="more_img_preview_<?php echo $iCount ?>" border="0" />
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>

        </div>
        <?php
    }
}
?>
</div>
</div>
</div>
</div>

<?php /* 4 more images browse ends */ ?>
<?php /*/////////////////////////More Image uploads Ends //Manu R S - 21/09/17 */?>


<div class="clearfix"></div>

<div class="button_outer">
   <div class="col-xs-12 col-sm-12 col-md-4"></div>
   <div class="col-xs-12 col-sm-12 col-md-4"></div>
   <div class="col-xs-12 col-sm-12 col-md-4">
      <button class="primery_btt" id="primery_btt_tab_1"><i class="fa fa-chevron-right" aria-hidden="true"></i> Proceed</button>
  </div>
  <div class="clearfix"></div>
</div>
<div class="clearfix"></div>
</div>
<div class="clearfix"></div>
</div> <!-- tab-1 ends -->

<div id="tabs-2">
   <?php /* MRS */ //Add product variants starts : by Asha July 2017, Manu R S 20/09/17 ?>
   <?php
   $options_arr = getOptionsFromCategory($ddlCategory);
   $num_of_options = count($options_arr);
   ?>
   <div id="messager" class="variant_options_msg_sucss" style="display: none;" >
    <label>
        Are you sure to delete the variant <span class="jqVariantsOptionName"></span> permanently ? This option is not used in any other products. Its safe to unlink from this category as well. Continue ?
    </label>
    <div class="clearfix"></div>
    <div class="row">
        <div class="col-xs-12 col-sm-6 col-md-6 col-lg-8"></div>
        <div class="col-xs-12 col-sm-6 col-md-3 col-lg-2">
           <input type="button" name="jqVariantsOptionDeleteCancel" class="jqVariantsOptionDeleteCancel small_light_btt" value="No">
       </div>
       <div class="col-xs-12 col-sm-3 col-md-3 col-lg-2">
           <input id="" type="button" name="jqVariantsOptionDelete" class="jqVariantsOptionDelete small_light_btt" value="Yes">
       </div>
   </div>
</div>
<div id="failedMessager" class="variant_options_msg_sucss" style="display: none;"></div>
<div id="deletedMessager" class="variant_options_msg_sucss" style="display: none;">
 <i class="fa fa-check" aria-hidden="true"></i> Option deleted successfully !!!
</div>
<div class="clearfix"></div>

<div id="navcontainer" class="pull-left padding_B_30 variant_options_dlt">
 <ul>
    <?php if($num_of_options>0)  {
        foreach($options_arr as $opt) {
            ?>
            <li class="classoption_<?php echo $opt['option_id']; ?>" id="option_<?php echo $opt['option_id']; ?>">
                <?php echo $opt['option_name'];?>
                <a href="javascript:;" class="jqVariantsOptionDeleteCheck" >
                   <i class="fa fa-times" aria-hidden="true" title="delete this variant" ></i>
               </a>
           </li>
           <?php }
       }
       ?>

   </ul>
</div>
<!-- Add product variants : by Asha July 2017 -->
<div id="jQOptDiv" class="row">
 <div class="col-xs-12 col-sm-12">
    <div class="addvariant_outer">
       <input disabled="disabled" type="text" name="txtNewOption" class="form-control" id="txtNewOption" placeholder="<?php echo ADD_VARIANTS; ?>">
       <button disabled="disabled" type="button" name="btnAddVariant" class="addvariant_btt" id="btnAddVariant"><i class="fa fa-plus" aria-hidden="true"></i></button>
   </div>
   <div class="variant_msg_duplicateproduct"> 
    <?php echo ADD_VARIANTS_WARNING; ?>
</div>
</div>
</div>


<div class="row">
 <div class="button_outer">
    <div class="col-xs-12 col-sm-12 col-md-4"></div>
    <div class="col-xs-12 col-sm-12 col-md-4"></div>
    <div class="col-xs-12 col-sm-12 col-md-4">
       <button class="primery_btt" id="primery_btt_tab_2"><i class="fa fa-chevron-right" aria-hidden="true"></i> Proceed</button>
   </div>
   <div class="clearfix"></div>
</div>
</div>

<?php /* MRS */ //Add product variants ends : by Asha July 2017, Manu R S 20/09/17 ?>
</div> <!-- tab-2 ends -->

<div id="tabs-3">
    <?php /*/////////////////////////More Options Start //Manu R S - 21/09/17 */?>
    <!-- Options come here -->
    <?php
    $queryDefaultOption = "SELECT * FROM " . $tableprefix . "product_options WHERE product_id = :productid AND default_option = 'YES'";
    $defaultOptionQ = $pdo->pdoQuery($queryDefaultOption, array("productid" => $productid))->results();
    $defaultOptionObj = (object)($defaultOptionQ[0]);
    ?>
    <div class="variant_detail_outer">
     <!-- <div class="full_width"> -->
     <?php
     $dchecked = "";
     $default = "";
     if (count($_POST['default_option']) == 0) {
       $dchecked = "checked";
       $default = "1";
   }
   if ($_POST['default_option'][0] == "1") {
       $dchecked = "checked";
       $default = $_POST['default_option'][0];
   }
   ?>

   <div class="variant_detail_top_outer">
      <div class="col-xs-12 col-sm-5 col-md-4 col-lg-6"><h1>Variants</h1></div>
      <div class="col-xs-12 col-sm-7 col-md-8 col-lg-6">
         <div class="variants_top_btt_outer">
            <!-- Radio Default Button start -->
            <!-- <button class="variants_default_show_btt">Default Product Variant <i class="fa fa-check" aria-hidden="true"></i></button> -->
            <span class="variants_default_show_btt"><input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked; ?> > &nbsp<?php echo DEFAULT_OPT; ?>
                <input type="hidden" name="product_option_id[]" value="<?php echo $defaultOptionObj->product_option_id; ?>">
                <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>">
            </span>
            <!-- Radio Default Button ends -->

            <!-- <button class="delete_btt pull-left" title="Delete Option" onClick="javascript:delete_option(this);"><i class="fa fa-trash-o" aria-hidden="true"></i></button> -->
        </div>
    </div>
    <div class="clearfix"></div>
    <div id="default_setting_box_ID">
        <!-- Radio Default Button start -->
        <?php //echo DEFAULT_OPT; ?> <!-- <input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked; ?>> -->
        <!-- Radio Default Button ends -->

<!-- <input type="hidden" name="product_option_id[]" value="<?php echo $defaultOptionObj->product_option_id; ?>">
    <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>"> -->


    <div class="clearfix"></div>
    <?php
    $options_arr = getOptionsFromCategory($ddlCategory);

//echopre($options_arr);

    $num_of_options = count($options_arr);
    if ($num_of_options != "") {
       foreach ($options_arr AS $eachoption) {
           echo "<div class='col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_". $eachoption['option_id']. "'><label>" . $eachoption['option_name'] .'</label>';
					//getting the value of the option assigned
           $query_option_value = "SELECT value
           FROM " . $tableprefix . "product_option_values
           WHERE product_option_id = :product_option_id AND option_id = :option_id";
           $query_option_valueQ = $pdo->pdoQuery($query_option_value, array("product_option_id" => $defaultOptionObj->product_option_id, "option_id" => $eachoption['option_id']))->result();
           $option_value_obj = (object)($query_option_valueQ);

                    //echopre($option_value_obj);
           ?>

           <input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" class="form-control" value="<?php echo $option_value_obj->value; ?>">
       </div>
       <?php
   }
}
?>
</div>
<div class="clearfix"></div>
</div>

<!-- </div> --> <!-- Full width -->

<!-- <div class="clearfix"></div> -->
<div class="variant_detail_bottom_outer">
  <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo ADD_PRICE; ?> &nbsp;(<?php echo $adminCurrency['currency_code']; ?>)</label>
     <input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $defaultOptionObj->additional_price; ?>" class="jqPrice jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo PRODUCT_STOCK; ?>&nbsp;<span class="required">*</span></label>
     <input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $defaultOptionObj->product_stock; ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo REORDER_LEVEL; ?></label>
     <input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $defaultOptionObj->reorder_level; ?>" class="jQNumeric form-control">
 </div>

 <?php
 $image_small = "";
 $image_big = "";
 $image_big_name = "";
 $product_image_path = "../products/";
 if ($defaultOptionObj->image_small != "") {
  if ((strstr($defaultOptionObj->image_small, "http://")) || (strstr($defaultOptionObj->image_small, "https://")) ) {
      $image_small = $defaultOptionObj->image_small;
  } else {
      $image_small = $product_image_path . $defaultOptionObj->image_small;
  }
}
if ($defaultOptionObj->image_big != "") {
  if ((strstr($defaultOptionObj->image_big, "http://")) || (strstr($defaultOptionObj->image_big, "https://"))) {
      $image_big = $defaultOptionObj->image_big;
      $image_big_name = $defaultOptionObj->image_big;
  } else {
      $image_big = $product_image_path . $defaultOptionObj->image_big;
      $image_big_name = $defaultOptionObj->image_big;
  }
}
?>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
 <label><?php echo DISCOUNT_PERC; ?></label>
 <input type="text" name="discount[]" id="discount[]" value="<?php echo $defaultOptionObj->discount; ?>" class="jQNumeric form-control">
</div>

<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
 <label><?php echo DISCOUNT_DESC; ?></label>
 <input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($defaultOptionObj->discount_description); ?>" class="form-control">
</div>

<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></label>
 <input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $defaultOptionObj->product_shipping_weight; ?>" class="clsShippingWeight jQNumeric form-control">
</div>

<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo LENGTH; ?></label>
 <input type="text" name="product_length[]" id="product_length[]" value="<?php echo $defaultOptionObj->product_length; ?>" class="clsProductlength jQNumeric form-control">
</div>

<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo WIDTH; ?></label>
 <input type="text" name="product_width[]" id="product_width[]" value="<?php echo $defaultOptionObj->product_width; ?>" class="clsProductwidth jQNumeric form-control">
</div>

<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo HEIGHT; ?></label>
 <input type="text" name="product_height[]" id="product_height[]" value="<?php echo $defaultOptionObj->product_height; ?>" class="clsProductheight jQNumeric form-control">
</div>

<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
    <label><?php echo BIG_IMG; ?>&nbsp; <span class="required"> * </span></label>
    <label class="btn-bs-file btn btn-lg btn-info upload_image">
        Choose File
        <input type="file" name="image_big[]" id="image_big" onChange="showMyImage(this.files, 'big_img_preview', 'bigimagepreview', this)" value="<?php echo $_POST['image_big'][0]; ?>">
    </label>
    <img style="display:none" src="" class="img-responsive" id="big_img_preview" border="0" width="183" height="auto">
    <?php
    if ($image_big != "") {
        ?>
        <img name="bigimagepreview[]" src="<?php echo $image_big; ?>" class="img-responsive dbbigimagepreview" id="bigimagepreview" border="0" width="183" height="auto">
        <input type="hidden" name="image_big_op[]" value="<?php echo $image_big_name; ?>">
        <?php
    }
    ?>
</div>

	<!-- <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
		<label><?php echo SMALL_IMG; ?></label>
		<label class="btn-bs-file btn btn-lg btn-info upload_image">
		Choose File
		<input type="file" name="image_small[]" id="image_small[]" value="" onChange="showMyImage(this.files, 'small_img_preview', 'smallimagepreview', this)">
		</label>
		<img style="display:none" src="" class="img-responsive" id="small_img_preview" border="0" width="183" height="auto">
		<?php
		if ($image_small != "") {
		?>
		<img id="smallimagepreview" src="<?php echo $image_small ?>" class="dbsmallimagepreview img-responsive" border="0" width="183" height="auto">
		<?php
		}
		?>
	</div> -->
   <div class="clearfix"></div>
</div>
<div class="clearfix"></div>
</div>




<?php
$oc=0;
foreach ($otherOptionQ as $otherOptionObj) {
    $oc++;
    $otherOptionObj = (object)$otherOptionObj;
    ?>

    <div class="variant_detail_outer option_block">
       <div class="variant_detail_top_outer">
          <div class="col-xs-12 col-sm-5 col-md-4 col-lg-6">
             <h1>Variants</h1>
         </div>
         <div class="col-xs-12 col-sm-7 col-md-8 col-lg-6">
             <?php
             $dchecked = "";
             $default = "";
             ?>
             <div class="variants_top_btt_outer">
                <span class="variants_default_show_btt">
                   <input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked; ?>>
                   <input type="hidden" name="product_option_id[]" value="<?php echo $otherOptionObj->product_option_id; ?>">
                   <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $default; ?>"> &nbsp;
                   <?php echo DEFAULT_OPT; ?>
               </span>
               <button class="delete_btt pull-left" title="Delete Option" onClick="javascript:delete_option(this);">
                   <i class="fa fa-trash-o" aria-hidden="true"></i>
               </button>
           </div>
           <div class="clearfix"></div>
       </div>
       <div class="clearfix"></div>

       <div class="default_setting_box" id="default_setting_box_ID_<?php echo $oc; ?>_<?php echo $oc; ?>">

         <?php
         $options_arr = getOptionsFromCategory($ddlCategory);
         $num_of_options = count($options_arr);
         if ($num_of_options != "") {
             $k = 0;
             foreach ($options_arr AS $eachoption) {
                 echo "<div class='col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_". $eachoption['option_id']. "'><label>" . $eachoption['option_name'] .'</label>';
			//getting the value of the option assigned
                 $query_option_value = "SELECT value FROM " . $tableprefix . "product_option_values WHERE product_option_id = :product_option_id AND option_id = :option_id";
                 $query_option_valueQ = $pdo->pdoQuery($query_option_value, array("product_option_id" => $otherOptionObj->product_option_id, "option_id" => $eachoption['option_id']))->results();
                 $option_value_obj = (object)($query_option_valueQ[0]);
                 ?>
                 <input type="text" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $option_value_obj->value; ?>" class="form-control">

             </div>
             <?php
         }
     }
     ?>
 </div>

 <div class="clearfix"></div>
</div>

<div class="clearfix"></div>

<div class="variant_detail_bottom_outer">
  <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo ADD_PRICE; ?> (<?php echo $adminCurrency['currency_code']; ?>)</label>
     <input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $otherOptionObj->additional_price; ?>" class="jqPrice form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo PRODUCT_STOCK; ?> <span class="required">*</span></label>
     <input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $otherOptionObj->product_stock; ?>" class="form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo REORDER_LEVEL; ?></label>
     <input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $otherOptionObj->reorder_level; ?>" class="form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
    <label><?php echo DISCOUNT_PERC; ?></label>
    <input type="text" name="discount[]" id="discount[]" value="<?php echo $otherOptionObj->discount; ?>" class="form-control">
</div>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
    <label><?php echo DISCOUNT_DESC; ?></label>
    <input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($otherOptionObj->discount_description); ?>" class="form-control">
</div>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo SW_LBS; ?>&nbsp;<span class="required">*</span></label>
 <input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $otherOptionObj->product_shipping_weight; ?>" class="form-control">
</div>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo LENGTH; ?></label>
 <input type="text" name="product_length[]" id="product_length[]" value="<?php echo $otherOptionObj->product_length; ?>" class="form-control">
</div>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo WIDTH; ?></label>
 <input type="text" name="product_width[]" id="product_width[]" value="<?php echo $otherOptionObj->product_width; ?>" class="form-control">
</div>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
 <label><?php echo HEIGHT; ?></label>
 <input type="text" name="product_height[]" id="product_height[]" value="<?php echo $otherOptionObj->product_height; ?>" class="form-control">
 <div class="clearfix"></div>

</div>

<?php
$image_small = "";
$image_big = "";
$image_big_name = "";
$product_image_path = "../products/";
if ($otherOptionObj->image_small != "") {
  if ((strstr($otherOptionObj->image_small, "http://")) || (strstr($otherOptionObj->image_small, "https://")))  {
      $image_small = $otherOptionObj->image_small;
  } else {
      $image_small = $product_image_path . $otherOptionObj->image_small;
  }
}
if ($otherOptionObj->image_big != "") {
  if (strstr($otherOptionObj->image_big, "http://") || strstr($otherOptionObj->image_big, "https://")) {
      $image_big = $otherOptionObj->image_big;
      $image_big_name = $otherOptionObj->image_big;
  } else {
      $image_big = $product_image_path . $otherOptionObj->image_big;
      $image_big_name = $otherOptionObj->image_big;
  }
}
?>
<div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
 <label><?php echo BIG_IMG; ?>&nbsp; <span class="required"> * </span></label>
 <label class="btn-bs-file btn btn-lg btn-info upload_image">
    Choose File
    <input type="file" name="image_big[]" id="image_big[]" value="" onChange="showBigImages(this.files, '<?php echo $k ?>',this);">
</label>

<?php
if ($image_big != "") {
 ?>
 <img name="bigimagepreview[]" src="<?php echo $image_big ?>" id="big_img_preview_<?php echo $k ?>" border="0" width="183" height="auto">
 <input type="hidden" name="image_big_op[]" value="<?php echo $image_big_name; ?>">
 <?php
}
?>
</div>
 		<!-- <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
			<label><?php echo SMALL_IMG; ?></label>
			<label class="btn-bs-file btn btn-lg btn-info upload_image">
				Choose File
				<input type="file" name="image_small[]" id="image_small[]" value="" onChange="showSmallImages(this.files, '<?php echo $k ?>',this);">
			</label>

			<?php
			if ($image_small != "") {
			?>
			<img src="<?php echo $image_small ?>" border="0" width="183" height="auto" id="small_img_preview_<?php echo $k ?>">
			<?php
			}
			?>
		</div> -->
		<div class="clearfix"></div>
  </div>

</div>

<?php
}
?>

<?php  //$options_count=2;
for ($i = 1; $i < $options_count; $i++) {
    if ($_POST['product_option_id'] == "") {
        ?>
        <div class="variant_detail_outer option_block  pull-left full-width">
           <div class="variant_detail_top_outer pull-left full-width">
              <div class="col-xs-12 col-sm-5 col-md-4 col-lg-6">
                 <h1>Variants</h1>
             </div>

             <div class="col-xs-12 col-sm-7 col-md-8 col-lg-6">
                 <div class="variants_top_btt_outer">
                    <button class="variants_default_show_btt">
                       <input type="radio" name="default" id="default" onClick="setDefaultOption(this);" <?php echo $dchecked ?>>
                       <input type="hidden" name="product_option_id[]" value="">
                       <input type="hidden" class="default_option" name="default_option[]"  id="default_option[]" value="<?php echo $_POST['default_option'][$i] ?>">
                       <?php echo DEFAULT_OPT; ?>
                   </button>
                   <button class="delete_btt pull-left" title="Delete Option" onClick="javascript:delete_option(this);"><i class="fa fa-trash-o" aria-hidden="true"></i></button>

                   <div class="clarfix"></div>
               </div>
               <div class="clearfix"></div>
           </div>

           <div class="clearfix"></div>
           <?php
           $dchecked = "";
           if ($_POST['default_option'][$i] == "1") {
             $dchecked = "checked";
         }
         ?>
         <div class="default_setting_box">

             <?php
             $options_arr = getOptionsFromCategory($ddlCategory);
             $num_of_options = count($options_arr);
             if ($num_of_options != "") {
                 foreach ($options_arr AS $eachoption) {
                     echo "<div class='col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 classoption_". $eachoption['option_id']. "'> <label>" . $eachoption['option_name'] .'</label>';
                     ?>
                     <input type="text" class="form-control" name="option_<?php echo $eachoption['option_id'] ?>[]" value="<?php echo $_POST['option_' . $eachoption['option_id']][$i]; ?>">
                     <div class="clarfix"></div>
                 </div>
                 <?php
             }
         }
         ?>
         <div class="clarfix"></div>
     </div>

     <div class="clarfix"></div>
 </div>

 <div class="variant_detail_bottom_outer pull-left full-width">
  <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo ADD_PRICE; ?> (<?php echo $adminCurrency['currency_code']; ?>)</label>
     <input type="text" name="additional_price[]" id="additional_price[]"  onpaste="return false;" value="<?php echo $_POST['additional_price'][$i] ?>" class="jqPrice jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo PRODUCT_STOCK; ?> <span class="required">*</span></label>
     <input type="text" name="product_stock[]" id="product_stock[]" value="<?php echo $_POST['product_stock'][$i] ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo REORDER_LEVEL; ?></label>
     <input type="text" name="reorder_level[]" id="reorder_level[]" value="<?php echo $_POST['reorder_level'][$i] ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo DISCOUNT_PERC; ?></label>
     <input type="text" name="discount[]" id="discount[]" value="<?php echo $_POST['discount'][$i] ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo DISCOUNT_DESC; ?></label>
     <input type="text" name="discount_description[]" id="discount_description[]" value="<?php echo stripslashes($_POST['discount_description'][$i]) ?>" class="form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
     <label><?php echo SW_LBS; ?> <span class="required">*</span></label>
     <input type="text" name="product_shipping_weight[]" id="product_shipping_weight[]" value="<?php echo $_POST['product_shipping_weight'][$i] ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
     <label><?php echo LENGTH; ?></label>
     <input type="text" name="product_length[]" id="product_length[]" value="<?php echo $_POST['product_length'][$i] ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30 canshipBlock" style="display:<?php echo $canshipblock; ?>">
     <label><?php echo WIDTH; ?></label>
     <input type="text" name="product_width[]" id="product_width[]" value="<?php echo $_POST['product_width'][$i] ?>" class="jQNumeric form-control">
 </div>
 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo HEIGHT; ?></label>
     <input type="text" name="product_height[]" id="product_height[]" value="<?php echo $_POST['product_height'][$i] ?>" class="jQNumeric form-control">
 </div>

 <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
     <label><?php echo BIG_IMG; ?> <span class="required">*</span></label>
     <label class="btn-bs-file btn btn-lg btn-info upload_image">
        <input type="file" name="image_big[]" id="image_big[]" onChange="showBigImages(this.files,'<?php echo $i ?>',this)" value="<?php echo $_POST['image_big'][$i] ?>">
    </label>
    <img name="bigimagepreview[]" src="" style="display:none" width="183" height="auto" id="big_img_preview_<?php echo ($i - 1) ?>">
</div>
		<!-- <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4 padding_B_30">
			<label><?php echo SMALL_IMG; ?></label>
			<label class="btn-bs-file btn btn-lg btn-info upload_image">
				<input type="file" name="image_small[]" id="image_small[]" onChange="showSmallImages(this.files,'<?php echo $i ?>',this)" value="<?php echo $_POST['image_small'][$i] ?>">
			</label>
			<img style="display:none" src="" id="small_img_preview_<?php echo $i ?>" border="0" width="183" height="auto">
		</div> -->

       <div class="clarfix"></div>
   </div>

   <div class="clarfix"></div>

</div>

<?php
}//end of if
}//end of for
?>

<?php
$options_arr = getOptionsFromCategory($ddlCategory);
$num_of_options = count($options_arr);
//if ($num_of_options >= 1) {
?>

<div class="table-responsive">
    <div id="options_window" border="0"></div>
</div>


<div class="row">
   <div class="button_outer no_padding">
      <div class="col-xs-12 col-sm-12 col-md-4">
         <button type="button" id="add_more_options" name="add_more_options"  class="secondary"><i class="fa fa-plus" aria-hidden="true"></i> <?php echo ADD_OPTIONS; ?></button>
         <input type="hidden" name="add_value" id="add_value" value="<?php echo ($num_of_options - 1); ?>">
     </div>
     <div class="col-xs-12 col-sm-12 col-md-4"></div>
     <div class="col-xs-12 col-sm-12 col-md-4">
         <button type="submit" value="<?php echo BTN_SAVE_CHANGES; ?>" class="primery_btt" name="btnSaveChanges" onClick="return validateProductForm(3,'e','d');"><i class="fa fa-floppy-o" aria-hidden="true"></i> <?php echo BTN_SAVE_CHANGES; ?></button>
     </div>
     <div class="clearfix"></div>
 </div>
</div>

<?php
								//}
?>
<?php /*/////////////////////////More Options Ends //Manu R S - 21/09/17 */?>

<?php /*/////////////////////////Save button Start //Manu R S - 21/09/17 */?>
<div class="row">
    <div class="button_outer">
       <!-- <div class="col-xs-12 col-sm-12 col-md-4"></div> -->

       <input type="hidden" name="product_name_old" value="<?php echo $txtProductName; ?>">
       <div class="col-xs-12 col-sm-12 col-md-4">
          <button type="button" class="tertiary_btt" value="<?php echo BACK_CAT; ?>" name="btnBack" onClick="window.location.href = 'catalog.php?catid=<?php echo $ddlCategory ?>';" ><i class="fa fa-chevron-left" aria-hidden="true"></i> <?php echo BACK_CAT; ?></button>
      </div>
      <div class="col-xs-12 col-sm-12 col-md-4">
          <button type="button" class="tertiary_btt" value="<?php echo BACK_PDT_LIST; ?>" name="btnBack" onClick="window.location.href = 'listProducts.php?page=<?php echo $_GET['page'] ?>';"><i class="fa fa-chevron-left" aria-hidden="true"></i> <?php echo BACK_PDT_LIST; ?></button>
      </div>
      <div class="col-xs-12 col-sm-12 col-md-4">
          <button type="submit" class="tertiary_btt" name="btnDelete" onClick="return confirmDelete();" value="<?php echo DELETE; ?>"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo DELETE; ?></button>
      </div>

 									<!-- <div class="col-xs-12 col-sm-12 col-md-8">
                                  <button class="primery_btt"><i class="fa fa-chevron-right" aria-hidden="true"></i> Proceed</button> -->
                                  <!--  <tr><td colspan="3" align="center"> -->

 											<!-- </td>
										</tr>


									</div>-->
									<div class="clearfix"></div>
								</div>
							</div>
							<?php /*/////////////////////////Save button Ends //Manu R S - 21/09/17 */?>

                       </div> <!-- tab-3 ends -->

                       <div class="clearfix"></div>

                   </form> <!-- form ends -->

                   <?php /*/////////////////////////Input Fields ENDS //Manu R S - 20/09/17 */?>
               </div> <!-- row ends -->
           </div> <!-- form_outer ends -->
       </div> <!-- right_cont_inner_R ends -->
   </div> <!-- right_cont_inner ends -->
</div> <!-- right_main_cont_inner ends -->
</div> <!-- right_main_cont_outer ends -->
</div> <!-- contant_area ends -->
<?php /*/////////////////////////Contant Area Ends //Manu R S - 21/09/17 */?>
</div> <!-- main_outer ends -->
<?php /*/////////////////////////Footer Start //Manu R S - 21/09/17 */
include "../includes/admin_new_footer.php";
/*/////////////////////////Footer Ends //Manu R S - 21/09/17 */?>
</body>
